/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCEnumGroupOption;
import com.jetbrains.cidr.lang.settings.OCOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class OCAutoImportOptionsProvider
implements AutoImportOptionsProvider {
    private JPanel myHeaderImportStyleComponent;
    private JCheckBox myShowImportPopupBox;
    private OCEnumGroupOption<OCCodeStyleSettings.HeaderImportStyle> myHeaderImportStyleOption;

    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultAnchor(17);
        this.myHeaderImportStyleOption = new OCEnumGroupOption<OCCodeStyleSettings.HeaderImportStyle>("Auto import", OCEnumGroupOption.Presentation.Section, (T[])OCCodeStyleSettings.HeaderImportStyle.values(), "Predeclare in .h/Import in .m", "Import in .h");
        this.myShowImportPopupBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.import.popup", (Object[])new Object[0]));
        this.myHeaderImportStyleComponent = this.myHeaderImportStyleOption.createComponent(false);
        panel2.add((Component)this.myShowImportPopupBox, bag.nextLine());
        if (PlatformUtils.isAppCode()) {
            panel2.add((Component)this.myHeaderImportStyleComponent, bag.nextLine());
        }
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel2, "West");
        wrapper.setBorder((Border)IdeBorderFactory.createTitledBorder((String)OCLanguage.getInstance().getDisplayName(), (boolean)true));
        return wrapper;
    }

    public boolean isModified() {
        OCCodeInsightSettings settings = OCCodeInsightSettings.getInstance();
        boolean isModified = OCAutoImportOptionsProvider.isModified(this.myHeaderImportStyleOption, this.myHeaderImportStyleComponent, settings.HEADER_IMPORT_STYLE);
        return isModified |= OCAutoImportOptionsProvider.isModified(this.myShowImportPopupBox, settings.SHOW_IMPORT_POPUP);
    }

    private static <T, Comp extends JComponent> boolean isModified(OCOption<T, Comp> option, Comp component, T value2) {
        return !option.getSelectedValue(component).equals(value2);
    }

    private static boolean isModified(JToggleButton checkBox, boolean value2) {
        return checkBox.isSelected() != value2;
    }

    public void apply() throws ConfigurationException {
        OCCodeInsightSettings settings = OCCodeInsightSettings.getInstance();
        settings.HEADER_IMPORT_STYLE = this.myHeaderImportStyleOption.getSelectedValue(this.myHeaderImportStyleComponent);
        settings.SHOW_IMPORT_POPUP = this.myShowImportPopupBox.isSelected();
    }

    public void reset() {
        OCCodeInsightSettings settings = OCCodeInsightSettings.getInstance();
        this.myShowImportPopupBox.setSelected(settings.SHOW_IMPORT_POPUP);
        this.myHeaderImportStyleOption.selectValue(this.myHeaderImportStyleComponent, settings.HEADER_IMPORT_STYLE);
    }
}

