/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.formatter.OCLLVMCodeStyle;
import org.jetbrains.annotations.NotNull;

public class OCLLDBCodeStyle
extends OCLLVMCodeStyle {
    public OCLLDBCodeStyle() {
        super("LLDB", "lldb");
    }

    @Override
    protected void customize(@NotNull CodeStyleSettings settings) {
        super.customize(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        commonSettings.FINALLY_ON_NEW_LINE = true;
        commonSettings.CATCH_ON_NEW_LINE = true;
        commonSettings.WHILE_ON_NEW_LINE = true;
        commonSettings.ELSE_ON_NEW_LINE = true;
        ocSettings.BLOCK_BRACE_PLACEMENT = 5;
        ocSettings.METHOD_BRACE_PLACEMENT = 5;
        ocSettings.FUNCTION_BRACE_PLACEMENT = 5;
        ocSettings.NAMESPACE_BRACE_PLACEMENT = 5;
        commonSettings.CLASS_BRACE_STYLE = 5;
        commonSettings.BRACE_STYLE = 5;
        ocSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP = 2;
        ocSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP = 2;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 5;
        commonSettings.INDENT_CASE_FROM_SWITCH = true;
        assert (indentOptions != null);
        indentOptions.INDENT_SIZE = 4;
        ocSettings.INDENT_INSIDE_CODE_BLOCK = 4;
        ocSettings.INDENT_CLASS_MEMBERS = 4;
        ocSettings.INDENT_C_STRUCT_MEMBERS = 4;
    }
}

