/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedNameWithArguments
extends OCQualifiedName {
    @NotNull
    private List<OCTypeArgument> myArguments;

    public OCQualifiedNameWithArguments(@Nullable OCQualifiedName qualifier, @Nullable String name, @NotNull List<OCTypeArgument> arguments) {
        this.myQualifier = qualifier;
        this.myName = name;
        this.myArguments = arguments;
    }

    public OCQualifiedNameWithArguments() {
    }

    public OCQualifiedNameWithArguments(@NotNull OCQualifiedName qualifiedName, @NotNull List<OCTypeArgument> arguments) {
        this(qualifiedName.getQualifier(), qualifiedName.getName(), arguments);
    }

    @NotNull
    public List<OCTypeArgument> getArguments() {
        return this.myArguments;
    }

    @Override
    public OCQualifiedName dropArguments() {
        return OCQualifiedName.with(this.myQualifier, this.myName);
    }

    @Override
    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        return new OCQualifiedNameWithArguments(qualifier, this.myName, this.myArguments);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myArguments.hashCode();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCQualifiedNameWithArguments f = (OCQualifiedNameWithArguments)first;
        OCQualifiedNameWithArguments s = (OCQualifiedNameWithArguments)second;
        return c.equalIterable(f.myArguments, s.myArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        String result2;
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(super.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth));
            builder.append('<');
            if (templateDepth < 10) {
                String args = StringUtil.join(this.myArguments, argument -> argument.getNameForPresentation(presentation, context, includeGlobalQualifier, templateDepth + 1), (String)", ");
                if (args.startsWith("::")) {
                    builder.append(" ");
                }
                builder.append(args);
            } else {
                builder.append("...");
            }
            builder.append('>');
            result2 = builder.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
        return result2;
    }
}

