/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.types.OCType;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCSymbol<T extends PsiElement>
extends PsiElementNavigationItem,
Comparable<OCSymbol>,
DataProvider,
Serializable,
ProjectAndVirtualFileOwner,
DeepEqual.Equality {
    public static final String UNNAMED = "<unnamed>";
    public static final String ATTRIBUTE_UNUSED_MACRO = "__unused";
    public static final String ATTRIBUTE_MIN_IOS_VERSION = "__min_ios_version_";
    public static final String ATTRIBUTE_MIN_MACOS_VERSION = "__min_macos_version_";
    public static final String ATTRIBUTE_RETURNS_RETAINED_MACRO = "NS_RETURNS_RETAINED";
    public static final Condition<OCSymbol> PREDIFINITION_CONDITION = symbol -> symbol.isPredeclaration();
    public static final Condition<OCSymbol> NON_PREDIFINITION_CONDITION = symbol -> !symbol.isPredeclaration();
    public static final Condition<OCSymbol> NON_FANTOM_SYMBOL_CONDITION = symbol -> symbol.getContainingFile() != null || symbol.getOffset() != 0;
    public static final Condition<OCSymbol> HEADER_DECLARATION_CONDITION = symbol -> {
        OCFile file2 = symbol.getContainingOCFile();
        return file2 != null && file2.isHeader();
    };

    @NotNull
    public OCType getType();

    @NotNull
    public OCType getResolvedType();

    public OCType getResolvedType(boolean var1);

    public boolean isGlobal();

    public boolean isTopLevel();

    public boolean isCallable();

    public boolean isDefinition();

    public boolean isPredeclaration();

    @NotNull
    public List<String> getAttributes();

    public void addAttributes(List<String> var1);

    public boolean isUnnamed();

    public Object getData(@NonNls String var1);

    @Nullable
    public T locateDefinition();

    public void updateOffset(int var1, int var2, int var3);

    public void compact();

    @NotNull
    public String getName();

    @NotNull
    public String getSignature();

    @Nullable
    public TextRange getScope();

    @NotNull
    public String getPresentableName();

    @Nullable
    public String getLocationString();

    public boolean isSynthetic();

    @NotNull
    public OCSymbolKind getKind();

    @NotNull
    public String getNameWithKindLowercase();

    @NotNull
    public String getNameWithKindUppercase();

    public String getKindLowercase();

    public String getKindUppercase();

    @Nullable
    public OCSymbol getDefinitionSymbol();

    public boolean processAssociatedSymbols(Processor<OCSymbol> var1);

    @Nullable
    public OCSymbol getAssociatedSymbol();

    public OCSymbol getFirstPredeclaration();

    public boolean processPredeclarations(Processor<OCSymbol> var1);

    public boolean processSameSymbols(Processor<OCSymbol> var1);

    @Nullable
    public PsiFile getContainingPsiFile();

    @Nullable
    public OCFile getContainingOCFile();

    public int getOffset();

    public long getComplexOffset();

    @Nullable
    public Icon getIcon();

    @Nullable
    public Icon getBaseIcon();

    @Nullable
    public Icon computeFullIcon(@Nullable T var1);

    public boolean isSameSymbol(@Nullable OCSymbol var1);

    public int hashCodeExcludingOffset();

    public OCType getEffectiveType();

    @NotNull
    public OCType getEffectiveResolvedType();

    public boolean isDeprecated();

    public String getDeprecatedMessage();

    public boolean isUnavailable();

    public String getUnavailableMessage();

    public boolean isForbiddenByARC(@NotNull PsiElement var1);

    public boolean isTransparentUnion();

    public boolean hasAttribute(String var1);

    @Nullable
    public String getAttributeParameters(String var1);

    @NotNull
    public OCSymbol getDelegate();

    @NotNull
    public String getPresentableText();
}

