/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolBase<T extends PsiElement>
implements OCSymbol<T> {
    private static final String ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE = "\"not available in automatic reference counting mode\"";
    @Nullable
    protected transient Project myProject;
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;

    public OCSymbolBase(@Nullable Project project2, @Nullable VirtualFile file2, long complexOffset) {
        this.myProject = project2;
        this.myFile = file2;
        this.myComplexOffset = complexOffset;
    }

    public OCSymbolBase() {
    }

    @Nullable
    public static PsiElement locateDefinition(@Nullable OCSymbol symbol) {
        return symbol != null ? (PsiElement)symbol.locateDefinition() : null;
    }

    public static List<PsiElement> locateDefinitions(List<? extends OCSymbol> symbols) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(symbols.size());
        for (OCSymbol oCSymbol : symbols) {
            Object element = oCSymbol.locateDefinition();
            if (element == null) continue;
            result2.add((PsiElement)element);
        }
        return result2;
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        return symbol == null ? "<unnamed>" : symbol.getName();
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind2 = symbol.getKind().getNameLowercase() + " ";
        String name = symbol.getPresentableName();
        if (name.startsWith(kind2)) {
            return name.substring(kind2.length());
        }
        return name;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(String name, OCSymbolKind symbolKind, Project project2, VirtualFile context) {
        return OCSymbolBase.findSymbolDefinition(name, symbolKind, project2, context, null);
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(String name, OCSymbolKind symbolKind, Project project2, VirtualFile context, @Nullable Condition<T> condition2) {
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project2, name, (Condition<OCSymbol>)((Condition)symbol -> symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition2 == null || condition2.value(symbol))), context);
    }

    @Override
    public void init(@Nullable Project project2, @Nullable VirtualFile file2) {
        this.myProject = project2;
        this.myFile = file2;
    }

    @Override
    @NotNull
    public OCType getType() {
        return OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    public OCType getResolvedType() {
        return this.getType().resolve(this.getContainingOCFile());
    }

    @Override
    public OCType getResolvedType(boolean ignoringImports) {
        return this.getType().resolve(this.getContainingOCFile(), ignoringImports);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isTopLevel() {
        return this.isGlobal();
    }

    @Override
    public boolean isCallable() {
        return this.getKind().isCallable();
    }

    @Override
    public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    @Override
    public boolean isPredeclaration() {
        return this.getKind().isPredeclaration();
    }

    @Override
    public boolean isUnnamed() {
        return "<unnamed>".equals(this.getName());
    }

    protected Class<? extends T> getPsiElementClass() {
        return this.getKind().getPsiElementClass();
    }

    @Override
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return new OCSymbolHolderVirtualPsiElement(this);
        }
        return null;
    }

    @Override
    @Nullable
    public T locateDefinition() {
        Class<T> elementClass = this.getPsiElementClass();
        if (this.myFile == null || this.myProject == null || !this.myFile.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (psiFile == null) {
            return null;
        }
        PsiElement cur = psiFile.findElementAt(this.getOffset());
        if (cur == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        while (cur != null) {
            long symbolComplexOffset;
            long curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur);
            if (curComplexOffset == (symbolComplexOffset = this.getComplexOffset())) {
                T definitionAtPrev;
                T definitionAtCur = OCSymbolBase.findParentDefinition(cur, elementClass, symbolComplexOffset);
                if (definitionAtCur != null) {
                    return definitionAtCur;
                }
                if (this.isUnnamed() && (definitionAtPrev = OCSymbolBase.findParentDefinition(PsiTreeUtil.prevLeaf((PsiElement)cur), elementClass, symbolComplexOffset)) != null) {
                    return definitionAtPrev;
                }
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) != OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) {
                return null;
            }
            cur = PsiTreeUtil.prevLeaf((PsiElement)cur);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T findParentDefinition(@Nullable PsiElement cur, @NotNull Class<T> elementClass, long symbolComplexOffset) {
        if (cur == null) {
            return null;
        }
        PsiElement parent = cur;
        do {
            if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
            return (T)parent;
        } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
        return null;
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        if (this.getOffset() > start) {
            this.myComplexOffset += (long)lengthShift;
        }
    }

    @Override
    @NotNull
    public String getSignature() {
        return this.getName();
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return null;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.getName();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.getPresentableName();
    }

    @Override
    @Nullable
    public String getLocationString() {
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Override
    public boolean isSynthetic() {
        return this.myProject == null;
    }

    public String toString() {
        return (Object)((Object)this.getKind()) + "[" + this.getName() + "]@" + this.getOffset();
    }

    @Override
    @NotNull
    public abstract OCSymbolKind getKind();

    @Override
    @NotNull
    public String getNameWithKindLowercase() {
        return this.getKindLowercase() + " '" + this.getPresentableName() + "'";
    }

    @Override
    @NotNull
    public String getNameWithKindUppercase() {
        return this.getKindUppercase() + " '" + this.getPresentableName() + "'";
    }

    @Override
    public String getKindLowercase() {
        return StringUtil.decapitalize((String)this.getKindUppercase());
    }

    @Override
    public String getKindUppercase() {
        return this.getKind().getNameUppercase();
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol() {
        if (this.isPredeclaration()) {
            return OCSymbolBase.findSymbolDefinition(this.getName(), this.getKind(), this.myProject, this.myFile);
        }
        return this;
    }

    @Override
    public boolean processAssociatedSymbols(Processor<OCSymbol> processor2) {
        OCSymbol associatedSymbol = this.getAssociatedSymbol();
        return associatedSymbol == null || processor2.process((Object)associatedSymbol);
    }

    @Override
    @Nullable
    public OCSymbol getAssociatedSymbol() {
        return null;
    }

    @Override
    public OCSymbol getFirstPredeclaration() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processPredeclarations((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public boolean processPredeclarations(Processor<OCSymbol> processor2) {
        return this.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(PREDIFINITION_CONDITION, processor2));
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, (Processor<OCSymbol>)((Processor)symbol -> symbol.getClass() != this.getClass() || processor2.process(symbol)), this.getName());
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public PsiFile getContainingPsiFile() {
        VirtualFile containingFile = this.getContainingFile();
        Project project2 = this.getProject();
        if (project2 != null && containingFile != null && containingFile.isValid()) {
            return PsiManager.getInstance((Project)project2).findFile(containingFile);
        }
        return null;
    }

    @Override
    @Nullable
    public OCFile getContainingOCFile() {
        PsiFile file2 = this.getContainingPsiFile();
        return file2 instanceof OCFile ? (OCFile)file2 : null;
    }

    @Override
    public int getOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.myComplexOffset);
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Deprecated
    public PsiElement getTargetElement() {
        return new OCSymbolHolderVirtualPsiElement(this);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public void navigate(boolean requestFocus) {
        PsiNavigateUtil.navigate(this.locateDefinition());
    }

    public boolean canNavigate() {
        return this.locateDefinition() != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.computeFullIcon(null);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.getKind().getIcon();
    }

    @Override
    @Nullable
    public Icon computeFullIcon(@Nullable T symbolElement) {
        return this.getBaseIcon();
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return OCSymbolBase.this.getPresentableText();
            }

            public String getLocationString() {
                return OCSymbolBase.this.getLocationString();
            }

            public Icon getIcon(boolean open2) {
                return OCSymbolBase.this.getIcon();
            }
        };
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol) {
        return this.equals(symbol);
    }

    public int hashCode() {
        int result2 = this.hashCodeExcludingOffset();
        result2 = 31 * result2 + this.getOffset();
        return result2;
    }

    @Override
    public int compareTo(OCSymbol symbol) {
        return this.getPresentableName().compareTo(symbol.getPresentableName());
    }

    @Override
    public OCType getEffectiveType() {
        return this.getType();
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType() {
        return this.getResolvedType();
    }

    @Override
    public boolean isDeprecated() {
        return this.hasAttribute("deprecated");
    }

    @Override
    public String getDeprecatedMessage() {
        String message2 = this.getNameWithKindUppercase() + " is deprecated";
        String parameters2 = this.getAttributeParameters("deprecated");
        return parameters2 != null ? message2 + ": " + StringUtil.unquoteString((String)parameters2) : message2;
    }

    @Override
    public boolean isUnavailable() {
        return this.hasAttribute("unavailable") && !ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable"));
    }

    @Override
    public String getUnavailableMessage() {
        String message2 = this.getNameWithKindUppercase() + " is unavailable";
        String parameters2 = this.getAttributeParameters("unavailable");
        return parameters2 != null ? message2 + ": " + StringUtil.unquoteString((String)parameters2) : message2;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        return this.hasAttribute("unavailable") && ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable")) && OCCompilerHelper.isArcEnabled(context.getContainingFile());
    }

    @Override
    public boolean isTransparentUnion() {
        return this.hasAttribute("transparent_union");
    }

    @Override
    public boolean hasAttribute(String attribute) {
        List<String> attributes = this.getAttributes();
        return attributes.contains(attribute) || attributes.contains("__" + attribute + "__");
    }

    @Override
    @Nullable
    public String getAttributeParameters(String attribute) {
        List<String> attributes = this.getAttributes();
        for (String curAttribute : attributes) {
            if (!curAttribute.startsWith(attribute + '#')) continue;
            return curAttribute.substring(attribute.length() + 1);
        }
        return null;
    }

    @Override
    @NotNull
    public OCSymbol getDelegate() {
        return this;
    }
}

