/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCSymbolGroupContext {
    public static final OCSymbolGroupContext CLASS_CONTEXT = new OCSymbolGroupContext("class", OCSymbolKind.INTERFACE, OCSymbolKind.IMPLEMENTATION, OCSymbolKind.COMPATIBILITY_ALIAS);
    public static final OCSymbolGroupContext PROTOCOL_CONTEXT = new OCSymbolGroupContext("protocol", OCSymbolKind.PROTOCOL);
    private static final OCSymbolGroupContext C_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.BUILTIN_SYMBOL);
    private static final OCSymbolGroupContext OBJC_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.INTERFACE, OCSymbolKind.IMPLEMENTATION, OCSymbolKind.COMPATIBILITY_ALIAS, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.BUILTIN_SYMBOL, OCSymbolKind.GENERIC_PARAMETER);
    private static final OCSymbolGroupContext CPP_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.BUILTIN_SYMBOL);
    private static final OCSymbolGroupContext OBJCPP_TYPE_CONTEXT = new OCSymbolGroupContext("type", OCSymbolKind.INTERFACE, OCSymbolKind.IMPLEMENTATION, OCSymbolKind.COMPATIBILITY_ALIAS, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.BUILTIN_SYMBOL, OCSymbolKind.GENERIC_PARAMETER);
    public static final OCSymbolGroupContext CONSTRUCTOR_CONTEXT = new OCSymbolGroupContext("constructor", OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION, OCSymbolKind.TYPEDEF, OCSymbolKind.STRUCT, OCSymbolKind.UNION, OCSymbolKind.ENUM, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.BUILTIN_SYMBOL);
    public static final OCSymbolGroupContext MACRO_OR_MACRO_PARAMETER_CONTEXT = new OCSymbolGroupContext("macro or macro parameter", OCSymbolKind.MACRO, OCSymbolKind.MACRO_PARAMETER, OCSymbolKind.BUILTIN_SYMBOL);
    public static final OCSymbolGroupContext MACRO_OR_UNDEF_OR_MACRO_PARAMETER_CONTEXT = new OCSymbolGroupContext("macro or macro parameter", OCSymbolKind.MACRO, OCSymbolKind.UNDEF_MACRO, OCSymbolKind.MACRO_PARAMETER);
    public static final OCSymbolGroupContext MACRO_CONTEXT = new OCSymbolGroupContext("macro", OCSymbolKind.MACRO, OCSymbolKind.BUILTIN_SYMBOL, OCSymbolKind.COMPATIBILITY_ALIAS);
    public static final OCSymbolGroupContext STRUCT_FIELD_CONTEXT = new OCSymbolGroupContext("struct field", OCSymbolKind.STRUCT_FIELD);
    public static final OCSymbolGroupContext LABEL_CONTEXT = new OCSymbolGroupContext(new OCSymbolContext(null, OCSymbolKind.LABEL, null));
    private final String myName;
    private final List<OCSymbolContext> mySymbolContexts;

    public static OCSymbolGroupContext typeContext(OCLanguageKind kind2) {
        if (kind2.isCpp()) {
            return kind2.isObjC() ? OBJCPP_TYPE_CONTEXT : CPP_TYPE_CONTEXT;
        }
        return kind2.isObjC() ? OBJC_TYPE_CONTEXT : C_TYPE_CONTEXT;
    }

    public OCSymbolGroupContext(String name, OCSymbolKind ... symbolKinds) {
        this.myName = name;
        this.mySymbolContexts = new ArrayList<OCSymbolContext>();
        for (OCSymbolKind symbolKind : symbolKinds) {
            this.mySymbolContexts.add(new OCSymbolContext(null, symbolKind, null));
        }
    }

    public OCSymbolGroupContext(OCSymbolKind ... symbolKinds) {
        this.myName = "";
        this.mySymbolContexts = new ArrayList<OCSymbolContext>();
        for (OCSymbolKind symbolKind : symbolKinds) {
            this.mySymbolContexts.add(new OCSymbolContext(null, symbolKind, null));
        }
    }

    public OCSymbolGroupContext(@NotNull OCSymbolContext symbolContext) {
        this.myName = symbolContext.getName();
        this.mySymbolContexts = new ArrayList<OCSymbolContext>();
        this.addSymbolContext(symbolContext);
    }

    public static OCSymbolGroupContext union(OCSymbolGroupContext group, OCSymbolContext ... symbols) {
        if (group == null) {
            return null;
        }
        OCSymbolGroupContext result2 = new OCSymbolGroupContext(new OCSymbolKind[0]);
        for (OCSymbolContext context : group.getSymbolContexts()) {
            result2.addSymbolContext(context);
        }
        for (OCSymbolContext context : symbols) {
            result2.addSymbolContext(context);
        }
        return result2;
    }

    public static OCSymbolGroupContext union(OCSymbolGroupContext group, OCSymbolKind ... kinds) {
        if (group == null) {
            return null;
        }
        OCSymbolGroupContext result2 = new OCSymbolGroupContext(new OCSymbolKind[0]);
        for (OCSymbolContext context : group.getSymbolContexts()) {
            result2.addSymbolContext(context);
        }
        for (OCSymbolKind kind2 : kinds) {
            result2.addSymbolContext(kind2);
        }
        return result2;
    }

    public static OCSymbolGroupContext union(OCSymbolGroupContext group1, OCSymbolGroupContext group2) {
        OCSymbolGroupContext result2 = new OCSymbolGroupContext(new OCSymbolKind[0]);
        result2.addSymbolContexts(group1.getSymbolContexts());
        result2.addSymbolContexts(group2.getSymbolContexts());
        return result2;
    }

    public void addSymbolContext(OCSymbolKind kind2) {
        this.mySymbolContexts.add(new OCSymbolContext(null, kind2, null));
    }

    public void addSymbolContext(@NotNull OCSymbolContext symbolContext) {
        this.mySymbolContexts.add(symbolContext);
    }

    public void addSymbolContexts(List<OCSymbolContext> symbolContexts) {
        this.mySymbolContexts.addAll(symbolContexts);
    }

    public List<OCSymbolContext> getSymbolContexts() {
        return this.mySymbolContexts;
    }

    public boolean isSuitableSymbol(OCSymbol symbol) {
        return this.isSuitableSymbolKind(symbol.getKind());
    }

    public boolean isSuitableSymbolKind(OCSymbolKind kind2) {
        for (OCSymbolContext symbolContext : this.mySymbolContexts) {
            if (kind2 != symbolContext.getSymbolKind()) continue;
            return true;
        }
        return false;
    }

    public String getCannotResolveMessagePrefix() {
        if (this.mySymbolContexts.size() == 1) {
            return this.mySymbolContexts.get(0).getCannotResolveMessagePrefix();
        }
        return "Can't resolve " + this.myName;
    }
}

