/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class OCSymbolHolderBase<T extends OCSymbol>
extends FakePsiElement
implements NavigatablePsiElement {
    @NotNull
    protected final T mySymbol;

    public OCSymbolHolderBase(@NotNull T symbol) {
        this.mySymbol = symbol;
    }

    @Override
    @NotNull
    public String getName() {
        return this.mySymbol.getName();
    }

    @Override
    public ItemPresentation getPresentation() {
        return this.mySymbol.getPresentation();
    }

    protected Icon getBaseIcon() {
        return this.mySymbol.getIcon();
    }

    @Override
    public Icon getIcon(boolean open2) {
        return this.mySymbol.getIcon();
    }

    @Override
    public void navigate(boolean requestFocus) {
        int offset = this.mySymbol.getOffset();
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        if (virtualFile != null && virtualFile.isValid()) {
            new OpenFileDescriptor(this.mySymbol.getProject(), virtualFile, offset).navigate(true);
        }
    }

    @Override
    public boolean canNavigateToSource() {
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public PsiElement getParent() {
        return this.mySymbol.getContainingPsiFile();
    }

    @Override
    public PsiFile getContainingFile() {
        return this.mySymbol.getContainingPsiFile();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.mySymbol.getProject();
    }

    @Override
    public int getTextOffset() {
        return this.mySymbol.getOffset();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(this.mySymbol.getOffset(), this.mySymbol.getOffset());
    }

    @Override
    public void delete() throws IncorrectOperationException {
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.mySymbol.equals(((OCSymbolHolderBase)((Object)obj)).mySymbol);
    }

    public int hashCode() {
        return this.mySymbol.hashCode();
    }

    @NotNull
    public T getSymbol() {
        return this.mySymbol;
    }
}

