/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolImpl<T extends PsiElement>
extends OCSymbolBase<T>
implements OCSymbol<T> {
    @NotNull
    protected String myName;
    @NotNull
    private volatile List<String> myAttributes;

    public OCSymbolImpl(@Nullable Project project2, @Nullable VirtualFile file2, long complexOffset, @Nullable String name, @NotNull List<String> attributes) {
        super(project2, file2, complexOffset);
        this.myName = name == null ? "<unnamed>" : name;
        this.myAttributes = attributes;
    }

    public OCSymbolImpl() {
    }

    @Override
    @NotNull
    public List<String> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public void addAttributes(List<String> attributes) {
        if (this.myAttributes.isEmpty()) {
            this.myAttributes = attributes;
        } else {
            ArrayList<String> newAttributes = new ArrayList<String>(this.myAttributes.size() + attributes.size());
            newAttributes.addAll(this.myAttributes);
            newAttributes.addAll(attributes);
            this.myAttributes = newAttributes;
        }
    }

    @Override
    public void compact() {
        this.myAttributes = ContainerUtil.trimToSize(this.myAttributes);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCSymbolImpl f = (OCSymbolImpl)first;
        OCSymbolImpl s = (OCSymbolImpl)second;
        if (f.myComplexOffset != s.myComplexOffset) {
            return false;
        }
        if (!f.myName.equals(s.myName)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myFile, (Object)s.myFile)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myProject, (Object)s.myProject)) {
            return false;
        }
        return f.myAttributes.equals(s.myAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSymbolImpl symbol = (OCSymbolImpl)o;
        if (this.myComplexOffset != symbol.myComplexOffset) {
            return false;
        }
        if (!this.myAttributes.equals(symbol.myAttributes)) {
            return false;
        }
        VirtualFile file2 = this.myFile;
        if (file2 != null ? !file2.equals(symbol.myFile) : symbol.myFile != null) {
            return false;
        }
        if (!this.myName.equals(symbol.myName)) {
            return false;
        }
        Project project2 = this.myProject;
        return !(project2 != null ? !project2.equals(symbol.myProject) : symbol.myProject != null);
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result2 = this.myProject != null ? this.myProject.hashCode() : 0;
        result2 = 31 * result2 + OCSymbolOffsetUtil.getSubstOffset(this.myComplexOffset);
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        result2 = 31 * result2 + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
        return result2;
    }
}

