/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.NodeStructure;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Comparator;

public final class OCSymbolOffsetUtil {
    private static final int BITS_IN_TEXT_OFFSET = 32;
    private static final long MAX_IN_TEXT_OFFSET = 0x100000000L;
    private static final long IN_TEXT_OFFSET_MASK = 0xFFFFFFFFL;
    public static final long INVALID_OFFSET = 0x100000000L;
    public static final Comparator<OCSymbol> SYMBOL_COMPARATOR_BY_SCOPE = (symbol1, symbol2) -> {
        TextRange scope1 = symbol1.getScope();
        TextRange scope2 = symbol2.getScope();
        assert (scope1 != null) : symbol1;
        assert (scope2 != null) : symbol2;
        return scope1.getStartOffset() - scope2.getStartOffset();
    };

    public static int getOffsetInTopMacroSubstitution(PsiElement element) {
        PsiElement prevLeaf = OCElementUtil.getPrevLeaf(element);
        if (prevLeaf instanceof OCMacroForeignLeafElement) {
            return ((OCMacroForeignLeafElement)prevLeaf).getOffsetInTopSubstitution() + 1;
        }
        if (prevLeaf instanceof ForeignLeafPsiElement) {
            return OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(prevLeaf) + 1;
        }
        return 0;
    }

    public static int getTextOffsetInTopMacroSubstitution(PsiElement element) {
        if (element instanceof ForeignLeafPsiElement) {
            PsiElement prevLeaf = OCElementUtil.getPrevSiblingOrParentSibling(element);
            if (prevLeaf != null) {
                return OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(prevLeaf) + prevLeaf.getTextLength();
            }
            return 0;
        }
        return element.getTextRange().getStartOffset();
    }

    public static int getOffsetInTopMacroSubstitution(ForeignLeafType type2) {
        if (type2 instanceof OCMacroForeignLeafType) {
            return ((OCMacroForeignLeafType)type2).getOffsetInTopSubstitution();
        }
        return 0;
    }

    public static <T> int getOffsetInTopMacroSubstitution(NodeStructure<T> structure, T node) {
        IElementType type2 = structure.getTokenType(node);
        if (node instanceof OCMacroForeignLeafElement) {
            return ((OCMacroForeignLeafElement)node).getOffsetInTopSubstitution();
        }
        if (type2 instanceof OCMacroForeignLeafType) {
            return ((OCMacroForeignLeafType)type2).getOffsetInTopSubstitution();
        }
        return 0;
    }

    public static long getComplexOffset(int textOffset, int substOffset) {
        return (long)textOffset | (long)substOffset << 32;
    }

    public static long getComplexOffset(PsiElement element) {
        int offsetInTopMacroSubstitution = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(element);
        return OCSymbolOffsetUtil.getComplexOffset(OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(element), offsetInTopMacroSubstitution);
    }

    public static long getVirtualComplexOffset(PsiElement element) {
        return element instanceof OCElement ? ((OCElement)element).getComplexOffset() : (long)element.getTextOffset();
    }

    public static <T> long getComplexOffset(NodeStructure<T> structure, T node) {
        int offsetInTopMacroSubstitution = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(structure, node);
        return OCSymbolOffsetUtil.getComplexOffset(structure.getStartOffset(node), offsetInTopMacroSubstitution);
    }

    public static int getTextOffset(long complexOffset) {
        return (int)(complexOffset & 0xFFFFFFFFL);
    }

    public static int getSubstOffset(long complexOffset) {
        return (int)(complexOffset >> 32);
    }

    public static int compare(long complexOffset1, long complexOffset2) {
        int substOffset2;
        int textOffset2;
        int textOffset1 = OCSymbolOffsetUtil.getTextOffset(complexOffset1);
        if (textOffset1 < (textOffset2 = OCSymbolOffsetUtil.getTextOffset(complexOffset2))) {
            return -1;
        }
        if (textOffset1 > textOffset2) {
            return 1;
        }
        int substOffset1 = OCSymbolOffsetUtil.getSubstOffset(complexOffset1);
        if (substOffset1 < (substOffset2 = OCSymbolOffsetUtil.getSubstOffset(complexOffset2))) {
            return -1;
        }
        if (substOffset1 > substOffset2) {
            return 1;
        }
        return 0;
    }

    public static long adjust(long baseOffset, long complexOffset) {
        int baseTextOffset = OCSymbolOffsetUtil.getTextOffset(baseOffset);
        int newTextOffset = OCSymbolOffsetUtil.getTextOffset(complexOffset);
        int newSubstOffset = OCSymbolOffsetUtil.getSubstOffset(complexOffset);
        newTextOffset = newTextOffset > baseTextOffset ? newTextOffset : baseTextOffset;
        return OCSymbolOffsetUtil.getComplexOffset(newTextOffset, newSubstOffset);
    }
}

