/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifiedNameOwner;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.BuilderDriverBase;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolReferenceResolver {
    @NotNull
    private final OCResolveContext myMemoization;
    private final boolean myProcessInsideUsings;
    private final boolean myProcessTypesOnly;
    private static final Condition<OCSymbol> NON_USING_SYMBOL = symbol -> !(symbol instanceof OCUsingSymbol);
    private static final Class<PsiElement>[] STOP_SET = new Class[]{OCStructLike.class, OCDeclaration.class, OCDeclarator.class, OCCppNamespace.class, OCTemplateParameterList.class, OCCppUsingStatement.class, OCConstructorFieldInitializer.class, OCClassDeclaration.class, OCMethod.class};

    public OCSymbolReferenceResolver(boolean processInsideUsings, boolean processTypesOnly, @NotNull OCResolveContext context) {
        this.myProcessInsideUsings = processInsideUsings;
        this.myProcessTypesOnly = processTypesOnly;
        this.myMemoization = context;
    }

    public void processSymbolsForLocalRef(@Nullable String name, @NotNull PsiElement element, @NotNull Processor<OCSymbol> processor2) {
        PsiElement context = element;
        while (context != null) {
            OCResolveUtil.processLocalAndMemberSymbols(name, context, processor2, this.myMemoization);
            PsiFile file2 = context.getContainingFile();
            context = file2 != null ? file2.getContext() : null;
        }
        this.processBuiltInSymbols(name, element, processor2);
    }

    public OCCommonProcessors.OrderedProcessor<OCSymbol> getFilteredByKindProcessor(@Nullable OCSymbolReference.SymbolFilter kind2, @NotNull Processor<OCSymbol> processor2) {
        final Processor filteredProcessor = kind2 == null ? processor2 : symbol -> !kind2.accept((OCSymbol)symbol) || processor2.process(symbol);
        class MyOrderedProcessor
        extends OCCommonProcessors.OrderedProcessor<OCSymbol> {
            public MyOrderedProcessor() {
                super(processor2, symbol -> symbol.getKind().isTypedefOrAlias(), symbol -> !symbol.isPredeclaration(), Conditions.alwaysTrue());
            }
        }
        return new MyOrderedProcessor();
    }

    public static OCResolveUtil.ResolveFilteringProcessor<OCSymbol> createResolveFilteringProcessor(Processor<OCSymbol> processor2, OCResolveContext context) {
        PsiElement element = context.getElement();
        PsiFile file2 = element != null ? element.getContainingFile() : null;
        int textOffset = element != null ? element.getTextRange().getEndOffset() : 0;
        return new OCResolveUtil.ResolveFilteringProcessor<OCSymbol>(processor2, file2, textOffset, context.isProcessNonImported());
    }

    /*
     * Could not resolve type clashes
     */
    public boolean processSymbolsForGlobalRef(@Nullable String name, @Nullable OCSymbolReference.SymbolFilter kind2, @Nullable OCSymbolWithQualifiedName context, boolean skipImmediateContext, @NotNull Processor<OCSymbol> processor2, boolean hasArguments) {
        OCSymbolWithQualifiedName owner;
        ArrayList<Collection<? extends OCSymbol>> worksets = new ArrayList<Collection<? extends OCSymbol>>();
        boolean nonqualifier = true;
        boolean skipFirst = false;
        boolean isMagic = context instanceof OCSymbolWithSubstitution && OCResolveUtil.hasNonResolvedTemplateParameters((OCSymbolWithSubstitution)((Object)context), this.myMemoization);
        OCSymbolWithQualifiedName originalContext = context;
        for (OCSymbolWithQualifiedName temp = context; temp != null; temp = temp.getParent()) {
            if (temp.getQualifier() != null) {
                nonqualifier = false;
            }
            if (temp instanceof OCStructSymbol && ((OCStructSymbol)temp).isTemplateSymbol() && temp.getName().equals(name) && !hasArguments) {
                return processor2.process((Object)this.myMemoization.getSubstitution().substitute(temp, this.myMemoization));
            }
            if (temp instanceof OCTemplateSymbol) {
                for (OCTypeParameterSymbol param : ((OCTemplateSymbol)((Object)temp)).getTemplateParameters()) {
                    if (name == null && !processor2.process((Object)((OCSymbol)((Object)param)))) {
                        return false;
                    }
                    if (!param.getName().equals(name)) continue;
                    return processor2.process((Object)((OCSymbol)((Object)param)));
                }
            }
            if (!nonqualifier || !(temp instanceof OCFunctionSymbol) && !(temp instanceof OCStructSymbol)) continue;
            worksets.add(Collections.singletonList(temp));
            context = temp;
            skipFirst = true;
        }
        if (skipImmediateContext && !worksets.isEmpty()) {
            worksets.remove(0);
        }
        if (context != null) {
            this.addWorksets(context, worksets, skipFirst, true);
            if (context instanceof OCFunctionSymbol && ((OCFunctionSymbol)context).isCppNonMemberOperator(this.myMemoization)) {
                this.addWorksets(context, worksets, skipFirst, false);
            }
        }
        worksets.add(null);
        for (owner = context; owner != null && !(owner instanceof OCStructSymbol); owner = owner.getResolvedOwner(this.myMemoization, true)) {
        }
        for (Collection<? extends OCSymbol> workset : worksets) {
            OCSymbol collected;
            ProgressManager.checkCanceled();
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = this.getFilteredByKindProcessor(kind2, (Processor<OCSymbol>)collector);
            if (workset != null) {
                for (OCSymbol symbol : workset) {
                    ProgressManager.checkCanceled();
                    if (symbol instanceof OCNamespaceSymbol) {
                        boolean old = OCResolveContext.setNonImportedFlag(this.myMemoization, false);
                        Set<OCTypeParameterSymbol> dependencies = this.myMemoization.getTypeDependencies();
                        OCSymbol symbolWithSubstitution = this.myMemoization.getSubstitution().substitute(symbol, this.myMemoization);
                        OCStructType.processMembersOfNamespace((OCNamespaceSymbol)symbolWithSubstitution, name, this.myProcessInsideUsings, this.myProcessTypesOnly, orderedProcessor, this.myMemoization);
                        this.myMemoization.setTypeDependencies(dependencies);
                        OCResolveContext.setNonImportedFlag(this.myMemoization, old);
                        continue;
                    }
                    if (this.myProcessTypesOnly || !(symbol instanceof OCFunctionSymbol)) continue;
                    for (OCDeclaratorSymbol param : ((OCFunctionSymbol)symbol).getParameterSymbols()) {
                        if (!param.getName().equals(name)) continue;
                        orderedProcessor.process(param);
                    }
                }
            } else {
                PsiFile psiFile = this.myMemoization.getFile();
                if (psiFile == null || OCLanguage.getInstance() != psiFile.getLanguage()) {
                    return false;
                }
                OCFile file2 = (OCFile)psiFile;
                OCNamespaceLikeSymbol membersContainer = file2.getMembersContainer(this.myProcessTypesOnly);
                OCStructType.processMembersOfNamespace(membersContainer, name, this.myProcessInsideUsings, this.myProcessTypesOnly, orderedProcessor, this.myMemoization);
                this.processBuiltInSymbols(name, this.myMemoization.getElement(), orderedProcessor);
                if (this.myMemoization.isProcessNonImported()) {
                    OCGlobalProjectSymbolsCache.processTopLevelSymbols(file2.getProject(), (Processor<OCSymbol>)new FilteringProcessor(NON_USING_SYMBOL, orderedProcessor), name);
                }
            }
            orderedProcessor.finish();
            Collection results = collector.getResults();
            if (results.isEmpty()) continue;
            boolean wasDefinition = false;
            boolean stopWalkUp = false;
            boolean ownerProcessed = false;
            for (OCSymbol collected2 : results) {
                ProgressManager.checkCanceled();
                if (!collected2.isPredeclaration()) {
                    wasDefinition = true;
                    if (!collected2.getKind().isConstructorOrDestructor() && !collected2.getKind().isTemplateParameter() && collected2.getKind() != OCSymbolKind.SYMBOL_USING_SYMBOL && collected2.getKind() != OCSymbolKind.NAMESPACE && (collected2.getKind() != OCSymbolKind.TYPEDEF || originalContext == null || collected2.getComplexOffset() < originalContext.getComplexOffset() || collected2 instanceof OCSymbolWithParent && originalContext.equals(((OCSymbolWithParent)collected2).getParent()))) {
                        stopWalkUp = true;
                    }
                } else if (!collected2.getKind().isConstructorOrDestructor() && !collected2.getKind().isStructLike()) {
                    stopWalkUp = true;
                }
                if (processor2.process((Object)collected2)) continue;
                return false;
            }
            if (!wasDefinition && (collected = (OCSymbol)collector.getResults().iterator().next()) instanceof OCSymbolWithQualifiedName) {
                Set<OCTypeParameterSymbol> dependencies = this.myMemoization.getTypeDependencies();
                Collection<OCSymbol> implementations = this.getImplementationsOfSymbol((OCSymbolWithQualifiedName)collected, isMagic);
                this.myMemoization.setTypeDependencies(dependencies);
                for (OCSymbol impl : implementations) {
                    if (impl == null || ownerProcessed && Comparing.equal((Object)impl, (Object)owner) || processor2.process((Object)impl)) continue;
                    return false;
                }
            }
            if (!stopWalkUp || name == null) continue;
            return true;
        }
        return true;
    }

    private void addWorksets(@NotNull OCSymbolWithQualifiedName context, List<Collection<? extends OCSymbol>> worksets, boolean skipFirst, boolean treatNonMemberOperators) {
        OCQualifiedName contextName = context.getResolvedQualifiedName(false, this.myMemoization, this.myProcessTypesOnly, true, false, true, treatNonMemberOperators);
        if (contextName != null && skipFirst) {
            contextName = contextName.getQualifier();
        }
        while (contextName != null && contextName != OCQualifiedName.GLOBAL) {
            worksets.add(this.myMemoization.doResolveToSymbols(OCSymbolReference.getGlobalReference(contextName, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE), false, this.myProcessTypesOnly));
            contextName = contextName.getQualifier();
        }
    }

    private boolean processBuiltInSymbols(@Nullable String name, @NotNull PsiElement context, Processor<OCSymbol> processor2) {
        if (name != null) {
            OCSymbolKind kind2;
            OCType builtInType;
            if (name.startsWith("__builtin") || name.startsWith("__sync_") || name.startsWith("__atomic_")) {
                builtInType = OCUnknownType.INSTANCE;
                kind2 = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (name.equals("__objc_yes") || name.equals("__objc_no")) {
                builtInType = OCIntType.BOOL;
                kind2 = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (name.equals("_cmd") && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCMethod.class}) != null) {
                builtInType = OCReferenceType.fromText("SEL");
                kind2 = OCSymbolKind.PARAMETER;
            } else if (name.equals("defined") && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCDirective.class}) != null) {
                builtInType = OCUnknownType.INSTANCE;
                kind2 = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (!OCCodeInsightUtil.isInPlainOldC(context) && name.equals("typeid")) {
                OCQualifiedName typeName = OCQualifiedName.parse("std::type_info");
                OCReferenceType returnType = new OCReferenceTypeBuilder(typeName).build();
                builtInType = new OCFunctionType(returnType, Collections.singletonList(OCUnknownType.INSTANCE));
                kind2 = OCSymbolKind.BUILTIN_SYMBOL;
            } else {
                OCCallExpression callExpression;
                builtInType = name.startsWith("__") ? ((callExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, OCCallExpression.class)) != null && OCExpressionEvaluator.evaluateGNUBuiltInTrait(callExpression, this.myMemoization) != null ? OCIntType.BOOL : null) : null;
                kind2 = OCSymbolKind.BUILTIN_SYMBOL;
            }
            if (builtInType != null) {
                Project project2 = context.getProject();
                int offset = context.getTextRange().getEndOffset();
                OCDeclaratorSymbol symbol = new OCDeclaratorSymbol(project2, null, offset, null, name, Collections.emptyList(), builtInType, kind2);
                return processor2.process((Object)symbol);
            }
        }
        return true;
    }

    @Nullable
    public static OCSymbolWithQualifiedName getGlobalContextFromLocal(@Nullable PsiElement localContext) {
        if (localContext instanceof OCDeclarator) {
            localContext = localContext.getContext();
        }
        OCSymbolWithQualifiedName actualContext = null;
        PsiElement context = PsiTreeUtil.getContextOfType((PsiElement)localContext, (Class[])STOP_SET);
        boolean parentSymbol = false;
        while ((context instanceof OCDeclaration || context instanceof OCDeclarator) && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCFunctionDeclaration.class}) != null) {
            context = PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])STOP_SET);
        }
        if (context instanceof OCConstructorFieldInitializer) {
            parentSymbol = true;
            context = PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])STOP_SET);
        }
        while (context != null) {
            Object symbol;
            OCDeclarator declarator;
            OCTypeElement typeElement;
            if ((context instanceof OCDeclarator || context instanceof OCParameterList) && context.getContext() instanceof OCFunctionDeclaration) {
                context = context.getContext();
            }
            if (context instanceof OCTemplateParameterList && context.getContext() instanceof OCDeclaration && (typeElement = ((OCDeclaration)context.getContext()).getTypeElement()) != null) {
                for (PsiElement child : typeElement.getChildren()) {
                    if (!(child instanceof OCStruct)) continue;
                    context = child;
                    break;
                }
            }
            if (context instanceof OCDeclaration && !(context instanceof OCFunctionDeclaration) && (declarator = (OCDeclarator)ContainerUtil.getFirstItem(((OCDeclaration)context).getDeclarators())) != null) {
                context = declarator;
            }
            Object v0 = symbol = context instanceof OCSymbolDeclarator ? ((OCSymbolDeclarator)context).getSymbol() : null;
            if (symbol instanceof OCMemberSymbol) break;
            if (symbol instanceof OCSymbolWithQualifiedName) {
                OCSymbolWithQualifiedName parent;
                actualContext = symbol;
                if (!parentSymbol || actualContext.getQualifier() != null || (parent = actualContext.getParent()) == null) break;
                actualContext = parent;
                break;
            }
            context = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])STOP_SET);
        }
        return actualContext;
    }

    public static OCSymbolReference getGlobalReferenceFromLocal(OCQualifiedName name, PsiElement context, OCSymbolReference.SymbolFilter filter) {
        while (context instanceof OCCppNamespaceQualifier) {
            context = context.getParent();
        }
        if (context instanceof OCDeclarator && context.getParent() instanceof OCFunctionDefinition) {
            context = context.getParent();
        }
        return OCSymbolReference.getGlobalReference(name, OCSymbolReferenceResolver.getGlobalContextFromLocal(context), filter);
    }

    public static OCSymbolReference getGlobalReferenceFromLocal(OCSymbolReference reference) {
        if (reference instanceof OCSymbolReference.LocalReference) {
            return OCSymbolReferenceResolver.getGlobalReferenceFromLocal(reference.getQualifiedName(), ((OCSymbolReference.LocalReference)reference).getLocalContext(), reference.getFilter());
        }
        return reference;
    }

    @NotNull
    public static OCQualifiedName getQualifiedName(@NotNull OCNamespaceQualifierOwner element) {
        PsiElement firstChild;
        OCCppNamespaceQualifier qualifierElement = element.getNamespaceQualifier();
        OCQualifiedName qualifier = qualifierElement != null ? OCSymbolReferenceResolver.getQualifiedName(qualifierElement) : ((firstChild = element.getFirstChild()) != null && firstChild.getNode().getElementType() == OCTokenTypes.COLON2X ? OCQualifiedName.GLOBAL : null);
        String name = element instanceof OCNamespaceQualifiedNameOwner ? ((OCNamespaceQualifiedNameOwner)element).getName() : (element instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element).getName() : element.getReference().getCanonicalText());
        List<OCTypeArgument> typeArguments = element instanceof OCTemplateArgumentsOwner ? OCSymbolReferenceResolver.getTypeArguments((OCTemplateArgumentsOwner)((Object)element)) : null;
        return typeArguments != null ? new OCQualifiedNameWithArguments(qualifier, name, typeArguments) : OCQualifiedName.with(qualifier, name);
    }

    @Nullable
    public static List<OCTypeArgument> getTypeArguments(@NotNull OCTemplateArgumentsOwner element) {
        ArrayList<OCTypeArgument> typeArguments = null;
        OCTypeArgumentList argumentList = element.getTemplateArgumentList();
        if (argumentList != null) {
            typeArguments = new ArrayList<OCTypeArgument>();
            for (OCElement argument : argumentList.getArguments()) {
                OCSymbolReferenceResolver.doProcessTypeArgument(element, typeArguments, argument);
            }
        }
        return typeArguments;
    }

    private static void doProcessTypeArgument(@NotNull PsiElement element, ArrayList<OCTypeArgument> typeArguments, OCElement argument) {
        if (argument instanceof OCGenericArgument) {
            OCSymbolReferenceResolver.doProcessTypeArgument(element, typeArguments, ((OCGenericArgument)argument).getTypeElement());
        } else if (argument instanceof OCTypeElement) {
            typeArguments.add(((OCTypeElement)argument).getType());
        } else if (argument instanceof OCExpression) {
            OCFile file2 = (OCFile)element.getContainingFile();
            OCBuilderDriver<ASTNode> builderDriver = new OCBuilderDriver<ASTNode>(file2, OCInclusionContext.empty(file2.getKind(), file2), new ASTStructure(argument.getNode()), BuilderDriverBase.AST_NAMED_NODE_STRUCTURE, (Processor<OCSymbol>)CommonProcessors.alwaysTrue());
            OCExpressionSymbol symbol = builderDriver.getExpressionSymbol(argument.getNode(), new BuilderDriverBase.DeclarationContext(null, null, null, null, argument, false));
            typeArguments.add(new OCExpressionTypeArgument(symbol));
        }
    }

    @NotNull
    public Collection<OCSymbol> getImplementationsOfSymbol(OCSymbolWithQualifiedName symbol, boolean isMagic) {
        if (symbol instanceof OCStructSymbol && isMagic) {
            CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return !symbol.isPredeclaration();
                }
            };
            symbol.processSameSymbols((Processor<OCSymbol>)collector);
            return collector.getResults();
        }
        OCSymbol impl = this.getVisibleImplementationOfSymbol(symbol);
        return impl != null ? Collections.singletonList(impl) : Collections.emptyList();
    }

    @Nullable
    public OCSymbol getVisibleImplementationOfSymbol(final OCSymbolWithQualifiedName symbol) {
        final CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        final Class<?> myClass = symbol.getClass();
        String myName = symbol.getName();
        final OCFile file2 = (OCFile)this.myMemoization.getFile();
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){
            private OCQualifiedName myResolvedNameWithArguments;
            private OCQualifiedName myResolvedNameWithoutArguments;

            public boolean process(OCSymbol _symbol) {
                OCQualifiedName resolvedNameWithArguments;
                OCQualifiedName resolvedNameWithoutArguments;
                if (_symbol.isPredeclaration()) {
                    return true;
                }
                if (!_symbol.getClass().equals(myClass)) {
                    return true;
                }
                if (!(_symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                OCNamespaceLikeSymbol container = file2.getMembersContainer(OCSymbolReferenceResolver.this.myProcessTypesOnly);
                boolean found = false;
                OCSymbol parent = _symbol;
                while (parent != null) {
                    OCSymbol _parent = parent;
                    if (!container.processMembers(parent.getName(), ocSymbol -> !ocSymbol.equals(_parent))) {
                        found = true;
                        break;
                    }
                    parent = ((OCSymbolWithQualifiedName)parent).getParent();
                }
                if (!found) {
                    return true;
                }
                if (this.myResolvedNameWithoutArguments == null) {
                    this.myResolvedNameWithoutArguments = OCSymbolReferenceResolver.this.getResolvedQualifiedName(symbol, false);
                    if (this.myResolvedNameWithoutArguments == null) {
                        return false;
                    }
                }
                if (!this.myResolvedNameWithoutArguments.equals(resolvedNameWithoutArguments = OCSymbolReferenceResolver.this.getResolvedQualifiedName((OCSymbolWithQualifiedName)_symbol, false))) {
                    return true;
                }
                if (this.myResolvedNameWithArguments == null) {
                    this.myResolvedNameWithArguments = OCSymbolReferenceResolver.this.getResolvedQualifiedName(symbol, true);
                    if (this.myResolvedNameWithArguments == null) {
                        return false;
                    }
                }
                if (!this.myResolvedNameWithArguments.equals(resolvedNameWithArguments = OCSymbolReferenceResolver.this.getResolvedQualifiedName((OCSymbolWithQualifiedName)_symbol, true))) {
                    return true;
                }
                return processor2.process((Object)_symbol);
            }
        };
        Project project2 = symbol.getProject();
        if (project2 != null) {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, _processor, myName);
        }
        return (OCSymbol)processor2.getFoundValue();
    }

    @Nullable
    public OCQualifiedName getResolvedQualifiedName(OCSymbolWithQualifiedName symbol, boolean appendArguments) {
        return symbol.getResolvedQualifiedName(false, this.myMemoization, this.myProcessTypesOnly, appendArguments, false, true, true);
    }
}

