/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCVisibility {
    NULL,
    PUBLIC,
    PACKAGE,
    PROTECTED,
    PRIVATE;


    public String toString() {
        if (this == PUBLIC) {
            return "public";
        }
        if (this == PACKAGE) {
            return "package";
        }
        if (this == PROTECTED) {
            return "protected";
        }
        if (this == PRIVATE) {
            return "private";
        }
        return super.toString();
    }

    public static OCVisibility getDefaultObjCVisibility(OCSymbolKind fieldKind) {
        return fieldKind == OCSymbolKind.INSTANCE_VARIABLE ? PROTECTED : PRIVATE;
    }

    @Nullable
    public static OCVisibility getVisibilityFromElement(PsiElement element) {
        IElementType elementType = OCElementUtil.getElementType(element);
        if (elementType == OCElementTypes.OBJC_KEYWORD) {
            elementType = OCElementUtil.getObjCKeywordElementType(element.getNode());
        }
        return OCVisibility.getVisibilityFromElementType(elementType);
    }

    @Nullable
    public static OCVisibility getVisibilityFromElementType(IElementType elementType) {
        if (elementType == OCTokenTypes.PUBLIC_KEYWORD) {
            return PUBLIC;
        }
        if (elementType == OCTokenTypes.PACKAGE_KEYWORD) {
            return PACKAGE;
        }
        if (elementType == OCTokenTypes.PROTECTED_KEYWORD) {
            return PROTECTED;
        }
        if (elementType == OCTokenTypes.PRIVATE_KEYWORD) {
            return PRIVATE;
        }
        return null;
    }

    @Nullable
    public OCElementType getElementType() {
        switch (this) {
            case PUBLIC: {
                return OCTokenTypes.PUBLIC_KEYWORD;
            }
            case PACKAGE: {
                return OCTokenTypes.PACKAGE_KEYWORD;
            }
            case PROTECTED: {
                return OCTokenTypes.PROTECTED_KEYWORD;
            }
            case PRIVATE: {
                return OCTokenTypes.PRIVATE_KEYWORD;
            }
        }
        return null;
    }

    public static OCVisibility min(OCVisibility x, OCVisibility y) {
        return x.ordinal() < y.ordinal() ? x : y;
    }

    public static OCVisibility max(OCVisibility x, OCVisibility y) {
        return x.ordinal() < y.ordinal() ? y : x;
    }

    public static boolean isVisible(OCSymbol symbol, PsiElement context, @Nullable OCType qualifierType) {
        return OCVisibility.isVisible(symbol, OCVisibility.getVisibility(symbol, context, qualifierType));
    }

    public static boolean isVisible(OCSymbol symbol, OCVisibility visibility) {
        OCVisibility declaredVisibility = OCVisibility.getDeclaredVisibility(symbol);
        return declaredVisibility == null || visibility.ordinal() >= declaredVisibility.ordinal() && !OCVisibility.shouldBeDeclaredInInterface(symbol, visibility);
    }

    public static boolean shouldBeDeclaredInInterface(OCSymbol symbol, OCVisibility visibility) {
        if (visibility.ordinal() < PRIVATE.ordinal() && symbol instanceof OCMemberSymbol) {
            OCClassSymbol parent = (OCClassSymbol)((OCMemberSymbol)symbol).getParent();
            return parent instanceof OCImplementationSymbol || "".equals(parent.getCategoryName());
        }
        return false;
    }

    @Nullable
    public static OCVisibility getDeclaredVisibility(OCSymbol symbol) {
        OCVisibility visibility = null;
        if (symbol instanceof OCInstanceVariableSymbol) {
            visibility = ((OCInstanceVariableSymbol)symbol).getVisibility();
        } else if (symbol instanceof OCMemberSymbol) {
            visibility = PRIVATE;
            OCMemberSymbol memberSymbol = (OCMemberSymbol)symbol;
            if (memberSymbol.getParent() instanceof OCImplementationSymbol) {
                memberSymbol = memberSymbol.getAssociatedSymbol();
            }
            if (memberSymbol != null && !"".equals(((OCClassSymbol)memberSymbol.getParent()).getCategoryName())) {
                visibility = PUBLIC;
            }
        } else if (symbol instanceof OCSymbolWithQualifiedName) {
            visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility();
        }
        return visibility;
    }

    @NotNull
    public static OCVisibility getVisibility(@NotNull OCSymbol symbol, @NotNull PsiElement contextElement, @Nullable OCType qualifierType) {
        if (symbol instanceof OCMemberSymbol) {
            if (symbol instanceof OCForeignSymbol) {
                return PRIVATE;
            }
            OCFile containingFile = symbol.getContainingOCFile();
            if (containingFile != null) {
                return OCVisibility.getMemberVisibility((OCMemberSymbol)symbol, contextElement);
            }
            return NULL;
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            return OCVisibility.getCppVisibility((OCSymbolWithParent)symbol, contextElement, qualifierType);
        }
        return NULL;
    }

    private static OCVisibility getMemberVisibility(OCMemberSymbol symbol, PsiElement contextElement) {
        PsiFile file2 = contextElement.getContainingFile();
        OCVisibility visibility = OCVisibility.getDeclaredVisibility(symbol);
        if (visibility == PUBLIC) {
            return visibility;
        }
        if (visibility == PACKAGE) {
            OCWorkspace workspace = OCWorkspaceManager.getWorkspace(contextElement.getProject());
            if (!workspace.areFromSamePackage(symbol.getContainingFile(), contextElement.getContainingFile().getVirtualFile())) {
                return PUBLIC;
            }
            return PACKAGE;
        }
        OCImplementation clazz = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)contextElement, OCImplementation.class, (boolean)false);
        if (clazz == null) {
            return PUBLIC;
        }
        OCObjectType type2 = clazz.getType();
        OCType declInType = ((OCClassSymbol)symbol.getParent()).getType().resolve(file2);
        if (type2 == null || !(declInType instanceof OCObjectType)) {
            return PRIVATE;
        }
        if (declInType.equalsAfterResolving((OCType)type2, (PsiElement)file2)) {
            return PRIVATE;
        }
        if (((OCObjectType)declInType).isAncestorOf(type2)) {
            return PROTECTED;
        }
        return PUBLIC;
    }

    private static OCVisibility getCppVisibility(OCSymbolWithParent symbol, PsiElement contextElement, @Nullable OCType qualifierType) {
        Object functionSymbol;
        PsiFile file2 = contextElement.getContainingFile();
        OCResolveContext context = new OCResolveContext((PsiElement)file2);
        OCSymbolDeclarator function = OCVisibility.getScope(contextElement);
        Object v0 = functionSymbol = function != null ? function.getSymbol() : null;
        if (functionSymbol == null && function instanceof OCEnum || function instanceof OCStructLike && ((OCStructLike)function).getNameIdentifier() == null) {
            Object v1 = functionSymbol = (function = OCVisibility.getScope(function.getParent())) != null ? function.getSymbol() : null;
        }
        OCSymbolWithQualifiedName parent = functionSymbol instanceof OCFunctionSymbol || functionSymbol instanceof OCDeclaratorSymbol ? ((OCSymbolWithQualifiedName)functionSymbol).getResolvedOwner(context, true) : (functionSymbol instanceof OCStructSymbol ? (OCSymbolWithQualifiedName)functionSymbol : null);
        Object declParent = symbol.getParent();
        OCVisibility bestVisibility = NULL;
        MultiMap ourContext = new MultiMap();
        if (functionSymbol instanceof OCSymbolWithQualifiedName) {
            for (Object currentParent = (OCSymbolWithQualifiedName)functionSymbol; currentParent != null; currentParent = ((OCSymbolWithQualifiedName)currentParent).getResolvedOwner()) {
                ourContext.putValue((Object)((OCSymbolImpl)currentParent).getName(), currentParent);
            }
        }
        if (!(declParent instanceof OCStructSymbol)) {
            return PRIVATE;
        }
        if (!new InnerFriendFinder((MultiMap<String, OCSymbol>)ourContext).process((OCSymbol)declParent)) {
            return PRIVATE;
        }
        if (parent instanceof OCStructSymbol) {
            bestVisibility = OCVisibility.max(bestVisibility, OCVisibility.searchCpp((OCStructSymbol)parent, (OCStructSymbol)declParent, symbol, PRIVATE, context));
        }
        if (qualifierType instanceof OCStructType) {
            for (OCStructSymbol struct : ((OCStructType)qualifierType).getStructs()) {
                bestVisibility = OCVisibility.max(bestVisibility, OCVisibility.searchCpp(struct, (OCStructSymbol)declParent, symbol, PUBLIC, context));
            }
        } else if (contextElement instanceof OCNamespaceQualifierOwner) {
            OCCppNamespaceQualifier qualifier = ((OCNamespaceQualifierOwner)contextElement).getNamespaceQualifier();
            if (qualifier != null) {
                OCSymbolReference.LocalReference reference = OCSymbolReference.getLocalReference(qualifier, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
                for (OCSymbol qualifierSymbol : reference.resolveToSymbols(true, false, file2)) {
                    if (qualifierSymbol instanceof OCStructSymbol) {
                        bestVisibility = OCVisibility.max(bestVisibility, OCVisibility.searchCpp((OCStructSymbol)qualifierSymbol, (OCStructSymbol)declParent, symbol, PUBLIC, context));
                        continue;
                    }
                    bestVisibility = OCVisibility.max(bestVisibility, PUBLIC);
                }
            } else if (!(parent instanceof OCStructSymbol)) {
                bestVisibility = OCVisibility.max(bestVisibility, PUBLIC);
            }
        } else if (!(parent instanceof OCStructSymbol)) {
            bestVisibility = OCVisibility.max(bestVisibility, PUBLIC);
        }
        return bestVisibility;
    }

    @Nullable
    private static OCSymbolDeclarator getScope(PsiElement contextElement) {
        OCElement scope;
        if (contextElement instanceof OCReferenceElement && contextElement.getParent() instanceof OCStructLike) {
            contextElement = contextElement.getParent().getParent();
        }
        if ((scope = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)contextElement, (boolean)false, (Class[])new Class[]{OCDeclarator.class, OCFunctionDefinition.class, OCStructLike.class, OCDeclaration.class})) instanceof OCDeclaration && !(scope instanceof OCFunctionDeclaration)) {
            if (!((OCDeclaration)scope).getDeclarators().isEmpty() && ((OCDeclaration)scope).getDeclarators().get(0).getNamespaceQualifier() != null) {
                return ((OCDeclaration)scope).getDeclarators().get(0);
            }
            scope = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)contextElement, (boolean)false, (Class[])new Class[]{OCDeclarator.class, OCFunctionDefinition.class, OCStructLike.class});
        }
        if (scope instanceof OCDeclarator && PsiTreeUtil.getContextOfType((PsiElement)scope, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class}) != null) {
            return OCVisibility.getScope(PsiTreeUtil.getContextOfType((PsiElement)scope, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class}));
        }
        if (scope instanceof OCDeclarator && ((OCDeclarator)scope).getNamespaceQualifier() == null) {
            return OCVisibility.getScope(scope.getParent());
        }
        return scope instanceof OCSymbolDeclarator ? (OCSymbolDeclarator)((Object)scope) : null;
    }

    @NotNull
    private static OCVisibility searchCpp(OCStructSymbol startSymbol, OCStructSymbol destSymbol, @NotNull OCSymbol symbolToFind, OCVisibility requiredVisibility, @NotNull OCResolveContext context) {
        HashSet<OCStructSymbol> processed2 = new HashSet<OCStructSymbol>();
        Stack<Pair> workset = new Stack<Pair>();
        while (startSymbol != null) {
            if (startSymbol.isSameSymbol(destSymbol)) {
                return requiredVisibility;
            }
            workset.push(Pair.create((Object)startSymbol, (Object)((Object)(requiredVisibility == PUBLIC ? PUBLIC : null))));
            OCSymbolWithQualifiedName parent = startSymbol.getResolvedOwner();
            startSymbol = parent instanceof OCStructSymbol ? (OCStructSymbol)parent : null;
        }
        requiredVisibility = OCVisibility.min(requiredVisibility, PROTECTED);
        boolean destSymbolReached = false;
        while (!workset.isEmpty()) {
            Pair pair = (Pair)workset.pop();
            OCStructSymbol curClass = (OCStructSymbol)pair.first;
            OCVisibility restriction = (OCVisibility)((Object)pair.second);
            if (curClass.resolvedNamesEqual(destSymbol)) {
                destSymbolReached = true;
                if (restriction == null || restriction.ordinal() <= requiredVisibility.ordinal()) {
                    return requiredVisibility;
                }
            }
            if (processed2.contains(curClass)) continue;
            OCVisibility[] result2 = new OCVisibility[1];
            curClass.processMembers(symbolToFind.getName(), (Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCUsingSymbol) {
                    for (OCSymbol candidate : context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference(), true, false)) {
                        if (!candidate.equals(symbolToFind)) continue;
                        result2[0] = ((OCUsingSymbol)symbol).getVisibility();
                        return false;
                    }
                }
                return true;
            }));
            if (result2[0] != null && result2[0].ordinal() <= requiredVisibility.ordinal()) {
                return PRIVATE;
            }
            processed2.add(curClass);
            OCSymbolWithQualifiedName parent = curClass.getResolvedOwner();
            if (parent instanceof OCStructSymbol) {
                workset.push(Pair.create((Object)((OCStructSymbol)parent), (Object)((Object)restriction)));
            }
            curClass.processBaseClasses(context, (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    OCVisibility newRestriction = restriction != null ? OCVisibility.max(restriction, visibility) : PUBLIC;
                    workset.push(Pair.create((Object)((OCStructSymbol)symbol), (Object)((Object)newRestriction)));
                }
                return true;
            });
        }
        return destSymbolReached ? NULL : PUBLIC;
    }

    public static OCVisibility getMaxInheritanceVisibility(OCStructSymbol ancestor, OCStructSymbol inheritor, PsiFile file2) {
        HashSet<OCStructSymbol> processed2 = new HashSet<OCStructSymbol>();
        Stack<Pair> workset = new Stack<Pair>();
        OCResolveContext context = new OCResolveContext((PsiElement)file2);
        workset.push(Pair.create((Object)inheritor, (Object)((Object)PUBLIC)));
        OCVisibility result2 = PRIVATE;
        while (!workset.isEmpty()) {
            Pair pair = (Pair)workset.pop();
            OCStructSymbol curClass = (OCStructSymbol)pair.first;
            OCVisibility restriction = (OCVisibility)((Object)pair.second);
            if (curClass.equals(ancestor)) {
                result2 = OCVisibility.min(result2, restriction);
            }
            if (!processed2.add(curClass)) continue;
            curClass.processBaseClasses(context, (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    workset.push(Pair.create((Object)((OCStructSymbol)symbol), (Object)((Object)OCVisibility.max(restriction, visibility))));
                }
                return true;
            });
        }
        return result2;
    }

    @Nullable
    public static OCVisibility getVisibilityAtOffset(@NotNull PsiElement element, int offset) {
        PsiElement kid;
        if (!(element instanceof OCStructLike)) {
            return null;
        }
        OCStructLike elementStruct = (OCStructLike)element;
        for (kid = element.getContainingFile().findElementAt(offset); kid != null && kid.getParent() != element; kid = kid.getParent()) {
        }
        if (kid != null) {
            kid = kid.getPrevSibling();
        }
        while (kid != null) {
            OCVisibility visibility = OCVisibility.getVisibilityFromElement(kid);
            if (visibility != null) {
                return visibility;
            }
            kid = kid.getPrevSibling();
        }
        return elementStruct.getDefaultVisibility();
    }

    private static class InnerFriendFinder
    implements Processor<OCSymbol> {
        private final MultiMap<String, OCSymbol> ourContext;

        public InnerFriendFinder(MultiMap<String, OCSymbol> context) {
            this.ourContext = context;
        }

        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isFriend()) {
                for (OCSymbol function : this.ourContext.get((Object)symbol.getName())) {
                    boolean ok = false;
                    if (((OCFunctionSymbol)symbol).getQualifier() != null) {
                        OCQualifiedName qualifiedName = ((OCFunctionSymbol)symbol).getQualifiedName();
                        OCSymbolReference.GlobalReference ref = OCSymbolReference.getGlobalReference(qualifiedName, ((OCFunctionSymbol)symbol).getParent());
                        List<OCSymbol> possibleSymbols = ref.resolveToSymbols(true, false, symbol.getContainingOCFile());
                        for (OCSymbol possible : possibleSymbols) {
                            OCQualifiedName functionQualifiedName = ((OCFunctionSymbol)function).getResolvedQualifiedName();
                            if (!(possible instanceof OCFunctionSymbol) || !Comparing.equal((Object)((OCFunctionSymbol)possible).getResolvedQualifiedName(), (Object)functionQualifiedName)) continue;
                            ok = true;
                            break;
                        }
                    } else {
                        ok = true;
                    }
                    if (!ok || !new OCTypeEqualityVisitor(symbol.getResolvedType(), true, true, true, true, new OCResolveContext()).equal(function.getResolvedType())) continue;
                    return false;
                }
            } else if (symbol instanceof OCStructSymbol) {
                Iterator iterator;
                if (((OCStructSymbol)symbol).isFriend() && (iterator = this.ourContext.get((Object)symbol.getName()).iterator()).hasNext()) {
                    OCSymbol clazz = (OCSymbol)iterator.next();
                    return false;
                }
                if (!((OCStructSymbol)symbol).processMembers((String)null, this)) {
                    return false;
                }
            }
            return true;
        }
    }
}

