/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionSymbol
extends OCTemplateSymbolImpl<OCElement> {
    public static final String ATTRIBUTE_IMPLICIT_BRIDGING = "ImplicitBridging";
    private OCFunctionType myType;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private List<OCDeclaratorSymbol> myParameterSymbols;
    private OCSymbolKind myKind;
    private int myPropertiesAndAttributes;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCFunctionSymbol() {
    }

    public OCFunctionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName container, @NotNull OCQualifiedName name, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, int functionProperties, int functionAttributes, @NotNull List<String> attributes, @NotNull OCFunctionType type2, @NotNull List<OCDeclaratorSymbol> parameterSymbols, OCSymbolKind kind2, @Nullable OCVisibility visibility) {
        super(project2, file2, offset, container, name, attributes, visibility);
        this.myType = type2;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myParameterSymbols = parameterSymbols;
        this.myKind = kind2;
        this.myPropertiesAndAttributes = functionProperties | functionAttributes;
    }

    public OCFunctionSymbol(OCFunctionSymbol origin) {
        this(origin, origin.getParent());
    }

    public OCFunctionSymbol(OCFunctionSymbol origin, OCSymbolWithQualifiedName parent) {
        super(origin.getProject(), origin.getContainingFile(), origin.getOffset(), parent, origin.getQualifiedName(), origin.getAttributes(), origin.getVisibility());
        this.myType = origin.myType;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.myParameterSymbols = origin.myParameterSymbols;
        this.myKind = origin.myKind;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
        this.mySubstitution = origin.mySubstitution;
    }

    public OCFunctionSymbol(OCFunctionSymbol origin, OCTypeSubstitution substitution, OCSymbolWithQualifiedName parent, @NotNull OCResolveContext context) {
        this(origin, parent);
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    @Override
    public boolean isConst() {
        return this.myType.isConst();
    }

    public boolean isVolatile() {
        return this.myType.isVolatile();
    }

    public boolean isConstexpr() {
        return this.hasAttribute(OCSymbolAttribute.CONSTEXPR);
    }

    public boolean isVirtual() {
        return this.hasAttribute(OCSymbolAttribute.VIRTUAL);
    }

    @Override
    public boolean isStatic() {
        return this.hasAttribute(OCSymbolAttribute.STATIC);
    }

    public boolean isExplicit() {
        return this.hasAttribute(OCSymbolAttribute.EXPLICIT);
    }

    public boolean isDefault() {
        return this.hasAttribute(OCSymbolAttribute.DEFAULT);
    }

    public boolean isDelete() {
        return this.hasAttribute(OCSymbolAttribute.DELETE);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isOverride() {
        return this.hasAttribute(OCSymbolAttribute.OVERRIDE);
    }

    public boolean isInline() {
        return this.hasAttribute(OCSymbolAttribute.INLINE);
    }

    public boolean isExtern() {
        return this.hasAttribute(OCSymbolAttribute.EXTERN);
    }

    public boolean isPureVirtual() {
        return this.hasProperty(Property.IS_PURE_VIRTUAL);
    }

    public boolean isCppConversionOperator() {
        return this.hasProperty(Property.IS_CONVERSION_OPERATOR);
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.hasProperty(Property.IS_TEMPLATE);
    }

    public boolean isCppOperator() {
        return this.hasProperty(Property.IS_OPERATOR);
    }

    public boolean isUDL() {
        return this.hasProperty(Property.IS_UDL);
    }

    public boolean isVararg() {
        return this.myType.isVararg();
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property property) {
        return (this.myPropertiesAndAttributes & property.getMask()) != 0;
    }

    public boolean isCppMemberOperator(@NotNull OCResolveContext context) {
        return this.isCppOperator() && this.getResolvedOwner(context, false) instanceof OCStructSymbol && !this.isFriendOrStatic();
    }

    public boolean isCppNonMemberOperator(@NotNull OCResolveContext context) {
        return this.isCppOperator() && !this.isCppMemberOperator(context);
    }

    public void setType(OCFunctionType type2) {
        this.myType = type2;
    }

    @Nullable
    public OCFunctionDeclaration locateFunctionDefinition() {
        OCElement declarator = (OCElement)this.locateDefinition();
        PsiElement parent = declarator != null ? declarator.getParent() : null;
        return parent instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)parent : null;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    public boolean isCppConstructor() {
        return this.getKind().isConstructorOrDestructor() && !this.isCppDestructor();
    }

    public boolean isCppDestructor() {
        return this.getName().startsWith("~");
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionSymbol f = (OCFunctionSymbol)first;
        OCFunctionSymbol s = (OCFunctionSymbol)second;
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.myKind), (Object)((Object)s.myKind))) {
            return false;
        }
        if (!c.equalIterable(f.myParameterSymbols, s.myParameterSymbols)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateSpecialization, s.myTemplateSpecialization)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Nullable
    public OCFunctionSymbol getDeclarationInParent() {
        if (this.isPredeclaration()) {
            return this;
        }
        OCSymbolWithQualifiedName owner = this.getResolvedOwner();
        Ref result2 = new Ref(null);
        if (owner instanceof OCStructSymbol) {
            OCType resolvedType = this.getResolvedType();
            ((OCStructSymbol)owner).processMembers(this.getName(), (Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCFunctionSymbol) {
                    OCType symbolType = symbol.getType().resolve(this.getContainingOCFile());
                    if (!new OCTypeEqualityVisitor(symbolType, true, new OCResolveContext()).equal(resolvedType)) {
                        return true;
                    }
                    result2.set((Object)((OCFunctionSymbol)symbol));
                    return false;
                }
                return true;
            }));
        }
        return (OCFunctionSymbol)result2.get();
    }

    public boolean resolveIsStatic() {
        if (this.isFriendOrStatic() || this.getQualifier() == null) {
            return this.isFriendOrStatic();
        }
        OCFunctionSymbol predef = this.getDeclarationInParent();
        return predef != null && predef.isFriendOrStatic();
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)templateParameter)).updateOffset(start, end, lengthShift);
        }
        for (OCDeclaratorSymbol parameterSymbol : this.myParameterSymbols) {
            parameterSymbol.updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCTypeParameterSymbol templateParameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)templateParameter)).compact();
        }
        for (OCDeclaratorSymbol parameterSymbol : this.myParameterSymbols) {
            parameterSymbol.compact();
        }
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.myKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        boolean nonVirtual = this.myParent instanceof OCStructSymbol && !this.isVirtual() && !this.isCppConstructor() && !this.isFriendOrStatic();
        return OCIcons.getFunctionIcon(this.isFriendOrStatic(), this.isPureVirtual(), nonVirtual, this.getVisibility());
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @NotNull
    public OCFunctionSymbol clearSubstitution() {
        OCFunctionSymbol result2 = new OCFunctionSymbol(this);
        result2.mySubstitution = OCTypeSubstitution.ID;
        return result2;
    }

    public int getFunctionAttributes() {
        return 0xFFFFFF & this.myPropertiesAndAttributes;
    }

    public int getFunctionProperties() {
        return 0xFF000000 & this.myPropertiesAndAttributes;
    }

    @Override
    @NotNull
    public OCFunctionType getType() {
        return (OCFunctionType)this.mySubstitution.substitute(this.myType, new OCResolveContext());
    }

    @NotNull
    public OCFunctionType getTypeWithoutSubstitution() {
        return this.myType;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        return this.mySubstitution.substitute(this.myParameterSymbols, new OCResolveContext());
    }

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols(@NotNull OCResolveContext context) {
        ArrayList<OCDeclaratorSymbol> result2 = new ArrayList<OCDeclaratorSymbol>();
        for (OCDeclaratorSymbol param : this.mySubstitution.substitute(this.myParameterSymbols, context)) {
            OCType paramType = param.getType().getTerminalType();
            if (paramType instanceof OCVariadicType) {
                int expansionsCnt = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context).size();
                for (int i2 = 0; i2 < expansionsCnt; ++i2) {
                    result2.add(param);
                }
                continue;
            }
            result2.add(param);
        }
        return result2;
    }

    public int getNonInitializedParametersCount(@Nullable OCResolveContext context) {
        if (!(!this.myName.equals("operator++") && !this.myName.equals("operator--") || context != null && context.getElement() instanceof OCReferenceElement && ((OCReferenceElement)context.getElement()).getName().startsWith("operator"))) {
            return 0;
        }
        if (this.myType.hasNoParameters()) {
            return 0;
        }
        int result2 = 0;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            OCType paramType = param.getType().getTerminalType();
            if (param.hasInitializer() || paramType instanceof OCEllipsisType) break;
            if (paramType instanceof OCVariadicType) {
                List<OCType> expanded;
                if (context == null || (expanded = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context)).size() == 1 && ContainerUtil.getFirstItem(expanded) == paramType) continue;
                result2 += expanded.size();
                continue;
            }
            ++result2;
        }
        return result2;
    }

    @Override
    public OCType getEffectiveType() {
        return this.mySubstitution.substitute(this.myType.getReturnType(), new OCResolveContext());
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType() {
        OCType type2 = this.getResolvedType();
        OCType result2 = type2 instanceof OCFunctionType ? ((OCFunctionType)type2).getReturnType() : type2;
        return this.mySubstitution.substitute(result2, new OCResolveContext());
    }

    public boolean canBeCalledWithoutArguments() {
        return this.getNonInitializedParametersCount(null) == 0;
    }

    public boolean isMainFunction() {
        return "main".equals(this.myName) && this.getResolvedOwner() == null;
    }

    @Override
    public String getKindUppercase() {
        return this.isCppDestructor() ? "Destructor" : super.getKindUppercase();
    }

    @Override
    @NotNull
    public String getSignature() {
        StringBuilder buffer = new StringBuilder();
        String typeText = this.getType().getReturnType().getName();
        buffer.append(typeText);
        if (!typeText.endsWith("*")) {
            buffer.append(" ");
        }
        buffer.append(this.getName());
        buffer.append(this.getParametersSignature());
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        return buffer.toString();
    }

    @NotNull
    public String getParametersSignature() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getSignature());
            isFirst = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(oCSymbolAttribute.name().toLowerCase());
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getKind()) + this.getNiceAttributes() + "[" + this.getName() + "]@" + this.getOffset();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return this.getSignatureWithoutParamNames();
    }

    @NotNull
    public String getSignatureWithoutParamNames() {
        return this.getSignatureWithoutParamNames(false, true);
    }

    @NotNull
    public String getSignatureWithoutParamNames(boolean fullyQualifiedName, boolean addReturnType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(fullyQualifiedName ? this.getNameWithParent() : this.getName());
        buffer.append(this.getParamsSignatureWithoutNames());
        this.getType().getCVQualifiers().appendCVQualifiers(buffer);
        if (addReturnType && !this.isCppConstructor()) {
            buffer.append(" : ");
            buffer.append(this.getType().getReturnType().getName());
        }
        return buffer.toString();
    }

    @NotNull
    public String getParamsSignatureWithoutNames() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        boolean isFirst = true;
        for (OCDeclaratorSymbol param : this.getParameterSymbols()) {
            if (!isFirst) {
                buffer.append(", ");
            }
            buffer.append(param.getType().getName());
            isFirst = false;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_TEMPLATE = new Property();
        public static final /* enum */ Property IS_OPERATOR = new Property();
        public static final /* enum */ Property IS_PURE_VIRTUAL = new Property();
        public static final /* enum */ Property IS_CONVERSION_OPERATOR = new Property();
        public static final /* enum */ Property IS_UDL = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_TEMPLATE, IS_OPERATOR, IS_PURE_VIRTUAL, IS_CONVERSION_OPERATOR, IS_UDL};
        }
    }
}

