/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamespaceSymbol
extends OCSymbolWithQualifiedName<PsiElement>
implements OCNamespaceLikeSymbol {
    @Nullable
    private MostlySingularMultiMap<String, OCSymbol> myMembers;
    @Nullable
    private List<OCSymbol> myMembersList;
    private List<OCUsingSymbol> myNamespaceUsings;
    private Collection<OCNamespaceSymbol> myInlineNamespaces;
    private boolean myInlineNamespace;

    public OCNamespaceSymbol() {
    }

    public OCNamespaceSymbol(@Nullable Project project2, @Nullable VirtualFile virtualFile, long startOffset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> membersMap, @Nullable List<OCUsingSymbol> namespaceUsings, boolean inlineNamespace) {
        super(project2, virtualFile, startOffset, parent, name, attributes, null);
        this.myMembersList = ContainerUtil.trimToSize(membersList);
        this.myMembers = membersMap;
        this.myNamespaceUsings = namespaceUsings;
        this.myInlineNamespace = inlineNamespace;
    }

    protected OCNamespaceSymbol(@Nullable Project project2, @Nullable VirtualFile virtualFile, long startOffset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, @Nullable List<OCUsingSymbol> namespaceUsings, boolean inlineNamespace, OCVisibility visibility) {
        super(project2, virtualFile, startOffset, parent, name, attributes, visibility);
        this.myMembersList = membersList;
        this.myMembers = members;
        this.myNamespaceUsings = namespaceUsings;
        this.myInlineNamespace = inlineNamespace;
    }

    public static OCNamespaceSymbol createGlobalNamespaceSymbol(PsiFile file2) {
        return new OCNamespaceSymbol(file2.getProject(), file2.getVirtualFile(), 0L, null, OCQualifiedName.GLOBAL, Collections.emptyList(), null, null, null, false);
    }

    public boolean isGlobalNamespace() {
        return this.myComplexOffset == 0L && this.myMembers == null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.NAMESPACE;
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    public boolean isPredefinition() {
        return this.myMembers == null;
    }

    @Nullable
    protected MostlySingularMultiMap<String, OCSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    public OCSymbol findMember(@NotNull String name) {
        if (this.myMembers != null) {
            Iterator iterator = this.myMembers.get((Object)name).iterator();
            return iterator.hasNext() ? ((OCSymbol)iterator.next()).getDelegate() : null;
        }
        return null;
    }

    public void addMember(@NotNull OCSymbol member) {
        if (this.myMembers != null) {
            this.myMembers.add((Object)member.getName(), (Object)member);
            this.myMembersList.add(member);
        }
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isTopLevel() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCNamespaceSymbol f = (OCNamespaceSymbol)first;
        OCNamespaceSymbol s = (OCNamespaceSymbol)second;
        if (!c.equalIterable(f.myNamespaceUsings, s.myNamespaceUsings)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        if (this.myMembers != null) {
            this.myMembers.processAllValues(member -> {
                member.updateOffset(start, end, lengthShift);
                return true;
            });
        }
    }

    @Override
    public void compact() {
        super.compact();
        if (this.myMembers != null) {
            this.myMembers.processAllValues(member -> {
                member.compact();
                return true;
            });
        }
    }

    @Nullable
    public List<OCSymbol> getMembersList() {
        return this.myMembersList;
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<OCSymbol> processor2) {
        if (this.myMembers == null) {
            return true;
        }
        if (memberName != null) {
            return this.myMembers.processForKey((Object)memberName, OCDelegatingSymbol.getDelegateProcessor(processor2));
        }
        return this.myMembers.processAllValues(OCDelegatingSymbol.getDelegateProcessor(processor2));
    }

    public boolean processMembers(@NotNull Processor<OCSymbol> processor2, int afterOffset, int beforeOffset) {
        return this.myMembersList == null || OCResolveUtil.processSymbolsFromList(processor2, this.myMembersList, afterOffset, beforeOffset);
    }

    public boolean processMembersAndUsings(@NotNull Processor<OCSymbol> processor2, int afterOffset, int beforeOffset) {
        List members = ContainerUtil.notNullize(this.getMembersList());
        List usings = ContainerUtil.notNullize((List)this.getNamespaceUsings());
        return OCResolveUtil.processSymbolsFromTwoLists(processor2, members, usings, afterOffset, beforeOffset);
    }

    @Nullable
    public List<OCUsingSymbol> getNamespaceUsings() {
        return this.myNamespaceUsings;
    }

    @Override
    @Nullable
    public Collection<OCNamespaceSymbol> getInlineNamespaces() {
        return this.myInlineNamespaces;
    }

    public Processor<OCSymbol> getBuilder() {
        return symbol -> {
            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                if (this.myNamespaceUsings == null) {
                    this.myNamespaceUsings = new ArrayList<OCUsingSymbol>();
                }
                this.myNamespaceUsings.add((OCUsingSymbol)symbol);
            } else {
                if (this.myMembers == null) {
                    this.myMembers = new MostlySingularMultiMap();
                    this.myMembersList = new ArrayList<OCSymbol>();
                }
                if (symbol != this) {
                    if (symbol instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbol).isInlineNamespace()) {
                        if (this.myInlineNamespaces == null) {
                            this.myInlineNamespaces = new ArrayList<OCNamespaceSymbol>();
                        }
                        this.myInlineNamespaces.add((OCNamespaceSymbol)symbol);
                    }
                    this.myMembers.add((Object)symbol.getName(), symbol);
                    this.myMembersList.add(symbol.getDelegate());
                }
            }
            return true;
        };
    }

    public boolean isInlineNamespace() {
        return this.myInlineNamespace;
    }

    public int getLastElementOffset() {
        OCSymbol symbol;
        OCSymbol oCSymbol = symbol = this.myMembersList != null ? (OCSymbol)ContainerUtil.getLastItem(this.myMembersList) : null;
        if (symbol instanceof OCNamespaceSymbol) {
            return ((OCNamespaceSymbol)symbol).getLastElementOffset();
        }
        if (symbol != null) {
            return symbol.getOffset();
        }
        return this.getOffset();
    }
}

