/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructSymbol
extends OCNamespaceSymbol
implements OCTemplateSymbol<PsiElement> {
    private OCSymbolKind mySymbolKind;
    @NotNull
    private Collection<Pair<OCType, OCVisibility>> myBaseCppClasses;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private TextRange myScope;
    private int myPropertiesAndAttributes;

    public OCStructSymbol() {
    }

    public OCStructSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCSymbolKind kind2, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, TextRange scope, @Nullable OCVisibility visibility, int classProperties, int classAttributes) {
        super(project2, file2, offset, parent, name, attributes, membersList, members, null, false, visibility);
        assert (kind2 == OCSymbolKind.STRUCT || kind2 == OCSymbolKind.UNION || kind2 == OCSymbolKind.ENUM);
        this.mySymbolKind = kind2;
        this.myBaseCppClasses = baseClasses;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
        this.myPropertiesAndAttributes = classProperties | classAttributes;
    }

    public OCStructSymbol(OCStructSymbol origin, OCTypeSubstitution substitution, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        this(origin, substitution, origin.getParent(), overwriteSubstitution, context);
    }

    public OCStructSymbol(OCStructSymbol origin, OCTypeSubstitution substitution, OCSymbolWithQualifiedName parent, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        super(origin.myProject, origin.myFile, origin.myComplexOffset, parent, origin.getQualifiedName(), origin.getAttributes(), origin.getMembersList(), origin.getMembers(), null, false, origin.myVisibility);
        this.mySymbolKind = origin.getKind();
        this.myBaseCppClasses = origin.myBaseCppClasses;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, overwriteSubstitution, context);
        this.myScope = origin.getScope();
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructSymbol f = (OCStructSymbol)first;
        OCStructSymbol s = (OCStructSymbol)second;
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.mySymbolKind), (Object)((Object)s.mySymbolKind))) {
            return false;
        }
        if (!c.equalIterable(f.myBaseCppClasses, s.myBaseCppClasses)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalIterable(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalIterable(f.myTemplateSpecialization, s.myTemplateSpecialization);
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).updateOffset(start, end, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            ((OCSymbol)((Object)parameter)).compact();
        }
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isEnumClass() {
        return this.hasProperty(Property.IS_ENUM_CLASS);
    }

    public boolean isEnum() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myTemplateParameters.size() != 0 || this.myTemplateSpecialization != null;
    }

    public boolean isInnerClass() {
        for (OCSymbolWithQualifiedName parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OCStructSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property prop) {
        return (this.myPropertiesAndAttributes & prop.getMask()) != 0;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.myTemplateParameters;
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }

    @Override
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isPredeclaration() {
        return this.getMembers() == null;
    }

    @Override
    public String getKindUppercase() {
        OCFile file2 = this.getContainingOCFile();
        OCSymbolKind kind2 = this.getKind();
        if (kind2 == OCSymbolKind.STRUCT && file2 != null && file2.isCpp()) {
            return "Class";
        }
        return super.getKindUppercase();
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<OCSymbol> processor2) {
        Processor inner = this.mySubstitution != OCTypeSubstitution.ID ? symbol -> processor2.process((Object)this.mySubstitution.substitute(symbol, this, false, new OCResolveContext())) : processor2;
        return super.processMembers(memberName, (Processor<OCSymbol>)inner);
    }

    public boolean processFields(@NotNull Processor<OCDeclaratorSymbol> processor2) {
        return this.processMembers((String)null, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCDeclaratorSymbol.class));
    }

    public boolean processFunctions(@Nullable String name, @NotNull Processor<OCFunctionSymbol> processor2) {
        return this.processMembers(name, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCFunctionSymbol.class));
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        MostlySingularMultiMap<String, OCSymbol> members = this.getMembers();
        if (members == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol.getDelegate() instanceof OCDeclaratorSymbol;
            }
        };
        members.processForKey((Object)name, (Processor)finder);
        OCDeclaratorSymbol result2 = (OCDeclaratorSymbol)finder.getFoundValue();
        return result2 != null ? (OCDeclaratorSymbol)result2.getDelegate() : null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return this.mySymbolKind;
    }

    @Override
    @NotNull
    public OCStructType getType() {
        return new OCStructType(this);
    }

    @Override
    @Nullable
    public TextRange getScope() {
        return this.myScope;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.getType().getName();
    }

    @Override
    public Icon computeFullIcon(@Nullable PsiElement symbolElement) {
        Icon result2 = super.computeFullIcon(symbolElement);
        if (result2 != null && OCTestFrameworks.isTestClass(this)) {
            result2 = OCIcons.getTestIcon(result2);
        }
        return result2;
    }

    public boolean processAllMembersWithName(String name, Processor<OCSymbol> processor2) {
        if (!this.isGlobal()) {
            return this.processMembers(name, (Processor<OCSymbol>)((Processor)constructor -> processor2.process(constructor)));
        }
        OCSymbol definition = this.getDefinitionSymbol();
        Processor _processor = symbol -> {
            if (!symbol.getClass().equals(OCFunctionSymbol.class)) {
                return true;
            }
            OCSymbolWithQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner();
            if (resolvedQualifiedName == null || !resolvedQualifiedName.equals(definition)) {
                return true;
            }
            return processor2.process(symbol);
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<OCSymbol>)_processor, name);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2) {
        return this.processConstructors(processor2, false, false, null);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeUsingBaseConstructors, @NotNull OCResolveContext context) {
        return this.processConstructors(processor2, false, includeUsingBaseConstructors, context);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions) {
        return this.processConstructors(processor2, includeOutOfClassDefinitions, false, null);
    }

    private boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, boolean includeUsingBaseConstructors, @Nullable OCResolveContext context) {
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeUsingBaseConstructors && context != null && !this.processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol -> !(symbol instanceof OCUsingSymbol) || ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)memberProcessor, context)))) {
            return false;
        }
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName(this.myName, (Processor<OCSymbol>)memberProcessor);
        }
        return this.processMembers(this.myName, (Processor<OCSymbol>)memberProcessor);
    }

    public boolean processDestructors(Processor<OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions) {
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName("~" + this.myName, (Processor<OCSymbol>)memberProcessor);
        }
        return this.processMembers("~" + this.myName, (Processor<OCSymbol>)memberProcessor);
    }

    public boolean hasDefaultConstructor() {
        class MyProcessor
        implements Processor<OCFunctionSymbol> {
            boolean wasConstructor;
            boolean wasDefaultConstructor;

            MyProcessor() {
            }

            public boolean process(OCFunctionSymbol symbol) {
                this.wasConstructor = true;
                this.wasDefaultConstructor |= symbol.canBeCalledWithoutArguments();
                return true;
            }

            public boolean hasDefaultConstructor() {
                return !this.wasConstructor || this.wasDefaultConstructor;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        this.processConstructors(processor2);
        return processor2.hasDefaultConstructor();
    }

    public boolean hasDeclaredConstructor() {
        return !this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @Nullable
    public OCFunctionSymbol getDefaultConstructor() {
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> finder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return symbol.canBeCalledWithoutArguments();
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)finder);
        return (OCFunctionSymbol)finder.getFoundValue();
    }

    public boolean hasTrivialDestructor(@NotNull OCResolveContext context) {
        return this.hasTrivialDestructor(new HashMap<OCStructSymbol, Optional<Boolean>>(), context);
    }

    private boolean hasTrivialDestructor(@NotNull HashMap<OCStructSymbol, Optional<Boolean>> processingSymbols, @NotNull OCResolveContext context) {
        if (processingSymbols.containsKey(this)) {
            Optional<Boolean> hasTrivialDestructor = processingSymbols.get(this);
            return hasTrivialDestructor.orElse(false);
        }
        OCStructType myType = this.getType();
        OCSymbolKind kind2 = this.getKind();
        if (kind2 != OCSymbolKind.STRUCT && kind2 != OCSymbolKind.UNION) {
            return true;
        }
        Processor dtorProcessor = dtor -> !dtor.isVirtual() && dtor.isDefault();
        BaseClassProcessor baseClassProcessor = (symbol, visibility) -> {
            if (symbol instanceof OCStructSymbol) {
                return ((OCStructSymbol)symbol).hasTrivialDestructor(processingSymbols, context);
            }
            return false;
        };
        Processor fieldsProcessor = field -> {
            OCType type2 = field.getType().resolve(context);
            if (type2 instanceof OCStructType) {
                return ((OCStructType)type2).getSymbol().hasTrivialDestructor(processingSymbols, context);
            }
            return !type2.isUnknown();
        };
        processingSymbols.put(this, Optional.empty());
        boolean hasTrivialDestructor = !this.isPredeclaration() && !myType.isMagicInside(context) && this.processDestructors((Processor<OCFunctionSymbol>)dtorProcessor, false) && this.processBaseClasses(context, baseClassProcessor) && this.processFields((Processor<OCDeclaratorSymbol>)fieldsProcessor);
        processingSymbols.put(this, Optional.of(hasTrivialDestructor));
        return hasTrivialDestructor;
    }

    public boolean hasBaseClasses() {
        return !this.myBaseCppClasses.isEmpty();
    }

    public boolean isPOD(boolean checkInnerStructs) {
        if (this.mySymbolKind != OCSymbolKind.STRUCT && this.mySymbolKind != OCSymbolKind.ENUM) {
            return false;
        }
        if (this.hasBaseClasses()) {
            return false;
        }
        return OCStructSymbol.isPOD(this, new HashSet<OCSymbol>(), checkInnerStructs, this.getContainingOCFile());
    }

    public boolean isPOD() {
        return this.isPOD(true);
    }

    private static boolean isPOD(OCStructSymbol symbol, Set<OCSymbol> processed2, boolean checkInnerStructs, OCFile file2) {
        boolean[] pod = new boolean[]{true};
        symbol.processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol12 -> {
            if (!processed2.add((OCSymbol)symbol12)) {
                return true;
            }
            if (symbol12 instanceof OCStructSymbol) {
                if (checkInnerStructs && !OCStructSymbol.isPOD((OCStructSymbol)symbol12, processed2, true, file2)) {
                    pod[0] = false;
                    return false;
                }
            } else if (symbol12 instanceof OCDeclaratorSymbol) {
                OCVisibility vis = ((OCDeclaratorSymbol)symbol12).getVisibility();
                if (vis != null && vis != OCVisibility.NULL && vis != OCVisibility.PUBLIC) {
                    pod[0] = false;
                    return false;
                }
                OCType type2 = symbol12.getType().resolve(file2);
                if (checkInnerStructs && type2 instanceof OCStructType && symbol12.getKind() != OCSymbolKind.TYPEDEF && ContainerUtil.exists(((OCStructType)type2).getStructs(), symbol1 -> !OCStructSymbol.isPOD(symbol1, processed2, true, file2))) {
                    pod[0] = false;
                    return false;
                }
            }
            return true;
        }));
        return pod[0];
    }

    public boolean hasMemberFunctions() {
        return !this.processFunctions(null, (Processor<OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull PsiElement context) {
        return this.getBaseCppClasses(new OCResolveContext(context));
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull OCResolveContext context) {
        return ContainerUtil.map(this.myBaseCppClasses, pair -> this.mySubstitution.substitute((OCType)pair.first, context));
    }

    @NotNull
    public Collection<Pair<OCType, OCVisibility>> getBaseCppClassesWithVisibility(@NotNull OCResolveContext context) {
        return ContainerUtil.map(this.myBaseCppClasses, pair -> {
            OCType type2 = this.mySubstitution.substitute((OCType)pair.first, context);
            return new Pair((Object)type2, pair.second);
        });
    }

    public boolean processBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2) {
        for (Pair<OCType, OCVisibility> pair : this.myBaseCppClasses) {
            OCType type2 = this.mySubstitution.substitute((OCType)pair.first, context);
            OCType resolved = type2.accept(new OCTypeResolveVisitor(context));
            if (OCStructSymbol.processBaseClass(resolved.isUnknown() ? type2 : resolved, (OCVisibility)((Object)pair.second), processor2, context)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBaseClass(OCType type2, OCVisibility visibility, BaseClassProcessor processor2, @NotNull OCResolveContext context) {
        block4: {
            block5: {
                block3: {
                    ProgressManager.checkCanceled();
                    if (!(type2 instanceof OCStructType)) break block3;
                    for (OCStructSymbol symbol : ((OCStructType)type2).getStructs()) {
                        if (processor2.process(symbol, visibility)) continue;
                        return false;
                    }
                    break block4;
                }
                if (!(type2 instanceof OCReferenceType)) break block5;
                for (OCSymbol baseSymbol : context.resolveToSymbols(((OCReferenceType)type2).getReference(context), true, true)) {
                    ProgressManager.checkCanceled();
                    if (processor2.process(baseSymbol, visibility)) continue;
                    return false;
                }
                break block4;
            }
            if (!(type2 instanceof OCExpansionPackType)) break block4;
            for (OCTypeArgument typeArgument : ((OCExpansionPackType)type2).getExpansions()) {
                if (!(typeArgument instanceof OCType) || OCStructSymbol.processBaseClass((OCType)typeArgument, visibility, processor2, context)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2) {
        return this.processAllBaseClasses(processor2, null);
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2, @Nullable OCResolveContext context) {
        if (context == null) {
            OCFile file2 = this.getContainingOCFile();
            return file2 == null || this.processAllBaseClasses(processor2, new OCResolveContext(file2));
        }
        return this.processAllBaseClasses(context, processor2, true);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2, boolean skipFirstVisibility) {
        Set<OCNamespaceLikeSymbol> processed2 = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack<OCStructSymbol> structsWorkset = new Stack<OCStructSymbol>();
        Stack visibilityWorkset = new Stack();
        structsWorkset.add(this);
        visibilityWorkset.add(null);
        while (!structsWorkset.isEmpty()) {
            OCStructSymbol symbol = (OCStructSymbol)structsWorkset.pop();
            OCVisibility visibility = (OCVisibility)((Object)visibilityWorkset.pop());
            if (processed2.contains(symbol)) continue;
            processed2.add(symbol);
            if (symbol.processBaseClasses(context, (baseSymbol, baseVisibility) -> {
                baseVisibility = visibility == null ? (skipFirstVisibility ? OCVisibility.PUBLIC : baseVisibility) : OCVisibility.max(visibility, baseVisibility);
                if (!processor2.process(baseSymbol, baseVisibility)) {
                    return false;
                }
                if (baseSymbol instanceof OCStructSymbol) {
                    structsWorkset.push((OCStructSymbol)baseSymbol);
                    visibilityWorkset.push(baseVisibility);
                }
                return true;
            })) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(OCStructSymbol struct) {
        return this.isAncestor(struct, null);
    }

    public boolean isAncestor(OCStructSymbol struct, @Nullable OCResolveContext context) {
        return this.resolvedNamesEqual(struct) || !struct.processAllBaseClasses((symbol, visibility) -> !(symbol instanceof OCStructSymbol) || !this.resolvedNamesEqual((OCSymbolWithQualifiedName)symbol), context);
    }

    @NotNull
    public List<OCTypeArgument> getTemplateArguments(@NotNull OCResolveContext context) {
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = this.getTemplateSpecialization();
        if (specialization != null) {
            for (OCTypeArgument spec : specialization) {
                if (spec instanceof OCType) {
                    OCType substitution = ((OCType)spec).transformType(new OCTypeResolveVisitor(context.substituteFirst(this.getSubstitution()), false));
                    if (substitution instanceof OCStructType && ((OCStructType)substitution).getSymbol().equals(this)) continue;
                    result2.add(substitution);
                    continue;
                }
                result2.add(spec);
            }
        } else {
            for (OCTypeParameterSymbol param : this.getTemplateParameters()) {
                OCTypeArgument argument = this.getSubstitution().getSubstitutionFor(param);
                if (argument instanceof OCExpansionPackType) {
                    result2.addAll(((OCExpansionPackType)argument).getExpansions());
                    continue;
                }
                if (argument != null) {
                    result2.add(argument);
                    continue;
                }
                result2.add(new OCTypeParameterType(param));
            }
        }
        return result2;
    }

    @FunctionalInterface
    public static interface BaseClassProcessor {
        public boolean process(OCSymbol var1, OCVisibility var2);
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_ENUM_CLASS = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        static {
            $VALUES = new Property[]{IS_ENUM_CLASS};
        }
    }
}

