/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OCTemplateSymbolImpl<T extends PsiElement>
extends OCSymbolWithQualifiedName<T>
implements OCTemplateSymbol<T> {
    public OCTemplateSymbolImpl() {
    }

    public OCTemplateSymbolImpl(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName qualifiedName, @NotNull List<String> attributes, @Nullable OCVisibility visibility) {
        super(project2, file2, offset, parent, qualifiedName, attributes, visibility);
    }

    public static int getRequiredTemplateArgumentsCnt(@NotNull OCTemplateSymbol<?> symbol) {
        int requiredArgumentsCnt = 0;
        for (OCTypeParameterSymbol param : symbol.getTemplateParameters()) {
            if (param.getDefaultValue() != null) break;
            ++requiredArgumentsCnt;
        }
        return symbol.isVariadicTemplate() ? requiredArgumentsCnt - 1 : requiredArgumentsCnt;
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    public static boolean isVariadicTemplate(@NotNull OCTemplateSymbol<?> symbol) {
        List<OCTypeParameterSymbol> templateParameters = symbol.getTemplateParameters();
        for (int i2 = templateParameters.size() - 1; i2 >= 0; --i2) {
            if (!templateParameters.get(i2).isVariadic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }
}

