/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCThisSelfSuperSymbol
extends OCDeclaratorSymbol {
    private Kind myKind;

    public OCThisSelfSuperSymbol() {
    }

    public OCThisSelfSuperSymbol(Kind kind2, OCType type2) {
        super(null, null, -1, null, OCThisSelfSuperSymbol.getNameByKind(kind2), Collections.emptyList(), type2, OCSymbolKind.PARAMETER);
        this.myKind = kind2;
    }

    private static String getNameByKind(Kind kind2) {
        switch (kind2) {
            case THIS: {
                return "this";
            }
            case SELF: {
                return "self";
            }
            case SUPER: {
                return "super";
            }
            case _CMD: {
                return "_cmd";
            }
        }
        throw new InvalidParameterException("kind");
    }

    private static Kind getKindByName(String name) {
        if ("this".equals(name)) {
            return Kind.THIS;
        }
        if ("self".equals(name)) {
            return Kind.SELF;
        }
        if ("super".equals(name)) {
            return Kind.SUPER;
        }
        if ("_cmd".equals(name)) {
            return Kind._CMD;
        }
        return null;
    }

    public Kind getSelfSuperThisKind() {
        return this.myKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        return ((OCThisSelfSuperSymbol)first).myKind == ((OCThisSelfSuperSymbol)second).myKind;
    }

    public static OCSymbol tryResolveThisSelfSuper(String elementName, @NotNull PsiElement elementContext, @NotNull OCResolveContext context) {
        Kind kind2 = OCThisSelfSuperSymbol.getKindByName(elementName);
        if (kind2 == null) {
            return null;
        }
        OCSymbol[] result2 = new OCSymbol[1];
        OCThisSelfSuperSymbol.processThisSelfSuperInContext(elementName, elementContext, context, (Processor<OCSymbol>)((Processor)symbol -> {
            if (((OCThisSelfSuperSymbol)symbol).getSelfSuperThisKind() == kind2) {
                result2[0] = symbol;
                return false;
            }
            return true;
        }), true);
        return result2[0];
    }

    public static void processThisSelfSuperInContext(OCReferenceElement refElement, Processor<OCSymbol> processor2, boolean checkName) {
        OCThisSelfSuperSymbol.processThisSelfSuperInContext(refElement.getCanonicalText(), refElement, new OCResolveContext(refElement), processor2, checkName);
    }

    public static void processThisSelfSuperInContext(String elementName, @NotNull PsiElement elementContext, @NotNull OCResolveContext context, @NotNull Processor<OCSymbol> processor2, boolean checkName) {
        PsiFile psiFile = elementContext.getContainingFile();
        if (!(psiFile instanceof OCFile)) {
            return;
        }
        OCFile file2 = (OCFile)psiFile;
        OCMethod containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)elementContext, OCMethod.class, (boolean)false);
        if (!(containingMethod == null || checkName && OCElementUtil.getSelfSuperToken(elementName, elementContext, context) == null)) {
            OCType superType;
            OCClassDeclaration containingClass = containingMethod.getContainingClass();
            String name = containingClass.getName();
            OCType selfClassType = OCReferenceType.resolvedFromText(name, file2, false);
            OCType selfType = containingMethod.isInstanceMethod() ? OCPointerType.to(selfClassType) : OCReferenceType.resolvedFromText("Class", file2, false);
            processor2.process((Object)new OCThisSelfSuperSymbol(Kind.SELF, selfType));
            processor2.process((Object)new OCThisSelfSuperSymbol(Kind._CMD, OCReferenceType.fromText("SEL")));
            if (selfClassType instanceof OCObjectType && (superType = ((OCObjectType)selfClassType).getSuperType()) != null) {
                superType = containingMethod.isInstanceMethod() ? OCPointerType.to(superType) : OCReferenceType.resolvedFromText("Class", file2, false);
                processor2.process((Object)new OCThisSelfSuperSymbol(Kind.SUPER, superType));
            }
        }
        OCDeclaration containingFunction = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)elementContext, OCDeclaration.class, (boolean)false);
        while (containingFunction != null) {
            OCSymbolWithQualifiedName classSymbol;
            OCSymbol declarator;
            List<OCDeclarator> declarators = containingFunction.getDeclarators();
            if (declarators.size() == 1 && (declarator = declarators.get(0).getSymbol()) instanceof OCFunctionSymbol && (classSymbol = ((OCSymbolWithQualifiedName)declarator).getResolvedOwner(context, true)) instanceof OCStructSymbol) {
                OCType classType = classSymbol.getType();
                if (((OCFunctionSymbol)declarator).isConst()) {
                    classType = classType.cloneWithConstModifier(elementContext.getProject());
                }
                OCPointerType thisType = OCPointerType.to(classType);
                processor2.process((Object)new OCThisSelfSuperSymbol(Kind.THIS, thisType));
                return;
            }
            containingFunction = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)containingFunction, (Class[])new Class[]{OCDeclaration.class});
        }
    }

    public boolean isKeywordLike() {
        return this.getSelfSuperThisKind() != Kind._CMD;
    }

    public static enum Kind {
        THIS,
        SELF,
        SUPER,
        _CMD;

    }
}

