/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.impl.OCBinaryExpressionImpl;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionSymbol
extends OCExpressionSymbol {
    private OCElementType myOperator;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCBinaryExpressionSymbol() {
    }

    public OCBinaryExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull OCElementType operator2, @NotNull OCExpressionSymbol operand2, @NotNull OCExpressionSymbol operand1) {
        super(project2, file2, offset, name);
        this.myOperator = operator2;
        this.myLeftOperand = operand2;
        this.myRightOperand = operand1;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCBinaryExpressionSymbol firstSymbol = (OCBinaryExpressionSymbol)first;
        OCBinaryExpressionSymbol secondSymbol = (OCBinaryExpressionSymbol)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalBinary(this.myOperator, this.myLeftOperand.evaluate(evaluator), this.myRightOperand.evaluate(evaluator));
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        Info info = this.getInfo(context);
        if (info.customReturnType != null) {
            return info.customReturnType;
        }
        if (info.leftType != null && info.rightType != null) {
            return OCBinaryExpressionImpl.getBinaryExprType(this.myOperator, info.leftType, info.rightType, (PsiElement)context.getFile());
        }
        return null;
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context) {
        return this.getInfo((OCResolveContext)context).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        OCType leftType = this.myLeftOperand.getResolvedType(context);
        OCType rightType = this.myRightOperand.getResolvedType(context);
        if (leftType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)leftType).getSymbol());
        }
        if (rightType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)rightType).getSymbol());
        }
        OCType customReturnType = null;
        if (leftType != null && rightType != null && (symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), OCOperatorReference.OperatorPlacement.INFIX, Arrays.asList(leftType, rightType), Arrays.asList(this.myLeftOperand, this.myRightOperand), context)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context);
        }
        return new Info(leftType, rightType, customReturnType);
    }

    @NotNull
    public OCElementType getOperator() {
        return this.myOperator;
    }

    @NotNull
    public OCExpressionSymbol getLeftOperand() {
        return this.myLeftOperand;
    }

    @NotNull
    public OCExpressionSymbol getRightOperand() {
        return this.myRightOperand;
    }

    private static class Info {
        @Nullable
        public final OCType leftType;
        @Nullable
        public final OCType rightType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType leftType, @Nullable OCType rightType, @Nullable OCType customReturnType) {
            this.leftType = leftType;
            this.rightType = rightType;
            this.customReturnType = customReturnType;
        }
    }
}

