/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCCallExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCalleeSymbol;
    private List<OCExpressionSymbol> myArguments;

    public OCCallExpressionSymbol() {
    }

    public OCCallExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, OCExpressionSymbol calleeSymbol, List<OCExpressionSymbol> arguments) {
        super(project2, file2, offset, name);
        this.myCalleeSymbol = calleeSymbol;
        this.myArguments = arguments;
    }

    public OCExpressionSymbol getCalleeSymbol() {
        return this.myCalleeSymbol;
    }

    public List<OCExpressionSymbol> getArguments() {
        return this.myArguments;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCallExpressionSymbol firstSymbol = (OCCallExpressionSymbol)first;
        OCCallExpressionSymbol secondSymbol = (OCCallExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCalleeSymbol, secondSymbol.myCalleeSymbol)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalCall(this);
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType callerType;
        OCSymbol callerSymbol = null;
        if (this.myCalleeSymbol == null) {
            return null;
        }
        if (this.myCalleeSymbol instanceof OCReferenceExpressionSymbol) {
            OCReferenceType type2;
            OCType resolved;
            OCArgumentsList<OCExpressionSymbol> arguments;
            callerSymbol = ((OCReferenceExpressionSymbol)this.myCalleeSymbol).resolveToSymbol(context);
            OCResolveContext newContext = callerSymbol != null ? context.useFor(callerSymbol) : null;
            OCType oCType = callerType = callerSymbol != null ? OCReferenceExpressionImpl.getReferenceExpressionType(callerSymbol).resolve(newContext) : null;
            if (OCTypeUtils.isUnresolvedLambdaAutoType(callerType) && (arguments = this.getArgumentList(context)) != null) {
                callerType = OCTypeUtils.resolveLambdaAutoType(callerType, context, arguments, false);
            }
            if (callerType instanceof OCPointerType) {
                callerType = ((OCPointerType)callerType).getRefType();
            }
            if (callerType instanceof OCFunctionType) {
                return OCCallExpressionImpl.getCallExprType(callerType, callerSymbol);
            }
            if (callerSymbol == null && !(resolved = (type2 = new OCReferenceTypeBuilder(((OCReferenceExpressionSymbol)this.myCalleeSymbol).getReference()).build()).resolve(context)).isUnknown()) {
                return resolved;
            }
        }
        OCType oCType = callerType = (callerType = this.myCalleeSymbol.getResolvedType(context)) != null ? callerType.getTerminalType() : null;
        if (callerType instanceof OCFunctionType) {
            OCFunctionSymbol dummyFunction = new OCFunctionSymbol(null, null, 0L, null, OCQualifiedName.with(null), Collections.emptyList(), null, 0, 0, Collections.emptyList(), (OCFunctionType)callerType, Collections.emptyList(), OCSymbolKind.FUNCTION_DECLARATION, null);
            if (this.resolveOverloads(Collections.singletonList(dummyFunction), context) == null) {
                return null;
            }
        } else if (callerType instanceof OCStructType) {
            OCArgumentsList<OCExpressionSymbol> arguments = this.getArgumentList(context);
            if (arguments == null) {
                return null;
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCExpressionSymbol> expressions2 = null;
            types.add(callerType);
            types.addAll(arguments.getTypes());
            if (arguments.getExprs() != null) {
                expressions2 = new ArrayList<OCExpressionSymbol>();
                expressions2.add(null);
                expressions2.addAll(arguments.getExprs());
            }
            OCResolveContext newContext = (callerSymbol = OCOperatorReference.resolveOperator("()", OCOperatorReference.OperatorPlacement.POSTFIX, types, expressions2, context)) != null ? context.useFor(callerSymbol) : null;
            callerType = callerSymbol != null ? OCReferenceExpressionImpl.getReferenceExpressionType(callerSymbol).resolve(newContext) : null;
        }
        return callerType != null ? OCCallExpressionImpl.getCallExprType(callerType, callerSymbol) : null;
    }

    @Nullable
    private OCArgumentsList<OCExpressionSymbol> getArgumentList(@NotNull OCResolveContext context) {
        OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(this.myArguments, context);
        for (OCType type2 : arguments.getTypes()) {
            if (!(type2 instanceof OCTypeParameterType)) continue;
            context.addTypeDependency(((OCTypeParameterType)type2).getSymbol());
        }
        for (OCType type2 : arguments.getTypes()) {
            if (type2 != null) continue;
            return null;
        }
        return arguments;
    }

    @Nullable
    public OCSymbol resolveOverloads(Collection<OCSymbol> symbols, OCResolveContext context) {
        OCFunctionSymbol outerFunction;
        OCArgumentsList<OCExpressionSymbol> argumentList = this.getArgumentList(context);
        OCType leftType = null;
        OCExprValueCategory leftValueCategory = null;
        if (this.myCalleeSymbol instanceof OCQualifiedExpressionSymbol) {
            OCExpressionSymbol qualifier = ((OCQualifiedExpressionSymbol)this.myCalleeSymbol).getQualifier();
            OCSymbol qualifierSymbol = qualifier instanceof OCReferenceExpressionSymbol ? ((OCReferenceExpressionSymbol)qualifier).resolveToSymbol(context) : null;
            leftType = qualifierSymbol != null ? qualifierSymbol.getType().resolve(context) : null;
            leftValueCategory = OCExprValueCategory.classify(qualifier, context);
        }
        if ((outerFunction = context.peekOuterFunction()) != null) {
            if (leftType == null) {
                OCSymbolWithQualifiedName owner = outerFunction.getResolvedOwner(context, false);
                leftType = owner != null ? owner.getType() : null;
                leftValueCategory = null;
            }
            if (leftType != null) {
                leftType = leftType.cloneWithAddedCVQualifiers(outerFunction.getType().getCVQualifiers(), this.myProject);
            }
        }
        return argumentList != null ? OCResolveOverloadsUtil.resolveOverloads(symbols, argumentList, leftType, leftValueCategory, null, true, true, true, true, false, context) : null;
    }
}

