/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCastExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myOperand;
    private OCType myType;

    public OCCastExpressionSymbol() {
    }

    public OCCastExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, @Nullable OCExpressionSymbol operand2, @NotNull OCType type2) {
        super(project2, file2, offset, name);
        this.myOperand = operand2;
        this.myType = type2;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCastExpressionSymbol firstSymbol = (OCCastExpressionSymbol)first;
        OCCastExpressionSymbol secondSymbol = (OCCastExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myType, secondSymbol.myType);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return this.myOperand != null ? (T)evaluator.evalCast(this.myType, this.myOperand.evaluate(evaluator)) : null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.myType.resolve(context);
    }

    @NotNull
    public OCType getCastType() {
        return this.myType;
    }
}

