/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCCompoundInitializerImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInitializerListExpressionSymbol
extends OCExpressionSymbol {
    private List<OCExpressionSymbol> myInitializers;

    public OCInitializerListExpressionSymbol() {
    }

    public OCInitializerListExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, List<OCExpressionSymbol> initializers) {
        super(project2, file2, offset, name);
        this.myInitializers = initializers;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInitializerListExpressionSymbol firstSymbol = (OCInitializerListExpressionSymbol)first;
        OCInitializerListExpressionSymbol secondSymbol = (OCInitializerListExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myInitializers, secondSymbol.myInitializers);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return this.myInitializers.size() == 1 ? (T)this.myInitializers.get(0).evaluate(evaluator) : null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (!OCCompilerHelper.supportsInitializerLists(this.getContainingOCFile())) {
            return OCUnknownType.INSTANCE;
        }
        return OCCompoundInitializerImpl.getCompoundInitializerType(OCArgumentsList.expandVariadicExpressions(this.myInitializers, context), context).resolve(context);
    }
}

