/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLambdaExpressionSymbol
extends OCExpressionSymbol {
    private OCType myReturnType;
    private List<OCType> myParameterTypes;
    private OCFunctionSymbol myFunctionSymbol;
    private List<OCDeclaratorSymbol> myParameters;
    private List<OCDeclaratorSymbol> myLocalVarsAndParams;
    private List<OCExpressionSymbol> myReturnExpressions;
    private Map<OCType, OCType> myAutoParamsMapping;
    public static final Comparator<OCDeclaratorSymbol> variablesComparator = Comparator.comparing(OCSymbolImpl::getName).thenComparingLong(OCSymbolBase::getComplexOffset);

    public OCLambdaExpressionSymbol() {
    }

    public OCLambdaExpressionSymbol(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull List<OCExpressionSymbol> returnExpressions, @NotNull List<OCDeclaratorSymbol> parameters2, @NotNull List<OCDeclaratorSymbol> localVarsAndParams, @Nullable List<OCType> parameterTypes, @Nullable OCType returnType) {
        super(project2, file2, offset, name);
        this.myReturnExpressions = returnExpressions;
        this.myParameters = parameters2;
        this.myLocalVarsAndParams = localVarsAndParams;
        this.myParameterTypes = parameterTypes;
        this.myReturnType = returnType;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLambdaExpressionSymbol firstSymbol = (OCLambdaExpressionSymbol)first;
        OCLambdaExpressionSymbol secondSymbol = (OCLambdaExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myParameterTypes, secondSymbol.myParameterTypes)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myParameters, secondSymbol.myParameters)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLocalVarsAndParams, secondSymbol.myLocalVarsAndParams)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myReturnType, secondSymbol.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myReturnExpressions, secondSymbol.myReturnExpressions)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myFunctionSymbol, secondSymbol.myFunctionSymbol);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.LAMBDA;
    }

    public List<OCDeclaratorSymbol> getParameters() {
        return this.myParameters;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getLocalVarsAndParams() {
        return this.myLocalVarsAndParams;
    }

    public void setFunctionSymbol(@NotNull OCFunctionSymbol functionSymbol) {
        this.myFunctionSymbol = functionSymbol;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return null;
    }

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (this.myParameterTypes != null && this.myParameterTypes.stream().anyMatch(OCTypeUtils::hasAutoInside) && !this.myReturnExpressions.isEmpty()) {
            Map<OCType, OCType> map2 = OCTypeUtils.newTypesMap();
            List<OCType> newParameterTypes = this.myParameterTypes.stream().map(t -> OCTypeUtils.replaceAutoTypesWithTypeParameters(t, map2)).collect(Collectors.toList());
            OCLambdaExpressionSymbol newSymbol = new OCLambdaExpressionSymbol(this.myProject, this.myFile, this.myComplexOffset, this.myName, this.myReturnExpressions, this.myParameters, this.myLocalVarsAndParams, newParameterTypes, this.myReturnType);
            newSymbol.myAutoParamsMapping = map2;
            OCAutoType result2 = new OCAutoType(newSymbol, null, null, false, false);
            result2.setNeedsAutoParamsResolving(true);
            return result2;
        }
        OCType returnType = this.myReturnType;
        if (returnType == null) {
            for (OCExpressionSymbol expression2 : this.myReturnExpressions) {
                OCType type2;
                if (this.myFunctionSymbol != null) {
                    context.pushOuterFunction(this.myFunctionSymbol);
                }
                if ((type2 = expression2.getResolvedType(context)) != null) {
                    type2 = OCTypeUtils.decayType(type2, this.myProject);
                }
                if (this.myFunctionSymbol != null) {
                    context.popOuterFunction();
                }
                if (returnType == null) {
                    returnType = type2;
                    continue;
                }
                if (type2 != null && type2.isUnknown() || returnType.equals((Object)type2, context)) continue;
                return null;
            }
            if (returnType == null) {
                returnType = OCVoidType.instance();
            }
        }
        return this.myFunctionSymbol != null ? returnType : context.getSubstitution().substitute(OCPointerType.to(new OCFunctionType(returnType, this.getResolvedParameterTypes(context))), context);
    }

    private List<OCType> getResolvedParameterTypes(@NotNull OCResolveContext context) {
        return this.myParameterTypes.stream().map(p -> p.resolve(context)).collect(Collectors.toList());
    }

    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> arguments) {
        return this.getResolvedType(context, arguments, false);
    }

    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> arguments, boolean failIfNotUnified) {
        if (this.myParameterTypes.size() != arguments.getCount()) {
            return failIfNotUnified ? OCUnknownType.INSTANCE : this.getResolvedType(context);
        }
        HashMap<OCTypeParameterSymbol, OCTypeArgument> map2 = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        for (int i2 = 0; i2 < this.myParameterTypes.size(); ++i2) {
            OCTypeOwner expression2;
            OCType type2 = arguments.getTypes().get(i2);
            OCTypeOwner oCTypeOwner = expression2 = arguments.getExprs() != null ? arguments.getExprs().get(i2) : null;
            if (OCSimpleTypeSubstitution.unify(this.myParameterTypes.get(i2), type2, expression2, map2, null, true, false, context) != OCTypeUnificationVisitor.NOT_UNIFIED) continue;
            return failIfNotUnified ? OCUnknownType.INSTANCE : this.getResolvedType(context);
        }
        context = context.substitute(OCSimpleTypeSubstitution.create(map2), false, true);
        context.setAutoParamsTypeMapping(this.myAutoParamsMapping);
        return this.getResolvedType(context);
    }

    @NotNull
    public List<OCExpressionSymbol> getReturnExpressions() {
        return this.myReturnExpressions;
    }

    public OCFunctionSymbol getFunctionSymbol() {
        return this.myFunctionSymbol;
    }
}

