/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnaryExpressionSymbolBase
extends OCExpressionSymbol {
    protected OCElementType myOperator;
    protected OCExpressionSymbol myOperand;

    public OCUnaryExpressionSymbolBase() {
    }

    public OCUnaryExpressionSymbolBase(@Nullable Project project2, @Nullable VirtualFile file2, long offset, @Nullable String name, @NotNull OCElementType operator2, @NotNull OCExpressionSymbol operand2) {
        super(project2, file2, offset, name);
        this.myOperator = operator2;
        this.myOperand = operand2;
    }

    @NotNull
    public abstract OCOperatorReference.OperatorPlacement getOperatorPlacement();

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUnaryExpressionSymbolBase firstSymbol = (OCUnaryExpressionSymbolBase)first;
        OCUnaryExpressionSymbolBase secondSymbol = (OCUnaryExpressionSymbolBase)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        return c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalUnary(this.myOperator, this.myOperand.evaluate(evaluator));
    }

    protected abstract OCType getResolvedType(OCType var1, @NotNull OCResolveContext var2);

    @Override
    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType opType = this.myOperand.getResolvedType(context);
        if (opType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if (opType == null) {
            return null;
        }
        OCFunctionSymbol symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context);
        if (symbol != null) {
            return symbol.getType().getReturnType().resolve(context);
        }
        return this.getResolvedType(opType, context);
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context) {
        return this.getInfo((OCResolveContext)context).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context) {
        OCFunctionSymbol symbol;
        OCType opType = this.myOperand.getResolvedType(context);
        if (opType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        OCType customReturnType = null;
        if (opType != null && (symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context);
        }
        return new Info(opType, customReturnType);
    }

    public OCElementType getOperator() {
        return this.myOperator;
    }

    private static class Info {
        @Nullable
        public final OCType opType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType opType, @Nullable OCType customReturnType) {
            this.opType = opType;
            this.customReturnType = customReturnType;
        }
    }
}

