/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCClassSymbolImpl
extends OCSymbolWithQualifiedName<OCClassDeclarationBase>
implements OCClassSymbol {
    private String myCategoryName;
    private MostlySingularMultiMap<String, OCMemberSymbol> myMembers;
    private List<String> myProtocolNames;
    private OCReferenceType mySuperType;

    public OCClassSymbolImpl(@NotNull Project project2, @Nullable VirtualFile file2, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String categoryName, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType superType) {
        super(project2, file2, offset, null, OCQualifiedName.interned(name), attributes, null);
        this.myCategoryName = categoryName;
        this.myMembers = members;
        this.myProtocolNames = protocolNames;
        this.mySuperType = superType;
    }

    public OCClassSymbolImpl() {
    }

    @Override
    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    @Override
    public String getCategoryName() {
        return this.myCategoryName;
    }

    @Override
    public void setSuperType(@NotNull OCReferenceType type2) {
        assert (this.mySuperType == null) : "Super type is already set";
        this.mySuperType = type2;
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        assert (this.mySuperType != null) : "Super type has to be set in symbol builder";
        return this.mySuperType;
    }

    @Override
    @NotNull
    public String getSuperClassName() {
        return StringUtil.notNullize((String)this.getSuperType().getReference().getQualifiedName().getName());
    }

    @Override
    public void updateOffset(int start, int end, int lengthShift) {
        super.updateOffset(start, end, lengthShift);
        if (this.myMembers != null) {
            this.myMembers.processAllValues(member -> {
                member.updateOffset(start, end, lengthShift);
                return true;
            });
        }
    }

    @Override
    public void compact() {
        super.compact();
        if (this.myMembers != null) {
            this.myMembers.processAllValues(member -> {
                member.compact();
                return true;
            });
        }
    }

    @Override
    @NotNull
    public List<String> getProtocolNames() {
        return this.myProtocolNames;
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Override
    public boolean isPredeclaration() {
        return this.myMembers == null;
    }

    @Override
    public int getMembersCount() {
        return this.myMembers != null ? this.myMembers.size() : 0;
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result2 = super.hashCodeExcludingOffset();
        result2 = 31 * result2 + this.getMembersCount();
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getMembersCount() == ((OCClassSymbol)o).getMembersCount();
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCClassSymbolImpl f = (OCClassSymbolImpl)first;
        OCClassSymbolImpl s = (OCClassSymbolImpl)second;
        if (!Comparing.equal((String)f.myCategoryName, (String)s.myCategoryName)) {
            return false;
        }
        if (!Comparing.equal(f.myProtocolNames, s.myProtocolNames)) {
            return false;
        }
        if (!c.equalObjects(f.mySuperType, s.mySuperType)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public boolean processMembers(String memberName, @NotNull Processor<OCMemberSymbol> processor2) {
        if (this.myMembers == null) {
            return true;
        }
        if (memberName == null) {
            return this.myMembers.processAllValues(processor2);
        }
        return this.myMembers.processForKey((Object)memberName, processor2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String memberName, @NotNull Class<? extends T> memberClass, Processor<? super T> processor2) {
        if (this.myMembers == null) {
            return true;
        }
        Processor myProcessor = member -> !memberClass.isAssignableFrom(member.getClass()) || processor2.process(member);
        if (memberName == null) {
            return this.myMembers.processAllValues(myProcessor);
        }
        return this.myMembers.processForKey((Object)memberName, myProcessor);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, Class<? extends T> memberClass, Processor<? super T> processor2) {
        return this.processMembersInAllCategories(memberName, memberClass, processor2, true);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, Class<? extends T> memberClass, Processor<? super T> processor2, boolean fromSameParentClass) {
        return this.processCategories((Processor<? super OCClassSymbol>)((Processor)clazz -> clazz.processMembers(memberName, memberClass, processor2)), fromSameParentClass, null);
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String categoryName, @Nullable String memberName, @NotNull Class<? extends T> memberClass, @NotNull Processor<? super T> processor2, boolean fromSameParentClass) {
        return this.processCategories((Processor<? super OCClassSymbol>)((Processor)clazz -> !Comparing.equal((String)categoryName, (String)clazz.getCategoryName()) || clazz.processMembers(memberName, memberClass, processor2)), fromSameParentClass, null);
    }

    @Override
    public boolean processAllMethods(@Nullable String methodName, @NotNull Processor<OCMethodSymbol> processor2, @Nullable Set<String> baseProtocols, @Nullable PsiElement context) {
        boolean isAmongBaseProtocols;
        boolean bl = isAmongBaseProtocols = this instanceof OCProtocolSymbol && baseProtocols != null && baseProtocols.contains(this.getName());
        if (!this.processMembers(methodName, OCMethodSymbol.class, symbol -> isAmongBaseProtocols && !symbol.isOptional() || processor2.process(symbol))) {
            return false;
        }
        if (isAmongBaseProtocols) {
            baseProtocols.addAll(this.myProtocolNames);
        }
        for (String protocolName : this.myProtocolNames) {
            CommonProcessors.FindFirstProcessor<OCSymbol> resolver = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCProtocolSymbol && !symbol.isPredeclaration();
                }
            };
            OCResolveUtil.processGlobalSymbols(protocolName, context, (Processor<OCSymbol>)resolver);
            if (!resolver.isFound() || ((OCProtocolSymbol)resolver.getFoundValue()).processAllMethods(methodName, processor2, baseProtocols, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processCategories(Processor<? super OCClassSymbol> processor2, boolean fromSameParentClass, @Nullable PsiElement context) {
        if (!processor2.process((Object)this)) {
            return false;
        }
        Processor filterProcessor = symbol -> {
            if (!(!(symbol instanceof OCClassSymbol) || fromSameParentClass && !symbol.getClass().equals(this.getClass()) || symbol.isPredeclaration() || symbol.equals(this))) {
                return processor2.process((Object)((OCClassSymbol)symbol));
            }
            return true;
        };
        if (context == null) {
            return OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, (Processor<OCSymbol>)filterProcessor, this.myName);
        }
        return OCResolveUtil.processGlobalSymbols(this.myName, null, (OCFile)context.getContainingFile(), this.getOffset(), (Processor<OCSymbol>)filterProcessor);
    }

    @Override
    public boolean processSameSymbols(Processor<OCSymbol> processor2) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, (Processor<OCSymbol>)((Processor)symbol -> !(symbol instanceof OCClassSymbolImpl) || !this.isSameClass((OCClassSymbolImpl)symbol) || processor2.process(symbol)), this.myName);
    }

    @Override
    @Nullable
    public OCClassSymbol getDefinitionSymbol() {
        return (OCClassSymbol)super.getDefinitionSymbol();
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getInterface() {
        return null;
    }

    @Override
    @Nullable
    public OCClassSymbol getInterfaceOrProtocol() {
        return this.getInterface();
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation() {
        return null;
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getMainInterface() {
        return this.getMainSymbol(this.getInterface());
    }

    @Override
    @Nullable
    public OCImplementationSymbol getMainImplementation() {
        return this.getMainSymbol(this.getImplementation());
    }

    protected MostlySingularMultiMap<String, OCMemberSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    private <T extends OCClassSymbol> T getMainSymbol(@Nullable T symbol) {
        if (symbol == null) {
            return null;
        }
        if (this.myCategoryName == null) {
            return symbol;
        }
        CommonProcessors.FindFirstProcessor<OCClassSymbol> finder = new CommonProcessors.FindFirstProcessor<OCClassSymbol>(){

            protected boolean accept(OCClassSymbol each) {
                return each.getCategoryName() == null;
            }
        };
        symbol.processCategories((Processor<OCClassSymbol>)finder, true, null);
        return (T)((OCClassSymbol)finder.getFoundValue());
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return OCCodeInsightUtil.getClassNameWithCategory(super.getPresentableName(), this.myCategoryName);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myCategoryName == null ? super.getBaseIcon() : CidrLangIcons.CodeAssistantClassExtension;
    }

    @Override
    public Icon computeFullIcon(@Nullable OCClassDeclarationBase symbolElement) {
        Icon result2;
        Icon icon = result2 = this.myCategoryName == null ? super.computeFullIcon(symbolElement) : CidrLangIcons.CodeAssistantClassExtension;
        if (result2 != null) {
            boolean isTestClass;
            boolean bl = isTestClass = symbolElement != null ? OCTestFrameworks.isTestClass(symbolElement) : OCTestFrameworks.isTestClass(this);
            if (isTestClass) {
                result2 = OCIcons.getTestIcon(result2);
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public OCType getType() {
        return OCReferenceType.fromText(this.getName());
    }

    @Override
    @Nullable
    public OCObjectType getResolvedType(boolean ignoringImports) {
        OCType type2 = super.getResolvedType(ignoringImports);
        return type2 instanceof OCObjectType ? (OCObjectType)type2 : null;
    }

    @Override
    public boolean isSameClass(OCClassSymbol symbol) {
        return Comparing.equal((String)this.myName, (String)symbol.getName()) && this instanceof OCProtocolSymbol == symbol instanceof OCProtocolSymbol;
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol) {
        return symbol instanceof OCClassSymbolImpl && this.isSameClass((OCClassSymbolImpl)symbol);
    }

    @Override
    public boolean isSameCategory(OCSymbol symbol) {
        if (symbol instanceof OCClassSymbolImpl && this.myName.equals(symbol.getName())) {
            String myCategory = this.myCategoryName == null ? "" : this.myCategoryName;
            String hisCategory = ((OCClassSymbol)symbol).getCategoryName() == null ? "" : ((OCClassSymbol)symbol).getCategoryName();
            return myCategory.equals(hisCategory);
        }
        return false;
    }

    @Override
    public boolean isSubclass(final OCClassSymbol ancestor) {
        final String ancestorName = ancestor.getName();
        if (this.isSameClass(ancestor) || ancestorName.equals("id")) {
            return true;
        }
        boolean ancestorIsInLibraries = OCSearchScope.isInLibraries(ancestor);
        if (!ancestorIsInLibraries && ancestor.getCategoryName() != null) {
            OCInterfaceSymbol mainInterface = ancestor.getMainInterface();
            ancestorIsInLibraries = OCSearchScope.isInLibraries(mainInterface);
        }
        class DFS {
            Set<OCClassSymbol> processedClasses = new HashSet<OCClassSymbol>();
            Stack<OCClassSymbol> stack = new Stack();
            boolean wasProcessed;

            DFS() {
            }

            <T extends OCClassSymbol> boolean traverse(String name, Class<T> clazz) {
                if (name.equals(ancestorName) && clazz == OCProtocolSymbol.class == ancestor instanceof OCProtocolSymbol) {
                    return true;
                }
                this.wasProcessed = false;
                Project project2 = OCClassSymbolImpl.this.getProject();
                if (project2 == null) {
                    return false;
                }
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, new OCCommonProcessors.TypeFilteredProcessor(t -> {
                    if (!t.isPredeclaration()) {
                        this.wasProcessed = true;
                        if (!this.processedClasses.contains(t)) {
                            this.processedClasses.add((OCClassSymbol)t);
                            this.stack.push((OCClassSymbol)t);
                        }
                    }
                    return true;
                }, clazz), name);
                return false;
            }
        }
        DFS dfs = new DFS();
        if (this instanceof OCProtocolSymbol) {
            if (dfs.traverse(this.getName(), OCProtocolSymbol.class)) {
                return true;
            }
        } else {
            if (dfs.traverse(this.getName(), OCInterfaceSymbol.class)) {
                return true;
            }
            if (!dfs.wasProcessed && dfs.traverse(this.getName(), OCImplementationSymbol.class)) {
                return true;
            }
        }
        while (!dfs.stack.isEmpty()) {
            OCClassSymbol curClass = dfs.stack.pop();
            if (!ancestorIsInLibraries && OCSearchScope.isInLibraries(curClass)) continue;
            if (curClass instanceof OCInterfaceSymbol || curClass instanceof OCImplementationSymbol) {
                if (dfs.traverse(curClass.getSuperClassName(), OCInterfaceSymbol.class)) {
                    return true;
                }
                if (!dfs.wasProcessed && dfs.traverse(curClass.getSuperClassName(), OCImplementationSymbol.class)) {
                    return true;
                }
            }
            for (String protocolName : curClass.getProtocolNames()) {
                if (!dfs.traverse(protocolName, OCProtocolSymbol.class)) continue;
                return true;
            }
        }
        return false;
    }
}

