/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInterfaceSymbolImpl
extends OCClassSymbolImpl
implements OCInterfaceSymbol {
    private List<OCGenericParameterSymbol> myGenericParameters;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCInterfaceSymbolImpl() {
    }

    public OCInterfaceSymbolImpl(@NotNull Project project2, @Nullable VirtualFile file2, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String category, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType superType, @NotNull List<OCGenericParameterSymbol> genericParameters) {
        super(project2, file2, offset, name, attributes, category, members, protocolNames, superType);
        this.myGenericParameters = genericParameters;
    }

    public OCInterfaceSymbolImpl(@NotNull OCInterfaceSymbolImpl origin, @NotNull OCTypeSubstitution substitution, boolean overwriteSubstitution, @NotNull OCResolveContext context) {
        this(origin.getProject(), origin.getContainingFile(), origin.getOffset(), origin.getName(), origin.getAttributes(), origin.getCategoryName(), origin.getMembers(), origin.getProtocolNames(), origin.getSuperType(), origin.getGenericParameters());
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, overwriteSubstitution, context);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.INTERFACE;
    }

    @Override
    @NotNull
    public OCType getType() {
        List<OCTypeArgument> genericArguments = this.getGenericArguments();
        OCQualifiedName qualifiedName = genericArguments.isEmpty() ? this.getQualifiedName() : new OCQualifiedNameWithArguments(null, this.myName, genericArguments);
        return new OCReferenceTypeBuilder(qualifiedName).setSubstitution(this.mySubstitution).build();
    }

    @Override
    @NotNull
    public List<OCTypeArgument> getGenericArguments() {
        if (this.myGenericParameters.isEmpty() || this.mySubstitution == OCTypeSubstitution.ID) {
            return Collections.emptyList();
        }
        ArrayList arguments = ContainerUtil.newArrayList();
        for (OCGenericParameterSymbol parameter : this.myGenericParameters) {
            OCTypeArgument argument = this.mySubstitution.getSubstitutionFor(parameter);
            arguments.add(argument != null ? argument : parameter.getDefaultValue());
        }
        return Collections.unmodifiableList(arguments);
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        return (OCReferenceType)this.mySubstitution.substitute(super.getSuperType(), new OCResolveContext());
    }

    @Override
    public OCInterfaceSymbol getInterface() {
        return this;
    }

    @Override
    public OCSymbol getAssociatedSymbol() {
        return this.getImplementation();
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation() {
        OCImplementationSymbol symbol = this.getImplementation(this.getCategoryName());
        if (symbol == null && this.getCategoryName() != null) {
            symbol = this.getImplementation(null);
        }
        return symbol;
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation(@Nullable String category) {
        boolean isInProject = OCSearchScope.isInProjectSources(this);
        final Condition condition2 = symbol -> symbol instanceof OCImplementationSymbol && isInProject == OCSearchScope.isInProjectSources(symbol) && !symbol.isPredeclaration() && Comparing.equal((String)category, (String)((OCImplementationSymbol)symbol).getCategoryName());
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return condition2.value((Object)symbol);
            }
        };
        OCFile containingFile = this.getContainingOCFile();
        if (containingFile != null) {
            OCResolveUtil.processGlobalSymbols(this.myName, containingFile, (Processor<OCSymbol>)processor2);
        }
        if (!processor2.isFound()) {
            return (OCImplementationSymbol)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(this.myProject, this.myName, (Condition<OCSymbol>)condition2, this.myFile);
        }
        return (OCImplementationSymbol)processor2.getFoundValue();
    }

    @Override
    @NotNull
    public List<OCGenericParameterSymbol> getGenericParameters() {
        return ContainerUtil.newUnmodifiableList(this.myGenericParameters);
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean processMembers(String memberName, @NotNull Processor<OCMemberSymbol> processor2) {
        return super.processMembers(memberName, this.getSubstitutingProcessor(processor2));
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String memberName, @NotNull Class<? extends T> memberClass, @NotNull Processor<? super T> processor2) {
        return super.processMembers(memberName, memberClass, this.getSubstitutingProcessor(processor2));
    }

    @NotNull
    protected <T extends OCMemberSymbol> Processor<T> getSubstitutingProcessor(@NotNull Processor<? super T> processor2) {
        if (this.mySubstitution != OCTypeSubstitution.ID) {
            return member -> processor2.process((Object)this.mySubstitution.substitute(member, null, false, new OCResolveContext()));
        }
        return processor2;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.getGenericParameters();
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return null;
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return this.getTemplateParameters().size();
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myGenericParameters.size() != 0;
    }

    @Override
    public boolean isVariadicTemplate() {
        return false;
    }

    @Override
    public boolean isSpecialization() {
        return false;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return false;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInterfaceSymbolImpl f = (OCInterfaceSymbolImpl)first;
        OCInterfaceSymbolImpl s = (OCInterfaceSymbolImpl)second;
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalIterable(f.myGenericParameters, s.myGenericParameters);
    }
}

