/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileSymbolTableUpdater {
    private final Object myLock = new Object();
    private final Project myProject;
    private final UpdateQueue mySourceQueue = new UpdateQueue();
    private final UpdateQueue myHeaderQueue = new UpdateQueue();
    private final AtomicBoolean myHugeUpdateRequested = new AtomicBoolean();
    private final ThreadLocal<UpdateQueue> myParentQueue = new ThreadLocal();

    public FileSymbolTableUpdater(Project project2) {
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator, boolean ensureOnlySourceFilesProcessed) {
        UpdateQueue parentQueue = this.myParentQueue.get();
        if (parentQueue == this.mySourceQueue) {
            throw new IllegalStateException("Nested updates are not allowed for source files.");
        }
        if (parentQueue != null && !ensureOnlySourceFilesProcessed) {
            throw new IllegalStateException("Nested update may not process header files.");
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        while (true) {
            VirtualFile file2 = null;
            UpdateQueue queue = null;
            Object object = this.myLock;
            synchronized (object) {
                while (file2 == null) {
                    if (indicator != null) {
                        indicator.checkCanceled();
                    }
                    if (isDispatchThread && ensureOnlySourceFilesProcessed && this.tryHugeUpdate()) {
                        return;
                    }
                    if (!(this.mySourceQueue.hasUnprocessedFiles() || !ensureOnlySourceFilesProcessed && this.myHeaderQueue.hasUnprocessedFiles())) {
                        return;
                    }
                    file2 = this.mySourceQueue.startProcessingNext();
                    queue = this.mySourceQueue;
                    if (file2 == null && !ensureOnlySourceFilesProcessed) {
                        file2 = this.myHeaderQueue.startProcessingNext();
                        queue = this.myHeaderQueue;
                    }
                    if (file2 != null) continue;
                    try {
                        this.myLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            boolean ok = false;
            this.myParentQueue.set(queue);
            try {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if (queue == this.mySourceQueue) {
                    FileSymbolTableUpdater.updateSource(file2, this.myProject, indicator);
                } else {
                    FileSymbolTableUpdater.updateHeader(file2, this.myProject);
                }
                ok = true;
                continue;
            }
            finally {
                this.myParentQueue.set(parentQueue);
                Object object2 = this.myLock;
                synchronized (object2) {
                    queue.finishProcessing(file2, ok);
                    this.myLock.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    private static void updateHeader(VirtualFile file2, Project project2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
        FileSymbolTablesCache cache2 = FileSymbolTablesCache.getInstance(project2);
        if (SymbolTableProvider.isSourceFile(psiFile) && cache2.allTablesForFileCount(file2) == 0) {
            cache2.forFile(psiFile, OCInclusionContextUtil.calculateHeaderContext(psiFile, null));
        }
    }

    private static void updateSource(VirtualFile file2, Project project2, ProgressIndicator indicator) {
        for (OCResolveConfiguration oCResolveConfiguration : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(file2, project2)) {
            OCImportGraph.buildSymbolAndRootHeaderCache(oCResolveConfiguration, file2, null, indicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileForUpdate(@NotNull VirtualFile file2) {
        Object object = this.myLock;
        synchronized (object) {
            this.addFileInner(file2);
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilesForUpdate(Collection<VirtualFile> files, boolean clearCaches) {
        Object object = this.myLock;
        synchronized (object) {
            if (clearCaches) {
                FileSymbolTablesCache.getInstance(this.myProject).removeFilesFromCache(files);
            }
            for (VirtualFile file2 : files) {
                this.addFileInner(file2);
            }
            this.myLock.notifyAll();
        }
    }

    private void addFileInner(VirtualFile file2) {
        if (!file2.isValid()) {
            return;
        }
        boolean isHeader = OCInclusionContextUtil.isNeedToFindRoot(file2, this.myProject);
        if (isHeader) {
            this.myHeaderQueue.add(file2);
        } else {
            this.mySourceQueue.add(file2);
        }
    }

    private boolean tryHugeUpdate() {
        int fileScore = this.mySourceQueue.filesToUpdateSize();
        if (fileScore < 20) {
            return false;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.mySourceQueue.removeAllFilesToUpdate());
        this.myHugeUpdateRequested.set(false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myHugeUpdateRequested.getAndSet(true)) {
                return;
            }
            OCSymbolTablesBuildingActivity.getInstance(this.myProject).buildSymbolsForFiles(files);
        }, ModalityState.NON_MODAL);
        return true;
    }

    private static class UpdateQueue {
        private final Set<VirtualFile> myFilesToUpdate = new THashSet();
        private int myFilesInProgressCount;

        private UpdateQueue() {
        }

        public void add(VirtualFile file2) {
            this.myFilesToUpdate.add(file2);
        }

        public VirtualFile startProcessingNext() {
            Iterator<VirtualFile> it = this.myFilesToUpdate.iterator();
            while (it.hasNext()) {
                VirtualFile file2 = it.next();
                it.remove();
                if (!file2.isValid()) continue;
                ++this.myFilesInProgressCount;
                return file2;
            }
            return null;
        }

        public boolean hasUnprocessedFiles() {
            return this.myFilesToUpdate.size() > 0 || this.myFilesInProgressCount > 0;
        }

        public void finishProcessing(VirtualFile file2, boolean isProcessed) {
            --this.myFilesInProgressCount;
            if (!isProcessed) {
                this.myFilesToUpdate.add(file2);
            }
        }

        public int filesToUpdateSize() {
            return this.myFilesToUpdate.size();
        }

        public Collection<VirtualFile> removeAllFilesToUpdate() {
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            Iterator<VirtualFile> it = this.myFilesToUpdate.iterator();
            while (it.hasNext()) {
                VirtualFile file2 = it.next();
                if (file2.isValid()) {
                    result2.add(file2);
                }
                it.remove();
            }
            return result2;
        }
    }
}

