/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalBlock;
import com.jetbrains.cidr.lang.psi.impl.OCEagerBlockStatementImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SerializerProvider;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.ui.OCResolveContextPanel;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesCache
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache");
    private static final int SERIALIZATION_INDEX_VERSION = 119;
    private static Boolean ourShouldBuildCachesInTests = null;
    private static Boolean ourDoNotReloadExistingSymbolsInTests = null;
    private static Boolean ourForceSymbolsLoadedInTests = null;
    private static final Map<String, FileAttribute> ourFileCacheAttributes = new HashMap<String, FileAttribute>();
    private static final FileAttribute ourFileTablesMetaAttribute = new FileAttribute("objc_file_symbol_tables_meta_attribute", FileSymbolTablesCache.getVersion(), false);
    private static final String TABLES_KEY_PREFIX = "objc_file_symbol_tables_attribute";
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache = ContainerUtil.newConcurrentMap();
    private FileSymbolTableUpdater myTableUpdater;
    private final Set<VirtualFile> myPendingReparses = new THashSet();
    private final Set<VirtualFile> myPendingPSIResets = new THashSet();
    private static final int PARALLEL_SERIALIZERS = Runtime.getRuntime().availableProcessors();
    private final FileSymbolTableSerializer[] mySerializers;
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final SimpleModificationTracker myCidrOutOfBlockModificationTracker = new SimpleModificationTracker();
    private final AtomicBoolean mySymbolsLoaded = new AtomicBoolean(false);
    private final Object myFileAndContextDependencyLock = new Object();
    private final Map<Thread, VirtualFile> myContextToAwaitingFile = new THashMap();
    private final Map<VirtualFile, Thread> myFileToProcessingContext = new THashMap();

    private static int getVersion() {
        int result2 = 119;
        for (SerializerProvider provider2 : (SerializerProvider[])SerializerProvider.EP_NAME.getExtensions()) {
            result2 *= 10;
            result2 += provider2.getClass().getName().hashCode();
            result2 += provider2.getVersion();
        }
        return result2;
    }

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project2) {
        return (FileSymbolTablesCache)((Object)project2.getComponent(FileSymbolTablesCache.class));
    }

    public FileSymbolTablesCache(Project project2, MessageBus bus, PsiManager psiManager) {
        super(project2);
        this.myTableUpdater = new FileSymbolTableUpdater(project2);
        this.mySerializers = new FileSymbolTableSerializer[PARALLEL_SERIALIZERS];
        for (int i2 = 0; i2 < PARALLEL_SERIALIZERS; ++i2) {
            this.mySerializers[i2] = new FileSymbolTableSerializer(project2);
        }
        final PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)psiManager.getModificationTracker();
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                psiTracker.incOutOfCodeBlockModificationCounter();
            }
        };
        if (psiManager instanceof PsiManagerImpl) {
            ((PsiManagerImpl)psiManager).addTreeChangePreprocessor(new OCCodeBlockModificationListener());
        }
        MessageBusConnection connection = bus.connect();
        connection.subscribe(OCWorkspaceModificationListener.TOPIC, (Object)new OCWorkspaceModificationListener(){

            @Override
            public void buildSettingsChanged() {
                OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
            }

            @Override
            public void projectFilesChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
            }

            @Override
            public void sourceFilesChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
            }

            @Override
            public void selectedResolveConfigurationChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                HashSet dirtyNames = new HashSet();
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (vFileEvent instanceof VFileDeleteEvent) {
                        FileSymbolTablesCache.this.removeRecursively(vFileEvent.getFile(), (Set)dirtyNames);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileCreateEvent) || (file2 = vFileEvent.getFile()) == null || !SymbolTableProvider.isSourceFile(file2)) continue;
                    dirtyNames.add((Object)file2.getName());
                }
                if (!dirtyNames.isEmpty()) {
                    FileSymbolTablesCache.this.invalidateDirtyIncludes((Set<String>)dirtyNames);
                }
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> OCSymbolTablesBuildingActivity.getInstance(project2).rebuildSymbols());
        }
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        return this.myOutOfBlockModificationTracker;
    }

    @NotNull
    public ModificationTracker getCidrOutOfBlockModificationTracker() {
        return this.myCidrOutOfBlockModificationTracker;
    }

    public void incCidrOutOfCodeBlockTracker() {
        this.myCidrOutOfBlockModificationTracker.incModificationCount();
    }

    public void projectOpened() {
        StatusBar statusbar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusbar != null) {
            statusbar.addWidget((StatusBarWidget)new OCResolveContextPanel(this.myProject), "before ReadOnlyAttribute", (Disposable)this.myProject);
        }
    }

    public boolean shouldBuildTables() {
        return ourShouldBuildCachesInTests != Boolean.FALSE;
    }

    @NotNull
    public static Couple<Boolean> setShouldBuildTablesInTests(@Nullable Boolean build, @Nullable Boolean doNotReloadExistingSymbols) {
        Couple prev = Couple.of((Object)ourShouldBuildCachesInTests, (Object)ourDoNotReloadExistingSymbolsInTests);
        ourShouldBuildCachesInTests = build;
        ourDoNotReloadExistingSymbolsInTests = doNotReloadExistingSymbols;
        return prev;
    }

    public void invalidateDirtyIncludes(Set<String> dirtyNames) {
        Ref somethingWasChanged = new Ref((Object)false);
        HashSet invalidatedFiles = new HashSet();
        for (FileSymbolTable table : this.allTables()) {
            PsiFile psiFile;
            VirtualFile file2 = table.getContainingFile();
            if (file2 == null || !file2.isValid() || (psiFile = PsiManager.getInstance((Project)table.getProject()).findFile(table.getContainingFile())) == null) continue;
            table.processIncludes((Processor<OCIncludeSymbol>)((Processor)arg_0 -> this.lambda$invalidateDirtyIncludes$1(dirtyNames, psiFile, (Set)invalidatedFiles, somethingWasChanged, arg_0)));
        }
        if (((Boolean)somethingWasChanged.get()).booleanValue()) {
            OCImportGraph.invalidateHeaderRootsCache(this.myProject);
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.myProject);
        }
        this.schedulePSIUpdates();
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    private void removeRecursively(VirtualFile file2, Set<String> dirtyNames) {
        if (file2.isDirectory()) {
            for (VirtualFile child : ((NewVirtualFile)file2).getCachedChildren()) {
                this.removeRecursively(child, dirtyNames);
            }
        } else {
            this.clearCache(file2);
            dirtyNames.add(file2.getName());
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        OCWorkspace workspace = OCWorkspaceManager.getWorkspace(this.myProject);
        Collection<VirtualFile> allSourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
        result2.addAll(allSourceFiles);
        result2.addAll(workspace.getLibraryFilesToBuildSymbols());
        return ContainerUtil.filter(result2, file2 -> SymbolTableProvider.isSourceFile(file2));
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file2);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    public void removeFilesFromCache(@NotNull Iterable<VirtualFile> files) {
        for (VirtualFile each : files) {
            this.clearCache(each);
        }
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file2 : this.myCache.keySet()) {
            if (file2 == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            this.clearCache(file2);
        }
    }

    @Nullable
    @Contract(value="null -> null")
    private static VirtualFile key(@Nullable PsiFile file2) {
        return OCInclusionContextUtil.getVirtualFile(file2);
    }

    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file2, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        return SymbolTableProvider.getProvider(file2).calcTableUsingPSI(file2, virtualFile, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    FileSymbolTable forFile(@NotNull PsiFile file2, @NotNull OCInclusionContext context) {
        boolean deadlock;
        Ref outTimeStamp;
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!this.shouldBuildTables()) {
            return null;
        }
        VirtualFile virtualFile = FileSymbolTablesCache.key(file2);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.packForFile(virtualFile);
        FileSymbolTable table = pack.findConformingTable(context, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null) {
            return table;
        }
        int checkedPackTimeStamp = (Integer)outTimeStamp.get();
        if (context.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel(this.myProject)) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        Object object = this.myFileAndContextDependencyLock;
        synchronized (object) {
            this.myContextToAwaitingFile.put(currentThread, virtualFile);
            deadlock = this.checkForDeadlock(currentThread);
            if (deadlock) {
                this.myContextToAwaitingFile.remove(currentThread);
            }
        }
        if (deadlock) {
            return SymbolTableProvider.getProvider(file2).calcTable(file2, virtualFile, context);
        }
        object = pack;
        synchronized (object) {
            boolean alreadyInProcessingStack;
            Object currentlyProcessedBy;
            Object object2 = this.myFileAndContextDependencyLock;
            synchronized (object2) {
                this.myContextToAwaitingFile.remove(currentThread);
                currentlyProcessedBy = this.myFileToProcessingContext.get(virtualFile);
                LOG.assertTrue(currentlyProcessedBy == null || currentlyProcessedBy == currentThread, (Object)("File is processed by another thread, deadlock detection failed! " + file2.getName()));
                boolean bl = alreadyInProcessingStack = currentlyProcessedBy != null;
                if (!alreadyInProcessingStack) {
                    this.myFileToProcessingContext.put(virtualFile, currentThread);
                }
            }
            ProgressManager.checkCanceled();
            FileSymbolTable t = pack.findConformingTable(context, checkedPackTimeStamp, null);
            if (t != null) {
                currentlyProcessedBy = t;
                return currentlyProcessedBy;
            }
            OCSymbolTablesBuildingActivity.getInstance(this.myProject).assertParsingAndSymbolBuildingAllowed(currentThread);
            FileSymbolTable answer = SymbolTableProvider.getProvider(file2).calcTable(file2, virtualFile, context);
            context.addProcessedFile(virtualFile);
            pack.addCompactSynchronized(answer);
            FileSymbolTable fileSymbolTable = answer;
            return fileSymbolTable;
            finally {
                if (!alreadyInProcessingStack) {
                    Object object3 = this.myFileAndContextDependencyLock;
                    synchronized (object3) {
                        this.myFileToProcessingContext.remove(virtualFile);
                    }
                }
            }
        }
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file2, @NotNull OCInclusionContext context) {
        FileSymbolTablesPack pack = this.packForFile(file2);
        return pack.findConformingTable(context, 0, null);
    }

    private boolean checkForDeadlock(@NotNull Thread context) {
        Thread thread = context;
        while (thread != null) {
            VirtualFile lock = this.myContextToAwaitingFile.get(thread);
            if (lock == null) {
                return false;
            }
            Thread next = this.myFileToProcessingContext.get(lock);
            if (next == thread) {
                return false;
            }
            if (next == context) {
                return true;
            }
            thread = next;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(OCFile file2) {
        Set<VirtualFile> set2 = this.myPendingReparses;
        synchronized (set2) {
            VirtualFile key2 = FileSymbolTablesCache.key(file2);
            if (key2 != null) {
                this.myPendingReparses.add(key2);
            }
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set2 = this.myPendingReparses;
        synchronized (set2) {
            for (PsiFile file2 : PsiManagerEx.getInstanceEx(this.myProject).getFileManager().getAllCachedFiles()) {
                VirtualFile key2 = FileSymbolTablesCache.key(file2);
                if (key2 == null) continue;
                this.myPendingReparses.add(key2);
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set2 = this.myPendingReparses;
        synchronized (set2) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.NON_MODAL);
            }
        }
    }

    public void reparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirtyFilesPSI() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ArrayList<VirtualFile> toReparse = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> toResetPSI = new ArrayList<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx(this.myProject).getFileManager();
        Set<VirtualFile> set2 = this.myPendingReparses;
        synchronized (set2) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI.addAll(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                PsiFile file2;
                if (!virtualFile.isValid()) continue;
                FileViewProvider pp = fileManager.findCachedViewProvider(virtualFile);
                PsiFile psiFile = file2 = pp == null ? null : fileManager.findFile(virtualFile);
                if (file2 == null) continue;
                FileSymbolTablesCache.processDirtyFile(toReparse, file2, virtualFile);
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file2 : toResetPSI) {
                    fileManager.setViewProvider(file2, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
    }

    private static void processDirtyFile(@NotNull List<VirtualFile> dirty, @NotNull PsiFile file2, @NotNull VirtualFile virtualFile) {
        if (SymbolTableProvider.isSourceFile(virtualFile) && file2 instanceof PsiFileImpl) {
            FileElement node = ((PsiFileImpl)file2).getTreeElement();
            if (node != null && node.isParsed()) {
                dirty.add(virtualFile);
            } else {
                ((PsiFileImpl)file2).clearCaches();
            }
        }
    }

    private void validate(PsiFile file2, int start, int end, int lengthShift) {
        VirtualFile key2 = FileSymbolTablesCache.key(file2);
        if (key2 != null) {
            this.packForFile(key2).updateOffsetsSynchronized(start, end, lengthShift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(@Nullable PsiFile file2, boolean reparse, Set<VirtualFile> processed2, boolean withIncludingFiles) {
        VirtualFile key2 = FileSymbolTablesCache.key(file2);
        if (key2 == null || !processed2.add(key2)) {
            return;
        }
        this.clearCache(key2);
        if (file2.isPhysical()) {
            this.myTableUpdater.addFileForUpdate(key2);
        }
        if (withIncludingFiles) {
            Collection<OCResolveConfiguration> configs;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspaceManager.getWorkspace(this.myProject);
            if (!OCInclusionContextUtil.isNeedToFindRoot(file2)) {
                for (OCResolveConfiguration oCResolveConfiguration : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(oCResolveConfiguration, key2);
                }
            }
            if (!(configs = OCInclusionContext.getBuildConfigurationByPchFile(key2, this.myProject)).isEmpty()) {
                Runnable runnable2 = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    Set<VirtualFile> set2 = this.myPendingReparses;
                    synchronized (set2) {
                        dirtySet.addAll(sourceFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.NON_MODAL);
                }
            }
            if (file2 instanceof OCFile) {
                for (OCFile including : ((OCFile)file2).resetIncludingFiles()) {
                    this.invalidate(including, reparse, processed2, true);
                    Set<VirtualFile> set2 = this.myPendingReparses;
                    synchronized (set2) {
                        dirtySet.add(FileSymbolTablesCache.key(including));
                    }
                }
            }
        }
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(null, false);
    }

    public void ensurePendingFilesProcessed(@Nullable ProgressIndicator indicator, boolean ensureOnlySourceFilesProcessed) {
        this.myTableUpdater.ensurePendingFilesProcessed(indicator, ensureOnlySourceFilesProcessed);
    }

    @NotNull
    public List<FileSymbolTable> allTablesForFile(OCFile file2) {
        VirtualFile virtualFile = FileSymbolTablesCache.key(file2);
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        return this.packForFile(virtualFile).getTablesSynchronized();
    }

    @NotNull
    public List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        return this.packForFile(virtualFile).getTablesSynchronized();
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        return this.packForFile(virtualFile).getTablesCountSynchronized();
    }

    @NotNull
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.get(virtualFile);
        if (pack != null) {
            return pack;
        }
        FileSymbolTablesPack newPack = new FileSymbolTablesPack();
        FileSymbolTablesPack prev = this.myCache.putIfAbsent(virtualFile, newPack);
        return prev == null ? newPack : prev;
    }

    public List<FileSymbolTable> allTables() {
        ArrayList<FileSymbolTable> result2 = new ArrayList<FileSymbolTable>();
        for (VirtualFile file2 : this.myCache.keySet()) {
            result2.addAll(this.allTablesForFile(file2));
        }
        return result2;
    }

    public void clearAllTables() {
        ArrayList packs = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs) {
            pack.onRemove();
        }
    }

    private void clearCache(@NotNull VirtualFile each) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.remove(each);
        if (pack != null) {
            pack.onRemove();
        }
    }

    @Nullable
    private static FileSymbolTablesPack readTablesForFile(FileSymbolTableSerializer serializer2, String projectLocationHash, VirtualFile file2) throws IOException {
        FileAttribute attribute;
        DataInputStream dis;
        if (ourDoNotReloadExistingSymbolsInTests == Boolean.TRUE) {
            return null;
        }
        MetaData metaData = FileSymbolTablesCache.readMetaData(serializer2, file2);
        boolean metaDataChanged = false;
        Iterator iterator = metaData.projectKeysWithPaths.keySet().iterator();
        while (iterator.hasNext()) {
            String key2 = (String)iterator.next();
            if (metaData.isFileUpToDate && metaData.checkProjectExistsForKey(key2)) continue;
            iterator.remove();
            FileAttribute attribute2 = FileSymbolTablesCache.getFileCacheAttributeForProjectKey(key2);
            DataOutputStream dos = attribute2.writeAttribute(file2);
            dos.close();
            metaDataChanged = true;
        }
        if (metaDataChanged) {
            FileSymbolTablesCache.writeMetaData(serializer2, file2, metaData);
        }
        if ((dis = (attribute = FileSymbolTablesCache.getFileCacheAttribute(projectLocationHash)).readAttribute(file2)) == null || dis.available() == 0) {
            return null;
        }
        long savedTimestamp = dis.readLong();
        if (savedTimestamp == file2.getTimeStamp()) {
            return serializer2.readSymbolTables(dis, file2);
        }
        return null;
    }

    void serializeTables(@NotNull String projectLocationHash, @NotNull Set<VirtualFile> tables, final @NotNull ProgressIndicator indicator) {
        AtomicInteger counter = new AtomicInteger();
        int size = tables.size();
        ConcurrentLinkedQueue<VirtualFile> queue = new ConcurrentLinkedQueue<VirtualFile>(tables);
        final FileAttribute cacheAttribute = FileSymbolTablesCache.getFileCacheAttribute(projectLocationHash);
        final String keyForSerialization = FileSymbolTablesCache.getKeyForSerialization(projectLocationHash);
        final String basePath = this.myProject.getBasePath();
        this.serializeParallel(indicator, (Consumer<FileSymbolTableSerializer>)((Consumer)serializer2 -> {
            VirtualFile file2;
            boolean ok = true;
            while (ok && (file2 = (VirtualFile)queue.poll()) != null) {
                indicator.checkCanceled();
                final VirtualFile finalFile = file2;
                ok = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Boolean compute() {
                        indicator.checkCanceled();
                        if (FileSymbolTablesCache.shouldSerializeTable(finalFile)) {
                            try {
                                MetaData metaData = FileSymbolTablesCache.readMetaData(serializer2, finalFile);
                                metaData.projectKeysWithPaths.put(keyForSerialization, basePath);
                                FileSymbolTablesCache.writeMetaData(serializer2, finalFile, metaData);
                                DataOutputStream dos = cacheAttribute.writeAttribute(finalFile);
                                dos.writeLong(finalFile.getTimeStamp());
                                FileSymbolTablesPack pack = FileSymbolTablesCache.this.packForFile(finalFile);
                                Object object = pack.getTablesAccessLock();
                                synchronized (object) {
                                    serializer2.writeSymbolTables(dos, pack);
                                }
                                dos.close();
                            }
                            catch (IOException e) {
                                LOG.error("Can't serialize file symbol table", (Throwable)e);
                                return false;
                            }
                        }
                        return true;
                    }
                });
                indicator.setFraction((double)counter.incrementAndGet() / (double)size);
            }
        }));
    }

    public static boolean areSymbolsLoaded(@NotNull Project project2) {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance = (FileSymbolTablesCache)((Object)project2.getComponent(FileSymbolTablesCache.class));
        if (instance == null) {
            return true;
        }
        if (!instance.shouldBuildTables()) {
            return true;
        }
        return instance.mySymbolsLoaded.get();
    }

    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
    }

    void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void removeUnusedTables() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeUnusedTables();
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result2.add((VirtualFile)entry.getKey());
        }
        return result2;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithUsedTables() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).hasUsedTables()) continue;
            result2.add((VirtualFile)entry.getKey());
        }
        return result2;
    }

    @NotNull
    private static MetaData readMetaData(FileSymbolTableSerializer serializer2, VirtualFile file2) throws IOException {
        DataInputStream dis = ourFileTablesMetaAttribute.readAttribute(file2);
        if (dis == null || dis.available() == 0) {
            return new MetaData();
        }
        boolean isUpToDate = dis.readLong() == file2.getTimeStamp();
        MetaData metaData = serializer2.readMetaData(dis);
        if (metaData == null) {
            return new MetaData();
        }
        metaData.isFileUpToDate = isUpToDate;
        return metaData;
    }

    private static void writeMetaData(FileSymbolTableSerializer serializer2, VirtualFile file2, MetaData metaData) throws IOException {
        DataOutputStream dos = ourFileTablesMetaAttribute.writeAttribute(file2);
        dos.writeLong(file2.getTimeStamp());
        serializer2.writeMetaData(dos, metaData);
        dos.close();
    }

    @NotNull
    private static String getKeyForSerialization(String projectLocationHash) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(TABLES_KEY_PREFIX);
            builder.append(":");
            builder.append(projectLocationHash);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @NotNull
    private static FileAttribute getFileCacheAttribute(String projectLocationHash) {
        return FileSymbolTablesCache.getFileCacheAttributeForProjectKey(FileSymbolTablesCache.getKeyForSerialization(projectLocationHash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static FileAttribute getFileCacheAttributeForProjectKey(@NotNull String key2) {
        FileAttribute attribute;
        Map<String, FileAttribute> map2 = ourFileCacheAttributes;
        synchronized (map2) {
            attribute = ourFileCacheAttributes.get(key2);
            if (attribute == null) {
                attribute = new FileAttribute(key2, FileSymbolTablesCache.getVersion(), false);
                ourFileCacheAttributes.put(key2, attribute);
            }
        }
        return attribute;
    }

    long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        THashSet processedFiles = new THashSet();
        Set notLoaded = ContainerUtil.newConcurrentSet();
        notLoaded.addAll(filesToLoad);
        ArrayDeque<VirtualFile> workset = new ArrayDeque<VirtualFile>(filesToLoad);
        Set dirtySet = ContainerUtil.newConcurrentSet();
        MultiMap importsMap = new MultiMap();
        long total = notLoaded.size();
        this.serializeParallel(indicator, (Consumer<FileSymbolTableSerializer>)((Consumer)arg_0 -> this.lambda$deserializeTables$8(indicator, workset, (Set)processedFiles, projectLocationHash, dirtySet, notLoaded, indicatorScale, total, importsMap, arg_0)));
        workset.addAll(dirtySet);
        while (!workset.isEmpty()) {
            VirtualFile file2 = workset.pop();
            for (VirtualFile dep : importsMap.get((Object)file2)) {
                if (!dirtySet.add(dep)) continue;
                workset.push(dep);
            }
        }
        for (VirtualFile file3 : dirtySet) {
            this.clearCache(file3);
        }
        return total - (long)notLoaded.size();
    }

    private void serializeParallel(ProgressIndicator indicator, Consumer<FileSymbolTableSerializer> task) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (FileSymbolTableSerializer serializer2 : this.mySerializers) {
            futures.add(ApplicationManager.getApplication().executeOnPooledThread(() -> task.consume((Object)serializer2)));
        }
        SmartList exceptions = new SmartList();
        for (Future future2 : futures) {
            try {
                future2.get();
            }
            catch (InterruptedException serializer2) {
            }
            catch (ExecutionException e) {
                exceptions.add(e.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    private static boolean shouldSerializeTable(@NotNull VirtualFile file2) {
        return file2.isValid() && file2 instanceof VirtualFileWithId && !file2.isDirectory();
    }

    public void handleFileChange(@NotNull PsiFile file2, boolean hasMacro) {
        if (SymbolTableProvider.isSourceFile(file2)) {
            this.incOutOfCodeBlockTrackers(file2);
            this.invalidate(file2, false, (Set<VirtualFile>)new THashSet(), hasMacro);
            this.schedulePSIUpdates();
            OCInclusionContextUtil.invalidateHeaderContextsExcept(OCInclusionContextUtil.getVirtualFile(file2), file2.getProject());
        }
        if (hasMacro) {
            OCImportGraph.invalidateHeaderRootsCache(file2.getProject());
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(OCInclusionContextUtil.getVirtualFile(file2), file2.getProject());
        }
    }

    private void incOutOfCodeBlockTrackers(@NotNull PsiFile file2) {
        this.myOutOfBlockModificationTracker.incModificationCount();
        SymbolTableProvider.fireOutOfCodeBlockModification(file2);
    }

    public void dumpStats() {
        ArrayList list = new ArrayList(this.myCache.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int c = Comparing.compare((int)((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), (int)((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (ts1.size() > 0 && ts2.size() > 0) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Comparing.compare((int)ts1.size(), (int)ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file2 = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            ArrayList<FileSymbolTable> tables = new ArrayList<FileSymbolTable>(pack.getTablesSynchronized());
            if (tables.size() <= 1) continue;
            ++multiTableFiles;
            Function tablePrinter = table -> Integer.toString(table.getUsageCount());
            System.out.println("-- " + file2.getName() + " (" + tables.size() + "): " + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
            Collections.sort(tables, (o1, o2) -> Comparing.compare((int)o2.getUsageCount(), (int)o1.getUsageCount()));
            System.out.println("   " + file2.getName() + " (" + tables.size() + "): " + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
        }
        System.out.println("============================");
        System.out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$deserializeTables$8(final @NotNull ProgressIndicator indicator, ArrayDeque workset, Set processedFiles, final @NotNull String projectLocationHash, final Set dirtySet, Set notLoaded, double indicatorScale, long total, MultiMap importsMap, final FileSymbolTableSerializer serializer2) {
        try {
            while (true) {
                VirtualFile file2;
                indicator.checkCanceled();
                ArrayDeque arrayDeque = workset;
                synchronized (arrayDeque) {
                    if (workset.isEmpty()) {
                        return;
                    }
                    file2 = (VirtualFile)workset.pop();
                    if (!processedFiles.add(file2)) {
                        continue;
                    }
                }
                FileSymbolTablesPack pack = (FileSymbolTablesPack)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<FileSymbolTablesPack, IOException>(){

                    public FileSymbolTablesPack compute() throws IOException {
                        indicator.checkCanceled();
                        if (!FileSymbolTablesCache.shouldSerializeTable(file2)) {
                            return null;
                        }
                        FileSymbolTablesPack p = FileSymbolTablesCache.readTablesForFile(serializer2, projectLocationHash, file2);
                        if (p == null) {
                            dirtySet.add(file2);
                        }
                        return p;
                    }
                });
                if (pack == null) continue;
                notLoaded.remove(file2);
                indicator.setFraction(indicatorScale * ((double)total - (double)notLoaded.size()) / (double)total);
                if (pack.isEmpty()) continue;
                for (FileSymbolTable table : pack.tablesView()) {
                    table.processIncludes((Processor<OCIncludeSymbol>)((Processor)include -> {
                        indicator.checkCanceled();
                        VirtualFile targetFile = include.getTargetFile();
                        if (targetFile != null) {
                            ArrayDeque arrayDeque = workset;
                            synchronized (arrayDeque) {
                                workset.push(targetFile);
                                importsMap.putValue((Object)targetFile, (Object)file2);
                            }
                        }
                        return true;
                    }));
                }
                this.myCache.put(file2, pack);
            }
        }
        catch (IOException e) {
            LOG.error("Can't deserialize file symbol table", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ boolean lambda$invalidateDirtyIncludes$1(Set dirtyNames, PsiFile psiFile, Set invalidatedFiles, Ref somethingWasChanged, OCIncludeSymbol include) {
        if (dirtyNames.contains(include.getLastPathComponent())) {
            this.invalidate(psiFile, true, invalidatedFiles, true);
            somethingWasChanged.set((Object)true);
            Set<VirtualFile> set2 = this.myPendingReparses;
            synchronized (set2) {
                this.myPendingReparses.add(FileSymbolTablesCache.key(psiFile));
            }
        }
        return true;
    }

    private class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final Key<String> FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");

        private OCCodeBlockModificationListener() {
        }

        @Override
        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            int start = 0;
            int end = 0;
            int lengthShift = 0;
            PsiFile file2 = event.getFile();
            PsiElement child = event.getChild();
            if (file2 == null && child != null) {
                file2 = child.getContainingFile();
            }
            if (file2 == null && event.getParent() != null) {
                file2 = event.getParent().getContainingFile();
            }
            PsiElement parent = event.getParent();
            if (!SymbolTableProvider.isSourceFile(file2)) {
                return;
            }
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: {
                    if (event.getParent() instanceof PsiFile) break;
                    this.processBeforeChange(file2);
                    break;
                }
                case BEFORE_CHILD_REPLACEMENT: {
                    this.processBeforeChange(file2);
                    break;
                }
                case BEFORE_CHILD_ADDITION: {
                    this.processBeforeChange(file2);
                    break;
                }
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(file2);
                    break;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    break;
                }
                case CHILD_ADDED: {
                    start = event.getOffset();
                    assert (child != null);
                    end = start + child.getTextLength();
                    lengthShift = end - start;
                    this.processChange(file2, parent);
                    break;
                }
                case CHILD_REMOVED: {
                    start = event.getOffset();
                    end = event.getOffset();
                    lengthShift = -event.getOldLength();
                    this.processChange(file2, parent);
                    break;
                }
                case CHILD_REPLACED: {
                    start = event.getOffset();
                    assert (child != null);
                    end = start + child.getTextLength();
                    lengthShift = end - start - event.getOldLength();
                    this.processChange(file2, parent);
                    break;
                }
                case CHILDREN_CHANGED: {
                    if (event.isGenericChange()) break;
                    if (child != null) {
                        start = event.getOffset();
                        end = start + child.getTextLength();
                        lengthShift = end - start - event.getOldLength();
                    }
                    this.processChange(file2, parent);
                    break;
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    FileSymbolTablesCache.this.incOutOfCodeBlockTrackers(file2);
                    break;
                }
                default: {
                    LOG.error("Unknown code:" + (Object)((Object)event.getCode()));
                }
            }
            if (lengthShift != 0) {
                FileSymbolTablesCache.this.validate(file2, start, end, lengthShift);
            }
            if (event.isGenericChange() && (stamp = (String)file2.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(this.macroStamp(file2))) {
                    FileSymbolTablesCache.this.handleFileChange(file2, true);
                }
                file2.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
        }

        private void processBeforeChange(@NotNull PsiFile file2) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!(file2 instanceof OCCodeFragment) && file2.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file2.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)this.macroStamp(file2));
            }
        }

        private void processChange(PsiFile file2, PsiElement parent) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!(file2 instanceof OCCodeFragment) && !this.isInsideCodeBlock(parent)) {
                FileSymbolTablesCache.this.handleFileChange(file2, false);
            }
        }

        @NotNull
        private String macroStamp(PsiFile file2) {
            if (!(file2 instanceof OCFile)) {
                return "";
            }
            StringBuilder acc = new StringBuilder();
            this.processASTNodeForMacros((ASTNode)file2.getNode(), acc);
            return acc.toString();
        }

        private void processASTNodeForMacros(@Nullable ASTNode node, @NotNull StringBuilder acc) {
            if (node == null) {
                return;
            }
            IElementType elementType = node.getElementType();
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node.getText());
            }
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                this.processASTNodeForMacros(child, acc);
            }
        }

        private boolean isInsideCodeBlock(@Nullable PsiElement element) {
            if (element instanceof PsiFileSystemItem) {
                return false;
            }
            if (element == null || element.getParent() == null) {
                return true;
            }
            PsiElement parent = element;
            while (!(parent instanceof PsiFile) && !(parent instanceof PsiDirectory) && parent != null) {
                if (parent instanceof OCLocalBlock && !(parent instanceof OCEagerBlockStatementImpl)) {
                    return true;
                }
                parent = parent.getParent();
            }
            return false;
        }
    }

    static class MetaData {
        private Map<String, String> projectKeysWithPaths = new HashMap<String, String>();
        private transient boolean isFileUpToDate;

        MetaData() {
        }

        private boolean checkProjectExistsForKey(@NotNull String projectKey) {
            String projectPath = this.projectKeysWithPaths.get(projectKey);
            return projectPath != null && new File(projectPath).exists();
        }
    }
}

