/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesPack
implements Function<OCSymbol, OCSymbol> {
    @NotNull
    private final ArrayList<FileSymbolTable> myTables = new ArrayList();
    @Nullable
    private transient Map<OCSymbol, OCSymbol> myInternary;
    @Nullable
    private transient DeepEqual.Resolver myEqualityResolver;
    private volatile transient boolean myIsChanged;

    public boolean isEmpty() {
        return this.myTables.isEmpty();
    }

    public List<FileSymbolTable> tablesView() {
        return Collections.unmodifiableList(this.myTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myTables.trimToSize();
            for (FileSymbolTable pack : this.myTables) {
                pack.compact();
            }
            this.myInternary = null;
            this.myEqualityResolver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompactSynchronized(@NotNull FileSymbolTable table) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            try {
                table.internSymbols(this);
                this.addTableInternal(table);
                table.incUsageCount();
                FileSymbolTablesPack.addToImportGraph(table);
            }
            finally {
                this.myEqualityResolver = null;
            }
        }
    }

    private void addTableInternal(@NotNull FileSymbolTable table) {
        this.myIsChanged = true;
        this.myTables.add(table);
        table.setPackStamp(this.getTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnusedTables() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            boolean hasUnused = false;
            for (FileSymbolTable table : this.myTables) {
                if (table.getUsageCount() != 0) continue;
                hasUnused = true;
                break;
            }
            if (hasUnused) {
                this.myIsChanged = true;
                ArrayList<FileSymbolTable> oldTables = new ArrayList<FileSymbolTable>(this.myTables);
                this.myTables.clear();
                for (FileSymbolTable table : oldTables) {
                    if (table.getUsageCount() > 0) {
                        this.addTableInternal(table);
                        continue;
                    }
                    FileSymbolTablesPack.removeFromImportGraph(table);
                }
            }
        }
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    private int getTimeStamp() {
        return this.myTables.size();
    }

    private static void addToImportGraph(@NotNull FileSymbolTable table) {
        table.processIncludes((Processor<OCIncludeSymbol>)((Processor)symbol -> {
            VirtualFile header = symbol.getTargetFile();
            if (header != null && header.isValid()) {
                OCImportGraph.addHeaderIncluder(table.getProject(), header, table.getContainingFile());
            }
            return true;
        }));
    }

    private static void removeFromImportGraph(@NotNull FileSymbolTable table) {
        table.processIncludes((Processor<OCIncludeSymbol>)((Processor)symbol -> {
            VirtualFile header = symbol.getTargetFile();
            if (header != null) {
                OCImportGraph.removeHeaderIncluder(table.getProject(), header, table.getContainingFile());
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove() {
        ArrayList<FileSymbolTable> arrayList = this.myTables;
        synchronized (arrayList) {
            for (FileSymbolTable table : this.myTables) {
                FileSymbolTablesPack.removeFromImportGraph(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptySynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ArrayList<FileSymbolTable> getTablesSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return new ArrayList<FileSymbolTable>(this.myTables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTablesCountSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.size();
        }
    }

    @NotNull
    public Object getTablesAccessLock() {
        return this.myTables;
    }

    public OCSymbol fun(OCSymbol symbol) {
        OCSymbol same;
        if (this.myEqualityResolver == null) {
            this.myEqualityResolver = DeepEqual.newResolver();
        }
        if (this.myInternary == null) {
            this.myInternary = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return object.hashCodeExcludingOffset();
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    ProgressManager.checkCanceled();
                    return FileSymbolTablesPack.this.myEqualityResolver.equalObjects(o1, o2);
                }
            });
        }
        if ((same = this.myInternary.get(symbol)) != null) {
            return same;
        }
        symbol.compact();
        this.myInternary.put(symbol, symbol);
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetsSynchronized(int start, int end, int lengthShift) {
        THashSet processed2 = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

            public int computeHashCode(OCSymbol object) {
                return System.identityHashCode(object);
            }

            public boolean equals(OCSymbol o1, OCSymbol o2) {
                return o1 == o2;
            }
        });
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                table.updateOffsets(start, end, lengthShift, (THashSet<OCSymbol>)processed2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTable findConformingTable(@NotNull OCInclusionContext context, int sinceTimeStamp, @Nullable Ref<Integer> outCurrentTimeStamp) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            int timeStamp = this.getTimeStamp();
            if (outCurrentTimeStamp != null) {
                outCurrentTimeStamp.set((Object)timeStamp);
            }
            if (timeStamp > sinceTimeStamp) {
                for (int i2 = 0; i2 < this.myTables.size(); ++i2) {
                    FileSymbolTable table = this.myTables.get(i2);
                    if (table.getPackStamp() <= sinceTimeStamp || !context.checkConformanceAndFillSignatures(table)) continue;
                    int usingCount = table.incUsageCount();
                    if (usingCount < 0) {
                        for (FileSymbolTable t : this.myTables) {
                            t.resetUsageCount();
                        }
                    } else {
                        for (int prev = i2 - 1; prev >= 0 && this.myTables.get(prev).getUsageCount() + 2 < usingCount; --prev) {
                            Collections.swap(this.myTables, prev, prev + 1);
                        }
                    }
                    return table;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsedTables() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                if (table.getUsageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    static class FileSymbolsPackSerializer
    extends FieldSerializer<FileSymbolTablesPack> {
        public FileSymbolsPackSerializer(Kryo kryo) {
            super(kryo, FileSymbolTablesPack.class);
        }

        protected FileSymbolTablesPack create(Kryo kryo, Input input, Class<FileSymbolTablesPack> type2) {
            return new FileSymbolTablesPack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileSymbolTablesPack read(Kryo kryo, Input input, Class<FileSymbolTablesPack> type2) {
            FileSymbolTablesPack result2 = (FileSymbolTablesPack)super.read(kryo, input, type2);
            Object object = result2.getTablesAccessLock();
            synchronized (object) {
                for (FileSymbolTable table : result2.myTables) {
                    FileSymbolTablesPack.addToImportGraph(table);
                }
            }
            return result2;
        }
    }
}

