/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileSymbols
extends OCRecursiveVisitor {
    private MostlySingularMultiMap<String, OCSymbol> myLocalSymbolsMap = new MostlySingularMultiMap();
    private List<OCSymbol> myLocalNamespaceUsings = new ArrayList<OCSymbol>();
    private boolean myIsInsideLocalScope = false;
    private Set<VirtualFile> myUsedFiles = new HashSet<VirtualFile>();
    private static final NotNullLazyKey<OCFileSymbols, AnnotationSession> CACHE = NotNullLazyKey.create((String)"LOCAL_SYMBOL_TABLE_DURING_ANNOTATION", dom -> {
        PsiFile file2 = dom.getFile();
        OCFileSymbols symbols = new OCFileSymbols();
        file2.accept((PsiElementVisitor)symbols);
        for (String key2 : symbols.myLocalSymbolsMap.keySet()) {
            Iterable iterable = symbols.myLocalSymbolsMap.get((Object)key2);
            if (!(iterable instanceof List) || ((List)iterable).size() <= 1) continue;
            Collections.sort((List)iterable, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE);
        }
        Collections.sort(symbols.myLocalNamespaceUsings, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE);
        return symbols;
    });

    private OCFileSymbols() {
    }

    @Override
    public void visitOCElement(OCElement scopeElement) {
        if (scopeElement instanceof OCCallable || scopeElement instanceof OCTemplateParameterList) {
            boolean old = this.myIsInsideLocalScope;
            this.myIsInsideLocalScope = true;
            super.visitOCElement(scopeElement);
            this.myIsInsideLocalScope = old;
        } else {
            super.visitOCElement(scopeElement);
        }
    }

    @Override
    public void visitLocalSymbolDeclarator(OCLocalSymbolDeclarator declarator) {
        if (!this.myIsInsideLocalScope) {
            super.visitLocalSymbolDeclarator(declarator);
        } else {
            Object symbol = declarator.getLocalSymbol();
            if (symbol != null && symbol.getScope() != null) {
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    this.myLocalNamespaceUsings.add((OCSymbol)symbol);
                } else {
                    this.myLocalSymbolsMap.add((Object)symbol.getName(), symbol);
                }
            }
        }
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        if (!this.myIsInsideLocalScope) {
            super.visitStructLike(struct);
        } else {
            this.visitLocalSymbolDeclarator(struct);
            OCStructSymbol structSymbol = (OCStructSymbol)struct.getLocalSymbol();
            if (struct instanceof OCEnum) {
                ((OCEnum)struct).processEnumConsts((Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol != null && symbol.getScope() != null) {
                        if (structSymbol != null && structSymbol.getKind() == OCSymbolKind.ENUM) {
                            ((OCDeclaratorSymbol)symbol).setType(structSymbol.getType());
                        } else {
                            ((OCDeclaratorSymbol)symbol).setType(OCIntType.INT);
                        }
                        this.myLocalSymbolsMap.add((Object)symbol.getName(), symbol);
                    }
                    return true;
                }));
            } else {
                this.visitElement(struct);
            }
        }
    }

    @Override
    public void visitMacroCallArgument(OCMacroCallArgument argument) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canBeLocalSymbol(@NotNull OCFile file2, String name) {
        Object object = file2.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file2.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols localSymbols = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                return localSymbols.myLocalSymbolsMap.containsKey((Object)name) || !localSymbols.myLocalNamespaceUsings.isEmpty();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Iterable<OCSymbol> getLocalSymbols(@NotNull OCFile file2, String name) {
        Object object = file2.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = file2.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols localSymbols = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                if (localSymbols.myLocalNamespaceUsings.size() == 0) {
                    return localSymbols.myLocalSymbolsMap.get((Object)name);
                }
                Iterable iterable = localSymbols.myLocalSymbolsMap.get((Object)name);
                if (iterable instanceof Set) {
                    ArrayList named = new ArrayList(1);
                    named.add(iterable.iterator().next());
                    return ContainerUtil.mergeSortedLists(localSymbols.myLocalNamespaceUsings, named, OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE, (boolean)false);
                }
                if (iterable instanceof List) {
                    return ContainerUtil.mergeSortedLists(localSymbols.myLocalNamespaceUsings, (List)((List)iterable), OCSymbolOffsetUtil.SYMBOL_COMPARATOR_BY_SCOPE, (boolean)false);
                }
                return localSymbols.myLocalNamespaceUsings;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImportUsed(OCFile currentFile, VirtualFile filePath) {
        if (currentFile.getContext() != null) {
            return true;
        }
        Object object = currentFile.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = currentFile.getCurrentAnnotationSession();
            if (annotationSession != null) {
                return ((OCFileSymbols)((Object)OCFileSymbols.CACHE.getValue((UserDataHolder)annotationSession))).myUsedFiles.contains(filePath);
            }
        }
        return true;
    }

    private void recurseMarkImportNeeded(Project project2, VirtualFile toAdd) {
        if (!this.myUsedFiles.add(toAdd)) {
            return;
        }
        for (VirtualFile including : OCImportGraph.findImmediateIncludingFiles(project2, toAdd, true)) {
            this.recurseMarkImportNeeded(project2, including);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markImportNeeded(OCFile currentFile, VirtualFile importedFile) {
        Object object = currentFile.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = currentFile.getCurrentAnnotationSession();
            if (annotationSession != null && importedFile != null) {
                ((OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession))).recurseMarkImportNeeded(currentFile.getProject(), importedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markImportsNeeded(OCFile currentFile, Collection<VirtualFile> importedFiles) {
        if (importedFiles.isEmpty()) {
            return;
        }
        Object object = currentFile.getAnnotationSessionLock();
        synchronized (object) {
            AnnotationSession annotationSession = currentFile.getCurrentAnnotationSession();
            if (annotationSession != null) {
                OCFileSymbols ss = (OCFileSymbols)((Object)CACHE.getValue((UserDataHolder)annotationSession));
                for (VirtualFile importedFile : importedFiles) {
                    if (importedFile == null) continue;
                    ss.myUsedFiles.add(importedFile);
                }
            }
        }
    }

    public static void markImportNeeded(OCFile currentFile, OCSymbol symbol) {
        OCFileSymbols.markImportNeeded(currentFile, symbol.getContainingFile());
    }

    public static void markSymbolAsUsed(OCFile currentFile, OCSymbol symbol, PsiElement usage) {
        Object parent;
        if (symbol == null || currentFile.getContext() != null) {
            return;
        }
        OCGlobalUnusedInspection.markSymbolAsUsed(symbol, usage);
        if (symbol instanceof OCSymbolWithParent && (parent = ((OCSymbolWithParent)symbol).getParent()) != null) {
            symbol = parent;
        }
        OCFileSymbols.markImportNeeded(currentFile, symbol);
    }

    public static boolean isSymbolImported(@NotNull OCFile currentFile, @Nullable OCSymbol symbol) {
        return OCFileSymbols.isSymbolImported(currentFile, symbol, null);
    }

    public static boolean isSymbolImported(@NotNull OCFile currentFile, @Nullable OCSymbol symbol, @Nullable PsiElement before) {
        if (symbol == null || currentFile.getContext() != null) {
            return false;
        }
        if (Comparing.equal((Object)symbol.getContainingFile(), (Object)currentFile.getVirtualFile())) {
            return true;
        }
        VirtualFile file2 = OCFileSymbols.getFileToImport(currentFile, symbol);
        if (file2 != null && before != null) {
            OCIncludeDirective directive = currentFile.findIncludeDirective(file2);
            return directive == null || directive.getRangeWithMacros().getStartOffset() <= OCElementUtil.getRangeWithMacros(before).getStartOffset();
        }
        return file2 != null;
    }

    @NotNull
    private static OCFileGlobalSymbols getSymbols(@NotNull OCFile currentFile) {
        return OCFileGlobalSymbolsCache.getInstance(currentFile.getProject()).forFile(currentFile);
    }

    public static boolean isImportRequired(@NotNull OCFile currentFile, @Nullable VirtualFile filePath) {
        if (filePath == null) {
            return false;
        }
        return currentFile.getContext() != null || OCFileSymbols.getSymbols(currentFile).getRequiredImports().contains(filePath);
    }

    @Nullable
    public static VirtualFile getFileToImport(@NotNull OCFile currentFile, @Nullable OCSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        return OCFileSymbols.getSymbols(currentFile).getSymbolToImport().get(symbol);
    }
}

