/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapCacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolTablesBuildingActivity {
    @Nullable
    private static NotNullProducer<ProgressIndicator> ourIndicatorFactory;
    @NotNull
    private static final Set<Thread> mySymbolBuildingThreads;
    public static final NotNullLazyKey<List<String>, Project> ACTIVITY_LOG;
    private final Project project;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    public static OCSymbolTablesBuildingActivity getInstance(Project project2) {
        return (OCSymbolTablesBuildingActivity)ServiceManager.getService((Project)project2, OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project2) {
        this.project = project2;
    }

    @NotNull
    public SimpleModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public void assertParsingAndSymbolBuildingAllowed() {
        this.assertParsingAndSymbolBuildingAllowed(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertParsingAndSymbolBuildingAllowed(Thread thread) {
        boolean allowed;
        boolean bl = allowed = FileSymbolTablesCache.areSymbolsLoaded(this.project) || mySymbolBuildingThreads.contains(thread);
        if (!allowed) {
            String logEntries;
            List log;
            List list = log = (List)ACTIVITY_LOG.getValue((UserDataHolder)this.project);
            synchronized (list) {
                logEntries = StringUtil.join((Collection)log, (String)"\n");
            }
            OCLog.LOG.error("Symbol building is not allowed: " + System.currentTimeMillis() + " . \nLoaded: " + FileSymbolTablesCache.areSymbolsLoaded(this.project) + "\nDumb: " + DumbService.isDumb((Project)this.project) + "\nPrevious activities: \n" + logEntries);
        }
    }

    public static void setIndicatorFactory(@Nullable NotNullProducer<ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(Mode.FAST);
    }

    public void rebuildSymbols(@NotNull Mode mode) {
        this.runSymbolActivity("rebuildSymbols", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            this.buildSymbolsInternal((MyProgressIndicator)((Object)indicator), mode);
            return true;
        }));
    }

    public void rebuildSwiftModules(FileType swiftFileType) {
        this.runSymbolActivity("rebuildSwiftModules", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            this.processSwiftModules(ContainerUtil.createMaybeSingletonList((Object)new LightVirtualFile("", swiftFileType, (CharSequence)"")), (MyProgressIndicator)((Object)indicator));
            return true;
        }));
    }

    public void buildSymbolsForFiles(@NotNull Collection<VirtualFile> files) {
        this.runSymbolActivity("buildSymbolsForFiles", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            this.buildSymbolsForFilesInternal((MyProgressIndicator)((Object)indicator), files);
            return true;
        }));
    }

    public void rebuildModuleMaps() {
        this.runSymbolActivity("rebuildModuleMaps", (Processor<MyProgressIndicator>)((Processor)indicator -> {
            this.buildModuleMapsInternal((MyProgressIndicator)((Object)indicator));
            return true;
        }));
    }

    private void buildModuleMapsInternal(@NotNull MyProgressIndicator indicator) {
        ModuleMapCache.getInstance(this.project).reset();
        ArrayList tasks = ContainerUtil.newArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (TaskProvider<?> task : ModuleMapCacheBuilder.getInstance(this.project).getTasks((ProgressIndicator)indicator)) {
                tasks.add(OCSymbolTablesBuildingActivity.createTask(task, (ProgressIndicator)indicator));
            }
        });
        if (!tasks.isEmpty()) {
            indicator.setText("Building Module Maps...");
            indicator.startTiming("Building Module Maps");
            indicator.setIndeterminate(false);
            indicator.setInterval(0.0, 1.0);
            indicator.setFraction(0.0);
            OCSymbolTablesBuildingActivity.processFutures(tasks);
            indicator.logTiming();
        }
    }

    private void runSymbolActivity(final @NotNull String activityName, final @NotNull Processor<MyProgressIndicator> activity) {
        final Runnable r = () -> DumbService.getInstance((Project)this.project).queueTask(new DumbModeTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void performInDumbMode(@NotNull ProgressIndicator original) {
                final MyProgressIndicator indicator = new MyProgressIndicator(original);
                class MyDisposable
                implements Disposable {
                    boolean shouldCancel = true;

                    MyDisposable() {
                    }

                    public void dispose() {
                        if (this.shouldCancel) {
                            indicator.cancel();
                        }
                    }
                }
                MyDisposable cancelOnProjectDispose = new MyDisposable();
                try {
                    List log = (List)ACTIVITY_LOG.getValue((UserDataHolder)OCSymbolTablesBuildingActivity.this.project);
                    long start = System.currentTimeMillis();
                    List list = log;
                    synchronized (list) {
                        log.add(activityName + " " + start + ": START");
                    }
                    Disposer.register((Disposable)OCSymbolTablesBuildingActivity.this.project, (Disposable)cancelOnProjectDispose);
                    activity.process((Object)indicator);
                    cancelOnProjectDispose.shouldCancel = false;
                    list = log;
                    synchronized (list) {
                        log.add(activityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
                    }
                }
                catch (Throwable t) {
                    if (!OCSymbolTablesBuildingActivity.this.project.isDisposed() && OCSymbolTablesBuildingActivity.this.project.isOpen()) {
                        boolean pce = t instanceof ProcessCanceledException;
                        OCLog.LOG.error("Unexpected exception during symbol building (" + activityName + ")", pce ? new RuntimeException(t) : t);
                    }
                }
                finally {
                    Disposer.dispose((Disposable)cancelOnProjectDispose);
                }
            }
        });
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (app.isUnitTestMode() && app.isWriteAccessAllowed()) {
            ApplicationAdapter applicationListener = new ApplicationAdapter(){

                public void afterWriteActionFinished(@NotNull Object action) {
                    app.removeApplicationListener((ApplicationListener)this);
                    r.run();
                }
            };
            app.addApplicationListener((ApplicationListener)applicationListener);
        } else {
            r.run();
        }
    }

    private void buildSymbolsForFilesInternal(@NotNull MyProgressIndicator indicator, @NotNull Collection<VirtualFile> sourceFiles) {
        FileSymbolTablesCache cache2 = FileSymbolTablesCache.getInstance(this.project);
        if (!cache2.shouldBuildTables()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            if (indicator.isCanceled()) {
                return;
            }
            cache2.notifySymbolsUnloaded();
            cache2.reparseCachedPsiFiles();
        }));
        indicator.checkCanceled();
        indicator.setText("Updating symbols...");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        indicator.setInterval(indicator.getFraction(), 1.0);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFiles).processBuildFiles();
        this.notifySymbolsAreLoadedAndReparseCachedFiles(cache2, indicator);
    }

    private void buildSymbolsInternal(@NotNull MyProgressIndicator indicator, @NotNull Mode mode) {
        FileSymbolTablesCache cache2 = FileSymbolTablesCache.getInstance(this.project);
        if (!cache2.shouldBuildTables()) {
            return;
        }
        if (ApplicationManagerEx.getApplicationEx().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        indicator.checkCanceled();
        indicator.setText("Building symbols...");
        indicator.setText2("");
        indicator.setIndeterminate(true);
        indicator.startTiming("Clearing symbols");
        String[] projectLocationHash = new String[1];
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> {
            if (indicator.isCanceled()) {
                return;
            }
            cache2.notifySymbolsUnloaded();
            cache2.clearAllTables();
            cache2.reparseCachedPsiFiles();
            this.clearAllSymbolDependentCaches();
            projectLocationHash[0] = this.project.getLocationHash();
        }));
        indicator.logTiming();
        indicator.checkCanceled();
        indicator.setText("Loading symbols...");
        indicator.startTiming("Loading symbols");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Collection<VirtualFile> allFiles = OCSymbolTablesBuildingActivity.getFilesToBuildCachesForSafely((ProgressIndicator)indicator, cache2);
        ArrayList sourceFiles = new ArrayList();
        OCSymbolTablesBuildingActivity.runReadActionSafely((ProgressIndicator)indicator, () -> sourceFiles.addAll(ContainerUtil.findAll((Collection)allFiles, file2 -> !OCInclusionContextUtil.isNeedToFindRoot(file2, this.project))));
        long loadedFileCount = 0L;
        if (mode != Mode.FULL) {
            loadedFileCount = cache2.deserializeTables(projectLocationHash[0], allFiles, (ProgressIndicator)indicator, 0.25);
        }
        double loadedFraction = indicator.getFraction();
        double savingFraction = 1.0 - 0.1 * (double)((long)allFiles.size() - loadedFileCount) / (double)Math.max(1, allFiles.size());
        indicator.logTiming();
        HashSet loadedFiles = new HashSet(cache2.getCachedFiles());
        indicator.checkCanceled();
        indicator.setText(loadedFiles.isEmpty() ? "Building symbols..." : "Updating symbols...");
        indicator.startTiming("Building symbols");
        List sourceFilesWithoutTables = ContainerUtil.findAll(sourceFiles, arg_0 -> OCSymbolTablesBuildingActivity.lambda$buildSymbolsInternal$13((Set)loadedFiles, arg_0));
        List<VirtualFile> sourceFilesToIndex = mode == Mode.COMPACT ? sourceFiles : sourceFilesWithoutTables;
        double sourcePart = sourceFilesToIndex.size();
        double headerWithoutTablesCount = allFiles.size() - sourceFiles.size();
        double headersPart = headerWithoutTablesCount * 0.2;
        double sourceFraction = loadedFraction + (savingFraction - loadedFraction) * (sourcePart / Math.max(sourcePart + headersPart, 1.0));
        indicator.setInterval(loadedFraction, sourceFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, sourceFilesToIndex).processBuildFiles();
        indicator.checkCanceled();
        this.processSwiftModules(allFiles, indicator);
        HashSet headersWithoutTables = new HashSet(allFiles);
        if (mode == Mode.COMPACT) {
            headersWithoutTables.removeAll(cache2.getFilesWithUsedTables());
        } else {
            headersWithoutTables.removeAll(cache2.getCachedFiles());
        }
        indicator.setInterval(indicator.getFraction(), savingFraction);
        new OCSymbolTableBuilder(this.project, (ProgressIndicator)indicator, (Collection<VirtualFile>)headersWithoutTables).processBuildFiles();
        indicator.logTiming();
        if (mode == Mode.COMPACT) {
            cache2.removeUnusedTables();
        }
        HashSet modifiedTables = new HashSet(cache2.getFilesWithChangedTables());
        this.notifySymbolsAreLoadedAndReparseCachedFiles(cache2, indicator);
        indicator.checkCanceled();
        indicator.setText("Saving symbols...");
        indicator.startTiming("Saving symbols");
        indicator.setInterval(savingFraction, 1.0);
        cache2.serializeTables(projectLocationHash[0], (Set<VirtualFile>)modifiedTables, (ProgressIndicator)indicator);
        indicator.logTiming();
        FileSymbolTable.reportStats(this.project);
    }

    private void processSwiftModules(@NotNull Collection<VirtualFile> allFiles, @NotNull MyProgressIndicator indicator) {
        ArrayList tasks = ContainerUtil.newArrayList();
        for (SymbolTableProvider provider2 : (SymbolTableProvider[])SymbolTableProvider.INSTANCE.getExtensions()) {
            List<TaskProvider<?>> additionalActivities = provider2.getItemProviderAndWorkerForAdditionalSymbolLoading(this.project, (ProgressIndicator)indicator, allFiles);
            if (additionalActivities == null) continue;
            for (TaskProvider<?> taskProvider : additionalActivities) {
                tasks.add(OCSymbolTablesBuildingActivity.createTask(taskProvider, (ProgressIndicator)indicator));
            }
        }
        if (!tasks.isEmpty()) {
            indicator.setText("Processing Swift modules...");
            indicator.setInterval(0.0, 1.0);
            indicator.setFraction(0.0);
            OCSymbolTablesBuildingActivity.processFutures(tasks);
        }
    }

    private void notifySymbolsAreLoadedAndReparseCachedFiles(@NotNull FileSymbolTablesCache cache2, @NotNull MyProgressIndicator indicator) {
        indicator.checkCanceled();
        OCSymbolTablesBuildingActivity.runReadActionSafely((ProgressIndicator)indicator, () -> {
            indicator.checkCanceled();
            cache2.compact();
            cache2.notifySymbolsLoaded();
        });
        indicator.checkCanceled();
        Runnable runnable2 = () -> {
            if (this.project.isDisposed() || indicator.isCanceled()) {
                return;
            }
            cache2.reparseCachedPsiFiles();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            TransactionGuard.getInstance().submitTransactionAndWait(runnable2);
        } else {
            TransactionGuard.submitTransaction((Disposable)this.project, (Runnable)runnable2);
        }
    }

    private void clearAllSymbolDependentCaches() {
        this.myModificationTracker.incModificationCount();
        for (OCResolveConfiguration oCResolveConfiguration : OCWorkspaceManager.getWorkspace(this.project).getConfigurations()) {
            OCInclusionContext.onPrecompiledContextChange(oCResolveConfiguration);
            OCInclusionContext.clearSymbolTableConformanceCache(oCResolveConfiguration);
            OCImportGraph.invalidateRootHeadersCache(oCResolveConfiguration);
        }
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.project);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull ProgressIndicator indicator, @NotNull FileSymbolTablesCache cache2) {
        Ref result2 = new Ref();
        OCSymbolTablesBuildingActivity.runReadActionSafely(indicator, () -> result2.set(cache2.getFilesToBuildTablesFor()));
        return (Collection)result2.get();
    }

    private static void runReadActionSafely(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable2) {
        OCSymbolTablesBuildingActivity.waitForCondition(indicator, o -> ApplicationManagerEx.getApplicationEx().tryRunReadAction(runnable2));
    }

    private static void waitForCondition(@NotNull ProgressIndicator indicator, @NotNull Condition condition2) {
        long sleep = 1L;
        while (true) {
            indicator.checkCanceled();
            if (condition2.value(null)) break;
            try {
                Thread.sleep(sleep);
                sleep *= 2L;
                sleep = Math.min(sleep, 100L);
            }
            catch (InterruptedException ignore) {
                throw new ProcessCanceledException();
            }
        }
    }

    private static void processFutures(@NotNull Iterable<Future> tasks) {
        for (Future future2 : tasks) {
            try {
                future2.get();
            }
            catch (InterruptedException ignore) {
                return;
            }
            catch (ExecutionException e) {
                OCLog.LOG.error(e.getMessage());
            }
        }
    }

    private static <T> Future<?> createTask(@NotNull TaskProvider<T> taskProvider, @NotNull ProgressIndicator indicator) {
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Thread currentThread = Thread.currentThread();
            assert (!mySymbolBuildingThreads.contains(currentThread)) : "Dedicated thread should be used for symbols building";
            mySymbolBuildingThreads.add(currentThread);
            try {
                OCSymbolTablesBuildingActivity.processItemsInReadAction(taskProvider.getItemProvider(), taskProvider.getWorker(), indicator);
            }
            finally {
                mySymbolBuildingThreads.remove(currentThread);
            }
        });
    }

    private static <T> void processItemsInReadAction(@NotNull Producer<T> itemProvider, @NotNull Consumer<T> worker, @NotNull ProgressIndicator globalIndicator) {
        Object localProgress = ourIndicatorFactory != null ? (ProgressIndicator)ourIndicatorFactory.produce() : new SensitiveProgressWrapper(globalIndicator){

            @Override
            protected boolean isReuseable() {
                return true;
            }
        };
        ProgressManager.getInstance().runProcess(() -> OCSymbolTablesBuildingActivity.lambda$processItemsInReadAction$20((ProgressIndicator)localProgress, globalIndicator, itemProvider, worker), localProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$processItemsInReadAction$20(final ProgressIndicator localProgress, @NotNull ProgressIndicator globalIndicator, @NotNull Producer itemProvider, @NotNull Consumer worker) {
        ApplicationAdapter applicationListener = new ApplicationAdapter(){

            public void beforeWriteActionStart(@NotNull Object action) {
                localProgress.cancel();
            }

            public void writeActionFinished(@NotNull Object action) {
                if (localProgress.isRunning()) {
                    localProgress.stop();
                }
                localProgress.start();
            }
        };
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)applicationListener);
        try {
            Ref currentItem = new Ref();
            while (!globalIndicator.isCanceled()) {
                if (currentItem.get() == null) {
                    Object item = itemProvider.produce();
                    if (item == null) {
                        break;
                    }
                    currentItem.set(item);
                }
                OCSymbolTablesBuildingActivity.runReadActionSafely(globalIndicator, () -> {
                    if (globalIndicator.isCanceled()) {
                        return;
                    }
                    Object item = currentItem.get();
                    currentItem.set(null);
                    try {
                        worker.consume(item);
                    }
                    catch (ProcessCanceledException ignore) {
                        currentItem.set(item);
                    }
                    catch (Throwable e) {
                        OCLog.LOG.error(e);
                    }
                });
            }
        }
        finally {
            ApplicationManager.getApplication().removeApplicationListener((ApplicationListener)applicationListener);
        }
    }

    private static /* synthetic */ boolean lambda$buildSymbolsInternal$13(Set loadedFiles, VirtualFile file2) {
        return !loadedFiles.contains(file2);
    }

    static {
        mySymbolBuildingThreads = ContainerUtil.newConcurrentSet();
        ACTIVITY_LOG = NotNullLazyKey.create((String)"SYMBOL ACTIVITY LOG", dom -> new ArrayList());
    }

    public static interface TaskProvider<T> {
        public Producer<T> getItemProvider();

        public Consumer<T> getWorker();
    }

    private static class MyProgressIndicator
    extends DelegatingProgressIndicator {
        private double myFromFraction;
        private double myToFraction = 1.0;
        private String lastActivity;
        private long activityStarted;

        public MyProgressIndicator(@NotNull ProgressIndicator indicator) {
            super(indicator);
        }

        public void startTiming(String activity) {
            this.activityStarted = System.currentTimeMillis();
            this.lastActivity = activity;
        }

        public void setText(String text) {
            super.setText(text);
        }

        public void logTiming() {
            long now = System.currentTimeMillis();
            OCLog.LOG.info(this.lastActivity + " finished in " + (now - this.activityStarted) / 1000L + " s.");
        }

        public void setInterval(double from, double to) {
            this.myFromFraction = from;
            this.myToFraction = to;
        }

        public void setFraction(double fraction) {
            super.setFraction(this.myFromFraction + (this.myToFraction - this.myFromFraction) * fraction);
        }
    }

    private static class OCSymbolTableBuilder {
        private final ProgressIndicator myIndicator;
        private final MultiMap<OCBuildFileCategory, OCBuildFileDescriptor> myClusterization = new MultiMap();

        public OCSymbolTableBuilder(@NotNull Project project2, @NotNull ProgressIndicator progressIndicator, @NotNull Collection<VirtualFile> files) {
            this.myIndicator = progressIndicator;
            Iterator<VirtualFile> iterator = files.iterator();
            Producer provider2 = () -> iterator.hasNext() ? (VirtualFile)iterator.next() : null;
            OCSymbolTablesBuildingActivity.processItemsInReadAction(provider2, virtualFile -> {
                if (!virtualFile.isValid()) {
                    return;
                }
                PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                if (file2 instanceof OCConfigurationOwner) {
                    OCLanguageKind kind2;
                    if (OCInclusionContextUtil.isNeedToFindRoot(file2)) {
                        CLanguageKind kind22 = CLanguageKind.maxLanguage(project2);
                    } else {
                        kind2 = ((OCConfigurationOwner)file2).getKind();
                    }
                    for (OCResolveConfiguration oCResolveConfiguration : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(virtualFile, project2)) {
                        OCBuildFileCategory traits = new OCBuildFileCategory(oCResolveConfiguration.getIndexingCluster(), kind2);
                        OCBuildFileDescriptor fileDescriptor = new OCBuildFileDescriptor(oCResolveConfiguration, (VirtualFile)virtualFile, kind2);
                        this.myClusterization.putValue((Object)traits, (Object)fileDescriptor);
                    }
                }
            }, progressIndicator);
        }

        public void processBuildFiles() {
            final int totalFilesCount = this.myClusterization.values().size();
            Set traits = this.myClusterization.keySet();
            ArrayList<Future> tasks = new ArrayList<Future>(traits.size());
            final AtomicInteger processedFiles = new AtomicInteger(0);
            final ArrayList<BuildFileProvider> clusterProviders = new ArrayList<BuildFileProvider>();
            HashSet notProcessedFiles = new HashSet();
            for (OCBuildFileCategory t : traits) {
                Collection files = Collections.unmodifiableCollection(this.myClusterization.get((Object)t));
                notProcessedFiles.addAll(files);
                Iterator clusterIterator = files.iterator();
                clusterProviders.add(() -> OCSymbolTableBuilder.lambda$processBuildFiles$2(clusterIterator, (Set)notProcessedFiles));
            }
            final BuildFileProvider remainingProvider = () -> OCSymbolTableBuilder.lambda$processBuildFiles$3((Set)notProcessedFiles);
            int numTasks = Math.min(4, Runtime.getRuntime().availableProcessors());
            for (int i2 = 0; i2 < numTasks; ++i2) {
                tasks.add(OCSymbolTablesBuildingActivity.createTask(new TaskProvider<OCBuildFileDescriptor>(){

                    @Override
                    public Producer<OCBuildFileDescriptor> getItemProvider() {
                        return new PrioritizedBuildFileProvider(clusterProviders, remainingProvider);
                    }

                    @Override
                    public Consumer<OCBuildFileDescriptor> getWorker() {
                        return descriptor -> {
                            OCImportGraph.buildSymbolAndRootHeaderCache(((OCBuildFileDescriptor)descriptor).myConfiguration, ((OCBuildFileDescriptor)descriptor).myFile, ((OCBuildFileDescriptor)descriptor).myLanguageKind, myIndicator);
                            myIndicator.setFraction((double)processedFiles.incrementAndGet() / (double)totalFilesCount);
                        };
                    }
                }, this.myIndicator));
            }
            OCSymbolTablesBuildingActivity.processFutures(tasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static /* synthetic */ OCBuildFileDescriptor lambda$processBuildFiles$3(Set notProcessedFiles) {
            Set set2 = notProcessedFiles;
            synchronized (set2) {
                if (!notProcessedFiles.isEmpty()) {
                    OCBuildFileDescriptor next = (OCBuildFileDescriptor)notProcessedFiles.iterator().next();
                    notProcessedFiles.remove(next);
                    return next;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static /* synthetic */ OCBuildFileDescriptor lambda$processBuildFiles$2(Iterator clusterIterator, Set notProcessedFiles) {
            while (clusterIterator.hasNext()) {
                OCBuildFileDescriptor next = (OCBuildFileDescriptor)clusterIterator.next();
                Set set2 = notProcessedFiles;
                synchronized (set2) {
                    if (notProcessedFiles.contains(next)) {
                        notProcessedFiles.remove(next);
                        return next;
                    }
                }
            }
            return null;
        }

        private static class PrioritizedBuildFileProvider
        implements BuildFileProvider {
            private boolean myUseClusters = true;
            private Producer<OCBuildFileDescriptor> myCurrentProvider;
            @NotNull
            private final Collection<BuildFileProvider> myProviders;
            @NotNull
            private final BuildFileProvider myBottomProvider;

            private PrioritizedBuildFileProvider(@NotNull Collection<BuildFileProvider> providers, @NotNull BuildFileProvider bottomProvider) {
                this.myProviders = providers;
                this.myBottomProvider = bottomProvider;
            }

            @Nullable
            public OCBuildFileDescriptor produce() {
                OCBuildFileDescriptor fromCluster = this.nextFromProviders();
                return fromCluster != null ? fromCluster : (OCBuildFileDescriptor)this.myBottomProvider.produce();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private OCBuildFileDescriptor nextFromProviders() {
                if (!this.myUseClusters) {
                    return null;
                }
                while (true) {
                    BuildFileProvider provider2;
                    OCBuildFileDescriptor next;
                    if (this.myCurrentProvider != null && (next = (OCBuildFileDescriptor)this.myCurrentProvider.produce()) != null) {
                        return next;
                    }
                    Collection<BuildFileProvider> collection = this.myProviders;
                    synchronized (collection) {
                        Iterator<BuildFileProvider> iterator = this.myProviders.iterator();
                        if (!iterator.hasNext()) {
                            break;
                        }
                        provider2 = iterator.next();
                        iterator.remove();
                    }
                    this.myCurrentProvider = provider2;
                }
                this.myUseClusters = false;
                return null;
            }
        }

        @FunctionalInterface
        private static interface BuildFileProvider
        extends Producer<OCBuildFileDescriptor> {
        }

        private static final class OCBuildFileDescriptor {
            private final VirtualFile myFile;
            private final OCResolveConfiguration myConfiguration;
            private final OCLanguageKind myLanguageKind;

            private OCBuildFileDescriptor(OCResolveConfiguration configuration, VirtualFile file2, OCLanguageKind kind2) {
                this.myConfiguration = configuration;
                this.myFile = file2;
                this.myLanguageKind = kind2;
            }
        }

        private static final class OCBuildFileCategory {
            private final Object myConfigurationCluster;
            private final OCLanguageKind myKind;

            private OCBuildFileCategory(@Nullable Object configurationCluster, @Nullable OCLanguageKind kind2) {
                this.myConfigurationCluster = configurationCluster;
                this.myKind = kind2;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OCBuildFileCategory category = (OCBuildFileCategory)o;
                if (this.myKind != category.myKind) {
                    return false;
                }
                return !(this.myConfigurationCluster != null ? !this.myConfigurationCluster.equals(category.myConfigurationCluster) : category.myConfigurationCluster != null);
            }

            public int hashCode() {
                int result2 = this.myConfigurationCluster != null ? this.myConfigurationCluster.hashCode() : 0;
                result2 = 31 * result2 + (this.myKind != null ? this.myKind.hashCode() : 0);
                return result2;
            }
        }
    }

    public static enum Mode {
        FAST,
        COMPACT,
        FULL;

    }
}

