/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrCompilerSwitches {
    @NotNull
    private final List<String> myRawArgs;

    public CidrCompilerSwitches(@NotNull List<String> rawArgs) {
        this.myRawArgs = Collections.unmodifiableList(rawArgs);
    }

    @NotNull
    public List<String> getList(@NotNull Format format) {
        return ContainerUtil.map(this.myRawArgs, it -> CidrSwitchBuilder.convert(it, format));
    }

    @NotNull
    public String getCommandLineString(@NotNull Format format) {
        if (format == Format.RAW) {
            throw new IllegalArgumentException("RAW format cannot be correctly used in command line strings.");
        }
        return StringUtil.join(this.getList(format), (String)" ");
    }

    public String toString() {
        return this.getCommandLineString(Format.BASH_SHELL);
    }

    public static enum Format {
        RAW,
        BASH_SHELL,
        WINDOWS_SHELL,
        GNU_MAKEFILES,
        MINGW_MAKEFILES,
        NMAKE_MAKEFILES,
        GCC_RESPONSE_FILE,
        MSVC_RESPONSE_FILE;

    }
}

