/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeNameVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CVQualifiers {
    EMPTY(false, false),
    CONST(true, false),
    VOLATILE(false, true),
    CONST_VOLATILE(true, true);

    private final boolean myConst;
    private final boolean myVolatile;

    private CVQualifiers(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
    }

    @Contract(pure=true)
    @NotNull
    public static CVQualifiers get(boolean isConst, boolean isVolatile) {
        if (isConst) {
            return isVolatile ? CONST_VOLATILE : CONST;
        }
        return isVolatile ? VOLATILE : EMPTY;
    }

    public boolean isConst() {
        return this.myConst;
    }

    public boolean isVolatile() {
        return this.myVolatile;
    }

    @NotNull
    public CVQualifiers or(@NotNull CVQualifiers modifiers) {
        return CVQualifiers.get(this.myConst || modifiers.isConst(), this.myVolatile || modifiers.isVolatile());
    }

    public void appendCVQualifiers(@NotNull StringBuilder buffer) {
        if (this.isConst()) {
            buffer.append(" const");
        }
        if (this.isVolatile()) {
            buffer.append(" volatile");
        }
    }

    public boolean isSuperset(@NotNull CVQualifiers other) {
        return !(!this.isConst() && other.isConst() || !this.isVolatile() && other.isVolatile());
    }

    @NotNull
    public static String appendCVQualifiers(@NotNull String typeString, @NotNull OCType type2, @Nullable Project project2) {
        if (type2.isConst()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type2, project2, "const");
        }
        if (type2.isVolatile()) {
            typeString = OCTypeNameVisitor.addTypeQualifier(typeString, type2, project2, "volatile");
        }
        return typeString;
    }

    public String toString() {
        return (this.isConst() ? "c" : "") + (this.isVolatile() ? "v" : "");
    }
}

