/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArrayType
extends OCPointerType {
    private int myLength;

    public OCArrayType() {
        this(null, 0, false, false, null);
    }

    private OCArrayType(OCType ref, int length, boolean isConst, boolean isVolatile, @Nullable ARCAttribute attribute) {
        super(ref, attribute, null, OCNullability.NONNULL, isConst, isVolatile);
        this.myLength = length;
    }

    public int getLength() {
        return this.myLength;
    }

    public boolean hasLength() {
        return this.myLength != -1;
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return this.hasLength() ? this.myLength * this.myRefType.getSizeInBytes(file2, context) : super.getSizeInBytes(file2, context);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCArrayType f = (OCArrayType)first;
        OCArrayType s = (OCArrayType)second;
        return f.myLength == s.myLength && super.deepEqualStep(c, first, second);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 19 + this.myLength;
    }

    public boolean isEmpty(PsiFile resolveContext, HashSet<OCStructSymbol> processed2) {
        if (this.myLength == 0) {
            return true;
        }
        OCType elementType = this.myRefType.resolve(resolveContext);
        if (elementType instanceof OCArrayType) {
            if (!((OCArrayType)elementType).isEmpty(resolveContext, processed2)) {
                return false;
            }
        } else if (elementType instanceof OCStructType) {
            if (!((OCStructType)elementType).isEmpty(processed2)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static OCArrayType to(OCType type2, int length, @Nullable ARCAttribute arcAttribute) {
        return new OCArrayType(type2, length, false, false, arcAttribute);
    }

    public static OCArrayType to(OCType ref, int length) {
        return OCArrayType.to(ref, length, null);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitArrayType(this);
    }

    @Override
    @NotNull
    public OCType getArrayElementType() {
        return this.myRefType.getArrayElementType();
    }
}

