/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoType
extends OCType {
    @Nullable
    private OCType myIncompleteType;
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    private OCExpressionSymbol myExpressionSymbol;
    private OCExpression myExpressionElement;
    private OCLambdaExpression myLambdaExpression;
    private int myParameterIndex = -1;
    private boolean myNeedsAutoParamsResolving;

    public OCAutoType(@Nullable OCExpressionSymbol expressionSymbol, @Nullable OCExpression expressionElement, @Nullable OCType incompleteType, OCLambdaExpression lambdaExpression, int parameterIndex, boolean needsAutoParamsResolving, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myIncompleteType = incompleteType;
        this.myExpressionSymbol = expressionSymbol;
        this.myExpressionElement = expressionElement;
        this.myLambdaExpression = lambdaExpression;
        this.myParameterIndex = parameterIndex;
        this.myNeedsAutoParamsResolving = needsAutoParamsResolving;
    }

    public OCAutoType(@Nullable OCExpressionSymbol expressionSymbol, @Nullable OCExpression expressionElement, @Nullable OCType incompleteType, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myExpressionSymbol = expressionSymbol;
        this.myExpressionElement = expressionElement;
        this.myIncompleteType = incompleteType;
    }

    public OCAutoType(@NotNull OCAutoType origin, OCTypeSubstitution substitution, @NotNull OCResolveContext context) {
        this.myIncompleteType = origin.getIncompleteType();
        this.myExpressionSymbol = origin.getExpressionSymbol();
        this.myExpressionElement = origin.getExpressionElement();
        this.mySubstitution = OCTypeSubstitution.compose(origin.mySubstitution, substitution, context);
    }

    public OCAutoType(OCLambdaExpression lambdaExpression, int parameterIndex) {
        this.myLambdaExpression = lambdaExpression;
        this.myParameterIndex = parameterIndex;
    }

    public OCAutoType() {
    }

    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCAutoType f = (OCAutoType)first;
        OCAutoType s = (OCAutoType)second;
        if (!c.equalObjects(f.myExpressionSymbol, s.myExpressionSymbol)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (this.myExpressionElement != s.myExpressionElement) {
            return false;
        }
        if (this.myLambdaExpression != s.myLambdaExpression) {
            return false;
        }
        if (this.myParameterIndex != s.myParameterIndex) {
            return false;
        }
        return this.myNeedsAutoParamsResolving == s.myNeedsAutoParamsResolving;
    }

    @Nullable
    public OCType getIncompleteType() {
        return this.myIncompleteType;
    }

    @Nullable
    public OCExpressionSymbol getExpressionSymbol() {
        return this.myExpressionSymbol;
    }

    public void setExpressionSymbol(@NotNull OCExpressionSymbol expressionSymbol) {
        this.myExpressionSymbol = expressionSymbol;
    }

    public OCLambdaExpression getLambdaExpression() {
        return this.myLambdaExpression;
    }

    public int getParameterIndex() {
        return this.myParameterIndex;
    }

    public boolean needsAutoParamsResolving() {
        return this.myNeedsAutoParamsResolving;
    }

    public void setNeedsAutoParamsResolving(boolean needsAutoParamsResolving) {
        this.myNeedsAutoParamsResolving = needsAutoParamsResolving;
    }

    @Nullable
    public OCExpression getExpressionElement() {
        return this.myExpressionElement;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitAutoType(this);
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + (this.myIncompleteType != null ? this.myIncompleteType.hashCode() : 0);
        result2 = 31 * result2 + (this.mySubstitution != null ? this.mySubstitution.hashCode() : 0);
        result2 = 31 * result2 + (this.myExpressionSymbol != null ? this.myExpressionSymbol.hashCode() : 0);
        result2 = 31 * result2 + this.myParameterIndex;
        result2 = 31 * result2 + (this.myNeedsAutoParamsResolving ? 0 : 1);
        return result2;
    }
}

