/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionType
extends OCType {
    private OCType myReturnType;
    private List<OCType> myParameterTypes;
    private List<String> myParameterNames;

    public OCFunctionType() {
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes) {
        this(returnType, parameterTypes, null, false, false, false, false);
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes, @Nullable List<String> parameterNames) {
        this(returnType, parameterTypes, parameterNames, false, false, false, false);
    }

    public OCFunctionType(@NotNull OCType returnType, @NotNull List<OCType> parameterTypes, @Nullable List<String> parameterNames, boolean isConst, boolean isVolatile, boolean isLvalue, boolean isRvalue) {
        super(isConst, isVolatile);
        this.myReturnType = returnType;
        this.myParameterTypes = parameterTypes;
        this.myParameterNames = parameterNames;
        if (isLvalue) {
            this.attachAttribute(32);
        }
        if (isRvalue) {
            this.attachAttribute(64);
        }
        assert (this.myParameterNames == null || this.myParameterNames.size() == this.myParameterTypes.size());
    }

    public static OCType convertArrayParameterType(OCType type2) {
        if (type2 instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type2;
            OCPointerType pointer = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, array.isVolatile());
            pointer.setLengthInBrackets(array.getLength());
            type2 = pointer;
        }
        return type2;
    }

    @NotNull
    public OCType getReturnType() {
        return this.myReturnType;
    }

    @NotNull
    public List<OCType> getParameterTypes(boolean includeVoid) {
        return !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterTypes;
    }

    @NotNull
    public List<OCType> getParameterTypes() {
        return this.getParameterTypes(false);
    }

    @Nullable
    public List<String> getParameterNames(boolean includeVoid) {
        return !includeVoid && this.hasNoParameters() ? Collections.emptyList() : this.myParameterNames;
    }

    @Nullable
    public List<String> getParameterNames() {
        return this.getParameterNames(false);
    }

    public boolean isVararg() {
        if (this.myParameterTypes.size() > 0) {
            OCType lastParamType = this.myParameterTypes.get(this.myParameterTypes.size() - 1).getTerminalType();
            return lastParamType instanceof OCEllipsisType || lastParamType instanceof OCVariadicType;
        }
        return false;
    }

    public boolean isLValueRef() {
        return this.checkAttribute(32);
    }

    public boolean isRValueRef() {
        return this.checkAttribute(64);
    }

    public boolean hasNoParameters() {
        if (this.myParameterTypes.isEmpty()) {
            return true;
        }
        if (this.myParameterTypes.size() == 1) {
            return this.myParameterTypes.get(0) instanceof OCVoidType && (this.myParameterNames == null || "<unnamed>".equals(this.myParameterNames.get(0)));
        }
        return false;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitFunctionType(this);
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + this.myReturnType.hashCode();
        result2 = 31 * result2 + this.myParameterTypes.hashCode();
        return result2;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCFunctionType f = (OCFunctionType)first;
        OCFunctionType s = (OCFunctionType)second;
        if (!Comparing.equal(f.myParameterNames, s.myParameterNames)) {
            return false;
        }
        if (!c.equalIterable(f.myParameterTypes, s.myParameterTypes)) {
            return false;
        }
        return c.equalObjects(f.myReturnType, s.myReturnType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type2, PsiElement context) {
        if (type2 == null) {
            return OCUnknownType.INSTANCE;
        }
        if (type2 instanceof OCMagicType) {
            return type2;
        }
        if (type2.isNumberCompatible(context)) {
            return OCIntType.INT.getLeastCommonType(type2, context);
        }
        if (type2.isPointerCompatible(context)) {
            if (this.equals((Object)type2, context)) {
                return this;
            }
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (this.myReturnType.isUnresolved(context) || this.myReturnType instanceof OCFunctionType || this.myReturnType instanceof OCArrayType) {
            return true;
        }
        for (OCType type2 : this.myParameterTypes) {
            if (!type2.isUnresolved(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormatString() {
        return "%p";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return OCIntType.INT.getSizeInBytes(file2, context);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return this.myReturnType.isMagicInside(context) || this.myParameterTypes.stream().anyMatch(p -> p.isMagicInside(context));
    }
}

