/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNumber;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIntType
extends OCNumericType {
    public static final OCIntType BOOL = new OCIntType(true, OCTypeMapper.CTypeId.SIGNED_CHAR, "signed char", "%d");
    public static final OCIntType BOOLEAN = new OCIntType(false, OCTypeMapper.CTypeId.CHAR, "unsigned char", "%d");
    public static final OCIntType BOOL_NATIVE = new OCIntType(true, OCTypeMapper.CTypeId.BOOL, "bool", "%d");
    public static final OCIntType CHAR = new OCIntType(true, OCTypeMapper.CTypeId.CHAR, "char", "%c");
    public static final OCIntType CHAR_CONST = new OCIntType(true, OCTypeMapper.CTypeId.CHAR, "char", "%c", true, false);
    public static final OCIntType SCHAR = new OCIntType(true, OCTypeMapper.CTypeId.SIGNED_CHAR, "signed char", "%c");
    public static final OCIntType UCHAR = new OCIntType(false, OCTypeMapper.CTypeId.CHAR, "unsigned char", "%c");
    public static final OCIntType WCHAR = new OCIntType(true, OCTypeMapper.CTypeId.WCHAR_T, "wchar_t", "%lc");
    public static final OCIntType WCHAR_CONST = new OCIntType(true, OCTypeMapper.CTypeId.WCHAR_T, "wchar_t", "%lc", true, false);
    public static final OCIntType CHAR16 = new OCIntType(false, OCTypeMapper.CTypeId.CHAR16_T, "char16_t", "%lc");
    public static final OCIntType CHAR16_CONST = new OCIntType(false, OCTypeMapper.CTypeId.CHAR16_T, "char16_t", "%lc", true, false);
    public static final OCIntType CHAR32 = new OCIntType(false, OCTypeMapper.CTypeId.CHAR32_T, "char32_t", "%lc");
    public static final OCIntType CHAR32_CONST = new OCIntType(false, OCTypeMapper.CTypeId.CHAR32_T, "char32_t", "%lc", true, false);
    public static final OCIntType SHORT = new OCIntType(true, OCTypeMapper.CTypeId.SHORT, "short", "%hi");
    public static final OCIntType USHORT = new OCIntType(false, OCTypeMapper.CTypeId.SHORT, "unsigned short", "%hu");
    public static final OCIntType INT = new OCIntType(true, OCTypeMapper.CTypeId.INT, "int", "%i");
    public static final OCIntType UINT = new OCIntType(false, OCTypeMapper.CTypeId.INT, "unsigned int", "%u");
    public static final OCIntType LONG = new OCIntType(true, OCTypeMapper.CTypeId.LONG, "long", "%li");
    public static final OCIntType ULONG = new OCIntType(false, OCTypeMapper.CTypeId.LONG, "unsigned long", "%lu");
    public static final OCIntType LONGLONG = new OCIntType(true, OCTypeMapper.CTypeId.LONG_LONG, "long long int", "%lli");
    public static final OCIntType ULONGLONG = new OCIntType(false, OCTypeMapper.CTypeId.LONG_LONG, "unsigned long long int", "%llu");
    public static final OCIntType INT128 = new OCIntType(true, OCTypeMapper.CTypeId.INT128_T, "__int128_t", "%ji");
    public static final OCIntType UINT128 = new OCIntType(false, OCTypeMapper.CTypeId.INT128_T, "__uint128_t", "%ju");
    public static final OCIntType SSIZE_T = new OCIntType(true, OCTypeMapper.CTypeId.SIZE_T, "ssize_t", "%zi");
    public static final OCIntType SIZE_T = new OCIntType(false, OCTypeMapper.CTypeId.SIZE_T, "size_t", "%zu");
    public static final OCIntType PTRDIFF_T = new OCIntType(true, OCTypeMapper.CTypeId.PTRDIFF_T, "ptrdiff_t", "%ti");
    private boolean myIsSigned;
    private String myText;
    private String myFormatString;

    public static boolean isBool(OCType type2, @Nullable PsiElement context) {
        return BOOL.equalsWithAliasName(type2, context) || BOOLEAN.equalsWithAliasName(type2, context) || BOOL_NATIVE.equalsWithAliasName(type2, context);
    }

    public static OCIntType getAppropriateBool(@Nullable OCElement context) {
        if (context != null && !context.getContainingOCFile().getKind().isObjC()) {
            return BOOL_NATIVE;
        }
        return BOOL;
    }

    @Override
    public int getRank(@NotNull PsiElement element) {
        int byteCount;
        return (byteCount << 3) + ((byteCount = this.getSizeInBytes(element.getContainingFile(), null)) > 1 && this.isSigned() ? 0 : 1);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIntType f = (OCIntType)first;
        OCIntType s = (OCIntType)second;
        if (f.myIsSigned != s.myIsSigned) {
            return false;
        }
        if (!Comparing.equal((String)f.myFormatString, (String)s.myFormatString)) {
            return false;
        }
        if (!Comparing.equal((String)f.myText, (String)s.myText)) {
            return false;
        }
        return f.myTypeId.equals((Object)s.myTypeId);
    }

    public OCIntType() {
    }

    private OCIntType(boolean isSigned, OCTypeMapper.CTypeId w, String text, String formatString) {
        this(isSigned, w, text, formatString, false, false);
    }

    private OCIntType(boolean isSigned, OCTypeMapper.CTypeId w, String text, String formatString, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myIsSigned = isSigned;
        this.myTypeId = w;
        this.myText = text;
        this.myFormatString = formatString;
    }

    public OCIntType cloneType(boolean isConst, boolean isVolatile) {
        return new OCIntType(this.isSigned(), this.getCTypeId(), this.getText(), this.getFormatString(), isConst, isVolatile);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitIntType(this);
    }

    @Override
    public boolean isSigned() {
        return this.myIsSigned;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isChar() {
        return OCTypeMapper.CTypeId.CHAR.equals((Object)this.myTypeId);
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public boolean isIntegerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    @NotNull
    public String getFormatString() {
        return this.myFormatString;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.myIsSigned ? 1 : 0);
    }

    @NotNull
    public static OCIntType literalType(@NotNull String text, @NotNull PsiElement element) {
        if ("TRUE".equals(text = text.toUpperCase(Locale.ROOT)) || "FALSE".equals(text)) {
            return BOOL;
        }
        return (OCIntType)OCElementUtil.parseInteger((String)text, (PsiElement)element, null).first;
    }

    public boolean canRepresent(@NotNull OCNumber value2, @NotNull PsiElement element) {
        if (value2.isSigned() && value2.signum() == -1 && !this.myIsSigned) {
            return false;
        }
        int valueBitLength = value2.bitLength();
        int typeBitLength = this.getBits(element, null) - (this.myIsSigned ? 1 : 0);
        return valueBitLength <= typeBitLength;
    }

    @Override
    @NotNull
    public String getDefaultValue(@Nullable PsiElement context) {
        return this.getValue(false, context);
    }

    public String getValue(boolean value2, @Nullable PsiElement context) {
        if (Comparing.equal((String)this.myAliasName, (String)"BOOL")) {
            return value2 ? "YES" : "NO";
        }
        if (Comparing.equal((String)this.myAliasName, (String)"Boolean") || !OCCodeInsightUtil.isInPlainOldC(context) && Comparing.equal((String)this.myAliasName, (String)"bool")) {
            return value2 ? "true" : "false";
        }
        return value2 ? "1" : "0";
    }

    @NotNull
    public OCIntType promoteToSigned() {
        if (this.myIsSigned) {
            return this;
        }
        if (this.myTypeId.ordinal() <= OCTypeMapper.CTypeId.INT.ordinal()) {
            return INT;
        }
        if (this.equals((Object)ULONG, new OCResolveContext())) {
            return LONG;
        }
        return LONGLONG;
    }

    static {
        BOOL.attachAliasName("BOOL");
        BOOLEAN.attachAliasName("Boolean");
        BOOL_NATIVE.attachAliasName("bool");
        SIZE_T.attachAliasName("std::size_t");
        PTRDIFF_T.attachAliasName("std::ptrdiff_t");
        INT128.attachAliasName("__int128");
    }
}

