/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNumericType
extends OCType {
    protected OCTypeMapper.CTypeId myTypeId;

    public abstract int getRank(@NotNull PsiElement var1);

    public abstract boolean isSigned();

    public abstract boolean isComplex();

    public int getBits(@Nullable PsiElement element, @Nullable OCInclusionContext context) {
        return this.getSizeInBytes(element == null ? null : element.getContainingFile(), context) * 8;
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return this.myTypeId.getBytes(file2, context);
    }

    @NotNull
    public OCTypeMapper.CTypeId getCTypeId() {
        return this.myTypeId;
    }

    public OCNumericType() {
    }

    public OCNumericType(boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type2, @NotNull PsiElement context) {
        if (type2 == null) {
            return OCUnknownType.INSTANCE;
        }
        if (type2 instanceof OCNumericType) {
            OCType result2;
            OCType oCType = result2 = this.getRank(context) < ((OCNumericType)type2).getRank(context) ? type2 : this;
            if (this.isComplex() || ((OCNumericType)type2).isComplex()) {
                return ((OCRealType)result2).cloneWithComplexModifier();
            }
            return result2;
        }
        if (type2.isPointerCompatible(context)) {
            return type2;
        }
        if (type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.ENUM) {
            return this;
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public String getAliasName() {
        return this.myAliasName != null && this.myAliasName.contains("<") ? null : this.myAliasName;
    }

    @Override
    public boolean isNumberCompatible(PsiElement context) {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myTypeId.hashCode();
    }
}

