/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCObjectType
extends OCType {
    @Nullable
    private OCInterfaceSymbol myInterface;
    @Nullable
    private OCImplementationSymbol myImplementation;
    private List<OCProtocolSymbol> myAugmentedProtocols;
    private List<OCProtocolSymbol> myAllProtocols;
    private List<OCInterfaceSymbol> myCategoryInterfaces;
    private List<OCImplementationSymbol> myCategoryImplementations;
    @Nullable
    private OCObjectType mySuperType;
    private boolean myIsKindof = false;

    public OCObjectType() {
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, @Nullable OCImplementationSymbol implementation, List<OCProtocolSymbol> allProtocols, List<OCProtocolSymbol> augmentedProtocols, List<OCInterfaceSymbol> categoryInterfaces, List<OCImplementationSymbol> categoryImplementations, @Nullable OCObjectType superType, boolean isConst, boolean isVolatile, boolean isKindof) {
        super(isConst, isVolatile);
        this.myInterface = anInterface;
        this.myImplementation = implementation;
        this.myAllProtocols = allProtocols;
        this.myAugmentedProtocols = augmentedProtocols;
        this.myCategoryInterfaces = categoryInterfaces;
        this.myCategoryImplementations = categoryImplementations;
        this.mySuperType = superType;
        this.myIsKindof = isKindof;
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, List<OCProtocolSymbol> allProtocols, List<OCProtocolSymbol> augmentedProtocols, boolean isConst, boolean isVolatile) {
        this(anInterface, null, allProtocols, augmentedProtocols, Collections.emptyList(), Collections.emptyList(), null, isConst, isVolatile, false);
    }

    public OCObjectType(@Nullable OCInterfaceSymbol anInterface, @Nullable OCObjectType superType) {
        this(anInterface, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), superType, false, false, false);
    }

    @Nullable
    public OCClassSymbol getClassSymbol() {
        return this.myInterface != null ? this.myInterface : this.myImplementation;
    }

    @Nullable
    public OCInterfaceSymbol getInterface() {
        return this.myInterface;
    }

    @Nullable
    public OCImplementationSymbol getImplementation() {
        return this.myImplementation;
    }

    public List<OCInterfaceSymbol> getCategoryInterfaces() {
        return this.myCategoryInterfaces;
    }

    public List<OCImplementationSymbol> getCategoryImplementations() {
        return this.myCategoryImplementations;
    }

    @NotNull
    public List<OCProtocolSymbol> getAllProtocols() {
        return this.myAllProtocols;
    }

    public List<OCProtocolSymbol> getAugmentedProtocols() {
        return this.myAugmentedProtocols;
    }

    @Nullable
    public OCObjectType getSuperType() {
        return this.mySuperType;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitObjectType(this);
    }

    @Nullable
    public <T extends OCMemberSymbol> T findMember(String name, Class<T> memberClass) {
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.processMembers(name, memberClass, (Processor<? super T>)processor2);
        return (T)((OCMemberSymbol)processor2.getFoundValue());
    }

    public <T extends OCMemberSymbol> boolean processMembers(Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String symbolName, Class<T> memberClass, Processor<? super T> processor2) {
        return this.processMembers(this.myInterface, symbolName, memberClass, processor2, true, true);
    }

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String name, Class<T> memberClass, Processor<? super T> processor2, boolean processIntf, boolean processImpl) {
        return this.processMembers(this.myInterface, name, memberClass, processor2, processIntf, processImpl);
    }

    public <T extends OCMemberSymbol> boolean processMembers(OCClassSymbol intfSymbol, @Nullable String symbolName, Class<T> memberClass, Processor<? super T> processor2, boolean processIntf, boolean processImpl) {
        if (processIntf && intfSymbol != null && !OCObjectType.doProcessMembers(symbolName, memberClass, Collections.singletonList(intfSymbol), processor2)) {
            return false;
        }
        if (processImpl && this.myImplementation != null && !OCObjectType.doProcessMembers(symbolName, memberClass, Collections.singletonList(this.myImplementation), processor2)) {
            return false;
        }
        if (processIntf) {
            if (intfSymbol == this.myInterface && !OCObjectType.doProcessMembers(symbolName, memberClass, this.myCategoryInterfaces, processor2)) {
                return false;
            }
            if (this.mySuperType != null && !this.mySuperType.processMembers(symbolName, memberClass, processor2, true, false)) {
                return false;
            }
            if (!OCObjectType.doProcessMembers(symbolName, memberClass, this.myAllProtocols, processor2)) {
                return false;
            }
        }
        if (processImpl) {
            if (intfSymbol == this.myInterface && !OCObjectType.doProcessMembers(symbolName, memberClass, this.myCategoryImplementations, processor2)) {
                return false;
            }
            if (this.mySuperType != null && !this.mySuperType.processMembers(symbolName, memberClass, processor2, false, true)) {
                return false;
            }
        }
        return true;
    }

    private static <T extends OCMemberSymbol> boolean doProcessMembers(@Nullable String symbolName, Class<T> memberClass, List<? extends OCClassSymbol> classes2, Processor<? super T> processor2) {
        for (OCClassSymbol oCClassSymbol : classes2) {
            if (oCClassSymbol.processMembers(symbolName, memberClass, processor2)) continue;
            return false;
        }
        return true;
    }

    public boolean processInterfaceMethods(OCClassSymbol intfSymbol, @Nullable String method2, Processor<OCMethodSymbol> processor2, PsiElement context, boolean processBaseProtocols) {
        HashSet<String> baseProtocols = new HashSet<String>();
        LinkedHashSet<OCProtocolSymbol> baseProtocolSymbols = new LinkedHashSet<OCProtocolSymbol>();
        if (intfSymbol == null) {
            return true;
        }
        for (OCObjectType type2 = this.mySuperType; type2 != null; type2 = type2.getSuperType()) {
            for (OCProtocolSymbol protocol : type2.getAllProtocols()) {
                baseProtocols.add(protocol.getName());
                baseProtocolSymbols.add(protocol);
            }
        }
        if (!intfSymbol.processAllMethods(method2, processor2, baseProtocols, context)) {
            return false;
        }
        if (intfSymbol.getCategoryName() != null) {
            return true;
        }
        for (OCInterfaceSymbol category : this.myCategoryInterfaces) {
            if (!"".equals(category.getCategoryName()) || category.processAllMethods(method2, processor2, baseProtocols, context)) continue;
            return false;
        }
        if (processBaseProtocols) {
            for (OCProtocolSymbol protocol : baseProtocolSymbols) {
                if (protocol.processAllMethods(method2, processor2, baseProtocols, context)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getClassName() {
        return OCSymbolImpl.getSymbolName(this.getClassSymbol());
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + (this.myInterface == null ? 0 : this.myInterface.hashCode());
        result2 = 31 * result2 + (this.myImplementation == null ? 0 : this.myImplementation.hashCode());
        result2 = 31 * result2 + this.myAllProtocols.hashCode();
        result2 = 31 * result2 + Boolean.valueOf(this.myIsKindof).hashCode();
        return result2;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCObjectType f = (OCObjectType)first;
        OCObjectType s = (OCObjectType)second;
        if (f.isKindof() != s.isKindof()) {
            return false;
        }
        if (!c.equalIterable(f.myAllProtocols, s.myAllProtocols)) {
            return false;
        }
        if (!c.equalIterable(f.myAugmentedProtocols, s.myAugmentedProtocols)) {
            return false;
        }
        if (!c.equalIterable(f.myCategoryImplementations, s.myCategoryImplementations)) {
            return false;
        }
        if (!c.equalIterable(f.myCategoryInterfaces, s.myCategoryInterfaces)) {
            return false;
        }
        if (!c.equalObjects(f.myImplementation, s.myImplementation)) {
            return false;
        }
        if (!c.equalObjects(f.myInterface, s.myInterface)) {
            return false;
        }
        return c.equalObjects(f.mySuperType, s.mySuperType);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type2, PsiElement context) {
        if (type2 == null) {
            return OCUnknownType.INSTANCE;
        }
        if (type2 instanceof OCObjectType) {
            if (this instanceof OCIdType && this.getAllProtocols().isEmpty()) {
                return type2;
            }
            if (type2 instanceof OCIdType && ((OCIdType)type2).getAllProtocols().isEmpty()) {
                return this;
            }
            if (this.checkCompatible(type2, context).getState() == OCType.TypeCheckState.OK) {
                return this;
            }
            if (type2.checkCompatible(this, context).getState() == OCType.TypeCheckState.OK) {
                return type2;
            }
            if (this.mySuperType != null) {
                OCType result2 = this.mySuperType.getLeastCommonType(type2, context);
                if (result2 instanceof OCObjectType) {
                    for (OCProtocolSymbol protocol : this.myAllProtocols) {
                        if (!((OCObjectType)type2).implementsProtocol(protocol)) continue;
                        result2 = ((OCObjectType)result2).augmentWithProtocol(protocol);
                    }
                }
                return result2;
            }
            OCClassSymbol classSymbol = ((OCObjectType)type2).getClassSymbol();
            Project project2 = classSymbol != null ? classSymbol.getProject() : null;
            return project2 != null ? OCIdType.pointerToID(project2).getRefType() : OCUnknownType.INSTANCE;
        }
        if (type2.isPointerCompatible(context)) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    public boolean isAncestorOf(@Nullable OCObjectType type2) {
        if (this instanceof OCIdType) {
            return true;
        }
        OCClassSymbol classSymbol = this.getClassSymbol();
        if (classSymbol == null) {
            return false;
        }
        while (!(type2 == null || type2.getClassSymbol() != null && classSymbol.isSameClass(type2.getClassSymbol()))) {
            type2 = type2.mySuperType;
        }
        return type2 != null;
    }

    public boolean implementsProtocol(@Nullable OCProtocolSymbol protocol) {
        return this.myAllProtocols.contains(protocol) || this.mySuperType != null && this.mySuperType.implementsProtocol(protocol);
    }

    public OCObjectType augmentWithProtocol(@NotNull OCProtocolSymbol protocolSymbol) {
        if (this.implementsProtocol(protocolSymbol)) {
            return this;
        }
        OCObjectType copy = (OCObjectType)this.getShallowCopy();
        copy.myAugmentedProtocols = OCObjectType.cloneWithAddedProtocol(copy.myAugmentedProtocols, protocolSymbol);
        copy.myAllProtocols = OCObjectType.cloneWithAddedProtocol(copy.myAllProtocols, protocolSymbol);
        return copy;
    }

    @NotNull
    private static List<OCProtocolSymbol> cloneWithAddedProtocol(@NotNull List<OCProtocolSymbol> protocols, @NotNull OCProtocolSymbol protocolSymbol) {
        ArrayList<OCProtocolSymbol> newProtocols = new ArrayList<OCProtocolSymbol>(protocols.size() + 1);
        newProtocols.addAll(protocols);
        newProtocols.add(protocolSymbol);
        return newProtocols;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    @Override
    public String getFormatString() {
        return "%@";
    }
}

