/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPointerType
extends OCType {
    protected OCType myRefType;
    private ARCAttribute myARCAttribute;
    private OCType myClassQualifier;
    private Integer lengthInBrackets = null;
    public static OCPointerType NULLPTR_T = OCPointerType.to(OCVoidType.instance());

    public OCPointerType() {
    }

    protected OCPointerType(OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile, nullability);
        this.myRefType = ref;
        this.myARCAttribute = attribute;
        this.myClassQualifier = classQualifier;
    }

    public static OCPointerType to(@NotNull OCType ref) {
        return new OCPointerType(ref, null, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute) {
        return new OCPointerType(ref, attribute, null, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier) {
        return new OCPointerType(ref, attribute, classQualifier, null, false, false);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, boolean isConst, boolean isVolatile) {
        return new OCPointerType(ref, attribute, classQualifier, null, isConst, isVolatile);
    }

    public static OCPointerType to(@NotNull OCType ref, @Nullable ARCAttribute attribute, @Nullable OCType classQualifier, @Nullable OCNullability nullability, boolean isConst, boolean isVolatile) {
        return new OCPointerType(ref, attribute, classQualifier, nullability, isConst, isVolatile);
    }

    public static OCType to(@NotNull OCType ref, int nTimes) {
        for (int i2 = 0; i2 < nTimes; ++i2) {
            ref = OCPointerType.to(ref);
        }
        return ref;
    }

    public boolean isPointerToConst() {
        return this.myRefType.isConst();
    }

    public boolean isPointerToVolatile() {
        return this.myRefType.isVolatile();
    }

    @NotNull
    public OCType getRefType() {
        return this.myRefType;
    }

    @Override
    @NotNull
    public OCType getTerminalType() {
        return this.myRefType.getTerminalType();
    }

    @Override
    public int pointersDepth() {
        return this.myRefType.pointersDepth() + 1;
    }

    public OCType getClassQualifier() {
        return this.myClassQualifier;
    }

    @Override
    public int hashCode() {
        return (this.baseHashCode() * 31 + this.myRefType.hashCode()) * 31 + (this.myClassQualifier != null ? this.myClassQualifier.hashCode() : 0);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPointerType f = (OCPointerType)first;
        OCPointerType s = (OCPointerType)second;
        if (f.myARCAttribute != s.myARCAttribute) {
            return false;
        }
        if (!c.equalObjects(f.myRefType, s.myRefType)) {
            return false;
        }
        return c.equalObjects(f.myClassQualifier, s.myClassQualifier);
    }

    @Override
    public boolean isPointerCompatible(PsiElement context, boolean checkCppConvertible) {
        return true;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    public ARCAttribute getARCAttribute() {
        return this.myARCAttribute;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitPointerType(this);
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type2, PsiElement context) {
        if (this.equals((Object)type2, context)) {
            return this;
        }
        if (type2 instanceof OCMagicType) {
            return type2;
        }
        if (this.isPointerToObject() && type2.isPointerToObject() || type2 instanceof OCPointerType && this.myRefType.equals(((OCPointerType)type2).getRefType(), false, new OCResolveContext(context))) {
            return OCPointerType.to(this.myRefType.getLeastCommonType(((OCPointerType)type2).getRefType(), context));
        }
        if (type2.isNumberCompatible(context)) {
            return this;
        }
        if (type2.isPointerCompatible(context)) {
            return OCPointerType.to(OCVoidType.instance());
        }
        return OCUnknownType.INSTANCE;
    }

    public OCType.TypeCheckResult validateConstPointers(OCType type2, PsiElement context) {
        OCType lType = this;
        OCType rType = type2;
        boolean arrayToPointerCastsAvailable = true;
        boolean hasConstMismatch = false;
        boolean hasVolatileMismatch = false;
        boolean hasLengthMismatch = false;
        boolean incompatibleType = false;
        boolean unassignableArray = false;
        boolean isEquals = true;
        int pointersCnt = 0;
        while (lType instanceof OCPointerType && rType instanceof OCPointerType) {
            ++pointersCnt;
            OCPointerType lPtrType = lType;
            OCPointerType rPtrType = (OCPointerType)rType;
            if (!lPtrType.isPointerToConst() && rPtrType.isPointerToConst()) {
                hasConstMismatch = true;
            }
            if (!lPtrType.isPointerToVolatile() && rPtrType.isPointerToVolatile()) {
                hasVolatileMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToConst() && !rPtrType.isPointerToConst()) {
                hasConstMismatch = true;
            }
            if (pointersCnt > 1 && lPtrType.isPointerToVolatile() && !rPtrType.isPointerToVolatile()) {
                hasVolatileMismatch = true;
            }
            if (lPtrType instanceof OCBlockPointerType != rPtrType instanceof OCBlockPointerType) {
                isEquals = false;
            }
            if (lPtrType instanceof OCArrayType) {
                OCArrayType lArrayType = (OCArrayType)lPtrType;
                if (pointersCnt > 1 && rPtrType instanceof OCArrayType) {
                    OCArrayType rArrayType = (OCArrayType)rPtrType;
                    if (lArrayType.getLength() != rArrayType.getLength()) {
                        hasLengthMismatch = true;
                    }
                } else if (lArrayType.hasLength()) {
                    unassignableArray = true;
                }
            } else if (rPtrType instanceof OCArrayType) {
                if (pointersCnt > 1 || !arrayToPointerCastsAvailable) {
                    incompatibleType = true;
                }
                arrayToPointerCastsAvailable = false;
            }
            lType = lPtrType.myRefType;
            rType = rPtrType.myRefType;
            if (lType instanceof OCCppReferenceType) {
                lType = ((OCCppReferenceType)lType).getRefType();
            }
            if (!(rType instanceof OCCppReferenceType)) continue;
            rType = ((OCCppReferenceType)rType).getRefType();
        }
        isEquals = lType instanceof OCIntType && rType instanceof OCIntType ? (isEquals &= lType.equals(rType, false, new OCResolveContext(context))) : (isEquals &= context != null && lType.equals(rType, false, new OCResolveContext(context)));
        boolean isLTypeVoidPtr = lType.isVoid() && pointersCnt == 1;
        OCType.TypeCheckResult generalErrorResult = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "", null, null, new IntentionAction[0]);
        if (!(isEquals || isLTypeVoidPtr || lType instanceof OCMagicType || rType instanceof OCMagicType)) {
            return generalErrorResult;
        }
        if ((hasConstMismatch || hasVolatileMismatch) && !lType.isUnknown() && !rType.isUnknown()) {
            final String message2 = "Assigning '" + type2.getName(context) + "' to '" + this.getName(context) + "' discards " + (hasConstMismatch ? "const" : "volatile") + " qualifier";
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_discards_qualifiers", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return message2;
                }
            };
        }
        if (hasLengthMismatch || incompatibleType || unassignableArray) {
            return generalErrorResult;
        }
        return OCTypeCompatibilityVisitor.OK_RESULT;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isCppStructType() {
        return false;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        return this.myRefType.isUnresolved(context) || this.myClassQualifier != null && !(this.myClassQualifier instanceof OCStructType);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return this.myRefType.isMagicInside(context);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        return this.myRefType.isSubclassOfMagic(context);
    }

    @Override
    @NotNull
    public OCType getGuessedUnmagicType() {
        return OCPointerType.to(this.myRefType.getGuessedUnmagicType());
    }

    @Override
    public boolean isPointerToObject() {
        return this.myRefType instanceof OCObjectType;
    }

    @Override
    public boolean isPointerToCppStructType() {
        return this.myRefType.isCppStructType();
    }

    @Override
    public boolean isPointerToID(boolean withProtocols) {
        return this.myRefType instanceof OCIdType && (!withProtocols || !((OCIdType)this.myRefType).getAugmentedProtocols().isEmpty());
    }

    @Override
    public boolean isPointerToChar() {
        OCResolveContext context = new OCResolveContext();
        return this.myRefType.equals(OCIntType.CHAR, false, context) || this.myRefType.equals(OCIntType.UCHAR, false, context) || this.myRefType.equals(OCIntType.SCHAR, false, context) || this.myRefType.equals(OCIntType.WCHAR, false, context) || this.myRefType.equals(OCIntType.CHAR16, false, context) || this.myRefType.equals(OCIntType.CHAR32, false, context);
    }

    @Override
    public boolean isCString() {
        OCResolveContext context = new OCResolveContext();
        return this.myRefType.equals(OCIntType.CHAR, false, context) || this.myRefType.equals(OCIntType.UCHAR, false, context) || this.myRefType.equals(OCIntType.SCHAR, false, context) || this.myRefType.equals(OCIntType.WCHAR, false, context) || this.myRefType.equals(OCIntType.CHAR16, false, context) || this.myRefType.equals(OCIntType.CHAR32, false, context);
    }

    @Override
    public boolean isPointerToVoid() {
        return this.myRefType.isVoid();
    }

    @Override
    public String getFormatString() {
        if (this.isClassType()) {
            return "%@";
        }
        if (this.myRefType.isChar()) {
            return "%s";
        }
        if (OCIntType.WCHAR.equals(this.myRefType, false, new OCResolveContext())) {
            return "%ls";
        }
        if (this.isPointerToObject()) {
            return this.getRefType().getFormatString();
        }
        return "%p";
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        return OCTypeMapper.CTypeId.POINTER.getBytes(file2, context);
    }

    public Integer getLengthInBrackets() {
        return this.lengthInBrackets;
    }

    public void setLengthInBrackets(Integer lengthInBrackets) {
        this.lengthInBrackets = lengthInBrackets;
    }
}

