/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCLocalTypes;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceTypeBuilder {
    private boolean myConst = false;
    private boolean myVolatile = false;
    @Nullable
    private OCNullability myNullability;
    @NotNull
    private final OCSymbolReference myReference;
    @NotNull
    private List<String> myProtocolNames = Collections.emptyList();
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;
    @Nullable
    private ARCAttribute myARCAttribute = null;
    private boolean myFunctionParameterType = false;
    private boolean myIsKindof = false;

    public OCReferenceTypeBuilder(String name) {
        this(OCQualifiedName.interned(name));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name) {
        this(name, null, false, false);
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, boolean isInsideTemplateParams) {
        this(OCReferenceTypeBuilder.makeGlobalReference(name, globalContext, isBaseClause, isInsideTemplateParams));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext) {
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name, localContext, globalContext));
    }

    public OCReferenceTypeBuilder(@NotNull OCQualifiedName name, @Nullable PsiElement localContext) {
        this(OCReferenceTypeBuilder.tryMakeLocalReference(name, localContext, null));
    }

    public OCReferenceTypeBuilder(@NotNull OCSymbolReference reference) {
        this.myReference = reference;
    }

    @NotNull
    private static OCSymbolReference makeGlobalReference(@NotNull OCQualifiedName name, @Nullable OCSymbolWithQualifiedName globalContext, boolean isBaseClause, boolean isInsideTemplateParams) {
        if (isBaseClause) {
            return OCSymbolReference.getBaseClauseReference(name, globalContext);
        }
        if (isInsideTemplateParams) {
            return OCSymbolReference.getTemplateParamsReference(name, globalContext);
        }
        return OCSymbolReference.getGlobalReference(name, globalContext);
    }

    @NotNull
    private static OCSymbolReference tryMakeLocalReference(@NotNull OCQualifiedName name, @Nullable PsiElement localContext, @Nullable OCSymbolWithQualifiedName globalContext) {
        OCFile file2;
        Boolean local = false;
        if (localContext != null && ((local = OCLocalTypes.canBeLocalType(file2 = (OCFile)localContext.getContainingFile(), name)) == null || !local.booleanValue() && OCLocalTypes.hasLocalUsingStatement(file2))) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getTopmostParentOfType((PsiElement)localContext, OCCallable.class);
            local = callable != null && (local == null || PsiTreeUtil.findChildOfType((PsiElement)callable, OCCppUsingStatement.class) != null);
        }
        if (local.booleanValue()) {
            return OCSymbolReference.getLocalReference(name, localContext);
        }
        if (globalContext == null) {
            globalContext = OCSymbolReferenceResolver.getGlobalContextFromLocal(localContext);
        }
        return OCSymbolReference.getGlobalReference(name, globalContext);
    }

    @NotNull
    public OCReferenceTypeBuilder setSingleProtocolName(@NotNull String protocolName) {
        return this.setProtocolNames(Collections.singletonList(protocolName));
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolNames(@NotNull List<String> protocolNames) {
        this.myProtocolNames = protocolNames;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setSubstitution(@NotNull OCTypeSubstitution substitution) {
        this.mySubstitution = substitution;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setARCAttribute(@Nullable ARCAttribute arcAttribute) {
        this.myARCAttribute = arcAttribute;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setProtocolSubstitutionARCFromType(@NotNull OCReferenceType fromType) {
        this.setProtocolNames(fromType.getProtocolNames());
        this.setSubstitution(fromType.getSubstitution());
        this.setARCAttribute(fromType.getARCAttribute());
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(boolean isConst, boolean isVolatile) {
        this.myConst = isConst;
        this.myVolatile = isVolatile;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setConstVolatile(@NotNull OCType fromType) {
        return this.setConstVolatile(fromType.isConst(), fromType.isVolatile());
    }

    @NotNull
    public OCReferenceTypeBuilder setNullability(@Nullable OCNullability nullability) {
        this.myNullability = nullability;
        return this;
    }

    @NotNull
    public OCReferenceTypeBuilder setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
        return this;
    }

    public void setIsKindof(boolean isKindof) {
        this.myIsKindof = isKindof;
    }

    @NotNull
    public OCReferenceType build() {
        return new OCReferenceType(this.myConst, this.myVolatile, this.myReference, this.myProtocolNames, this.mySubstitution, this.myARCAttribute, this.myNullability, this.myFunctionParameterType, this.myIsKindof);
    }
}

