/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructType
extends OCType {
    @NotNull
    private List<OCStructSymbol> myStructs;
    @Nullable
    private String myTypedefName;
    @Nullable
    private List<OCTypeArgument> myArguments;

    public OCStructType() {
    }

    public OCStructType(@NotNull OCStructSymbol structs) {
        this(structs, null);
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs) {
        this.myStructs = structs;
        this.myTypedefName = null;
    }

    public OCStructType(@NotNull OCStructSymbol structs, @Nullable String typedefName) {
        this.myStructs = Collections.singletonList(structs);
        this.myTypedefName = typedefName;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, @Nullable List<OCTypeArgument> arguments) {
        this(structs, typedefName, false, false);
        this.myArguments = arguments;
    }

    public OCStructType(@NotNull List<OCStructSymbol> structs, @Nullable String typedefName, boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
        this.myStructs = structs;
        this.myTypedefName = typedefName;
    }

    @NotNull
    public Collection<OCSymbol> collectMethods(@NotNull String methodName, OCResolveContext context) {
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processMembers(methodName, (Processor<OCSymbol>)collector, context);
        return collector.getResults();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructType f = (OCStructType)first;
        OCStructType s = (OCStructType)second;
        if (!Comparing.equal((String)f.myTypedefName, (String)s.myTypedefName)) {
            return false;
        }
        return c.equalIterable(f.myStructs, s.myStructs);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myStructs.get(0).hashCode();
    }

    public List<OCStructSymbol> getStructs() {
        return this.myStructs;
    }

    @Nullable
    public String getTypedefName() {
        return this.myTypedefName;
    }

    @NotNull
    public OCStructSymbol getSymbol() {
        return this.myStructs.get(0);
    }

    @Nullable
    public List<OCTypeArgument> getResolvedArguments(@NotNull OCResolveContext context) {
        if (this.myArguments == null) {
            return null;
        }
        ArrayList<OCTypeArgument> result2 = new ArrayList<OCTypeArgument>();
        for (OCTypeArgument myArgument : this.myArguments) {
            result2.add(OCSimpleTypeSubstitution.resolveTypeArgument(myArgument, context));
        }
        return result2;
    }

    @NotNull
    public OCSymbolKind getKind() {
        return this.myStructs.get(0).getKind();
    }

    public boolean isEnumClass() {
        return this.myStructs.get(0).isEnumClass();
    }

    public boolean isEnum() {
        return this.myStructs.get(0).isEnum();
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitStructType(this);
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        for (OCStructSymbol struct : this.myStructs) {
            OCDeclaratorSymbol field = struct.findField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getFields() {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myStructs.get(0).processFields((Processor<OCDeclaratorSymbol>)collector);
        List results = (List)collector.getResults();
        Collections.sort(results, (o1, o2) -> OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset()));
        return results;
    }

    public OCSymbol findConstructor(@NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, boolean allowImplicitConversions, boolean acceptOnlyCompatible, final @Nullable Producer<Boolean> isExplicitCall) {
        List symbols = this.collectMethods(this.getSymbol().getName(), context);
        this.getSymbol().processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol -> {
            if (symbol instanceof OCUsingSymbol) {
                ((OCUsingSymbol)symbol).getSymbolReference().processPossibleSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                    if (symbol1 instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol1).isCppConstructor()) {
                        symbols.add(symbol1);
                    }
                    return true;
                }), context);
            }
            return true;
        }));
        List filtered = isExplicitCall != null ? ContainerUtil.filter(symbols, (Condition)new Condition<OCSymbol>(){
            Boolean myExplicitConstructorCall;

            public boolean value(OCSymbol symbol) {
                if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isExplicit()) {
                    return true;
                }
                if (this.myExplicitConstructorCall == null) {
                    this.myExplicitConstructorCall = (Boolean)isExplicitCall.produce();
                }
                return this.myExplicitConstructorCall;
            }
        }) : symbols;
        return OCResolveOverloadsUtil.resolveConstructorOverloads(this, filtered, arguments, null, acceptOnlyCompatible, acceptOnlyCompatible, false, allowImplicitConversions, acceptOnlyCompatible, context);
    }

    public boolean isEmpty() {
        return this.isEmpty(new HashSet<OCStructSymbol>());
    }

    public boolean isEmpty(HashSet<OCStructSymbol> processed2) {
        boolean[] result2 = new boolean[]{true};
        for (OCStructSymbol struct : this.myStructs) {
            if (processed2.add(struct)) {
                if (struct.getKind() == OCSymbolKind.ENUM) {
                    return false;
                }
                struct.processFields((Processor<OCDeclaratorSymbol>)((Processor)symbol -> {
                    OCType elementType = symbol.getResolvedType();
                    if (elementType instanceof OCArrayType) {
                        if (!((OCArrayType)elementType).isEmpty(symbol.getContainingOCFile(), processed2)) {
                            result2[0] = false;
                        }
                    } else if (elementType instanceof OCStructType) {
                        if (!((OCStructType)elementType).isEmpty(processed2)) {
                            result2[0] = false;
                        }
                    } else {
                        result2[0] = false;
                    }
                    return true;
                }));
                processed2.remove(struct);
                continue;
            }
            return false;
        }
        return result2[0];
    }

    public boolean processFields(@Nullable String fieldName, Processor<? super OCDeclaratorSymbol> processor2, OCResolveContext context) {
        return this.processMembers(fieldName, (Processor<OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCDeclaratorSymbol) {
                return processor2.process((Object)((OCDeclaratorSymbol)ocSymbol));
            }
            return true;
        }), context);
    }

    public boolean isAbstract(OCResolveContext context) {
        return !this.processMembers(null, (Processor<OCSymbol>)((Processor)symbol -> !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isPureVirtual()), context);
    }

    public boolean isUnnamed() {
        return this.myStructs.get(0).isUnnamed();
    }

    public boolean isPredeclaration() {
        for (OCStructSymbol struct : this.myStructs) {
            if (struct.isPredeclaration()) continue;
            return false;
        }
        return true;
    }

    public boolean isPOD(boolean checkInnerStructs) {
        return !ContainerUtil.exists(this.myStructs, symbol -> !symbol.isPOD(checkInnerStructs));
    }

    public static boolean processMembersInBaseTypes(@NotNull OCStructSymbol scope, @Nullable String memberName, boolean typesOnly, boolean goTransitive, @NotNull Condition<OCSymbol> condition2, @NotNull Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        HashSet processedSet;
        Set<OCNamespaceLikeSymbol> processed2 = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack<Pair> workset = new Stack<Pair>();
        FilteringProcessor filteringProcessor = new FilteringProcessor(condition2, processor2);
        if (!goTransitive && memberName == null) {
            processedSet = new HashSet();
            goTransitive = true;
        } else {
            processedSet = null;
        }
        processed2.add(scope);
        workset.add(new Pair((Object)scope, processedSet));
        while (!workset.isEmpty()) {
            ProgressManager.checkCanceled();
            Pair pair = (Pair)workset.pop();
            if (!(pair.getFirst() instanceof OCStructSymbol)) continue;
            OCStructSymbol structSymbol = (OCStructSymbol)pair.getFirst();
            boolean finalGoTransitive = goTransitive;
            structSymbol.processBaseClasses(context.useFor(scope), (symbol, visibility) -> {
                if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && symbol.getName().equals(memberName) && !filteringProcessor.process((Object)symbol)) {
                    return false;
                }
                HashSet<String> alreadyProcessed = pair.getSecond() != null ? new HashSet<String>((Collection)pair.getSecond()) : null;
                InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, finalGoTransitive, alreadyProcessed, scope.getSubstitution(), processed2, workset, processor2, condition2, context);
                return resolver.process(symbol);
            });
        }
        return true;
    }

    public static boolean processMembersOfNamespace(@NotNull OCNamespaceLikeSymbol namespace, @Nullable String memberName, boolean lookInsideUsings, boolean typesOnly, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        ProgressManager.checkCanceled();
        class SomethingProcessedDetector
        implements Processor<OCSymbol> {
            private final Processor<OCSymbol> myProcessor;
            private boolean mySomethingProcessed = false;
            private boolean myNamespaceProcessed = false;

            SomethingProcessedDetector(Processor<OCSymbol> processor2) {
                this.myProcessor = processor2;
            }

            public boolean process(OCSymbol symbol) {
                this.mySomethingProcessed = true;
                if (symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    this.myNamespaceProcessed = true;
                }
                return this.myProcessor.process((Object)symbol);
            }
        }
        SomethingProcessedDetector detector = new SomethingProcessedDetector(processor2);
        FilteringProcessor filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, (Processor)detector);
        if (!namespace.processMembers(memberName, filter)) {
            return false;
        }
        Set<OCNamespaceLikeSymbol> processed2 = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack<Pair<OCNamespaceLikeSymbol, Set<String>>> workset = new Stack<Pair<OCNamespaceLikeSymbol, Set<String>>>();
        processed2.add(namespace);
        workset.add(new Pair((Object)namespace, null));
        Collection<OCNamespaceSymbol> inlineNamespaces = namespace.getInlineNamespaces();
        if (lookInsideUsings && inlineNamespaces != null && (!detector.myNamespaceProcessed || memberName == null)) {
            for (OCNamespaceSymbol inlineNamespace : inlineNamespaces) {
                OCStructType.processMembersOfNamespace(inlineNamespace, memberName, true, typesOnly, processor2, context);
            }
        }
        if (!(!lookInsideUsings || namespace.getNamespaceUsings() == null && inlineNamespaces == null || detector.myNamespaceProcessed && memberName != null)) {
            while (!workset.isEmpty()) {
                ProgressManager.checkCanceled();
                Pair pair = (Pair)workset.pop();
                Collection<OCUsingSymbol> namespaceUsings = ((OCNamespaceLikeSymbol)pair.getFirst()).getNamespaceUsings();
                if (namespaceUsings == null) continue;
                for (OCUsingSymbol using : namespaceUsings) {
                    OCNamespaceLikeSymbol container;
                    ProgressManager.checkCanceled();
                    PsiFile file2 = context.getFile();
                    int index = Integer.MAX_VALUE;
                    OCNamespaceLikeSymbol oCNamespaceLikeSymbol = container = file2 instanceof OCFile ? ((OCFile)file2).getMembersContainer(false) : null;
                    if (container instanceof OCNamespaceLikeSymbol.UsingNamespaceProvider && ((index = ((OCNamespaceLikeSymbol.UsingNamespaceProvider)container).getUsingNamespaceIndex(using)) >= context.getCurrentUsingIndex() || context.isOriginallyProcessNonImported() && index == -1)) continue;
                    InnerProcessor resolver = new InnerProcessor(memberName, typesOnly, true, null, OCTypeSubstitution.ID, processed2, workset, processor2, (Condition<OCSymbol>)Conditions.alwaysTrue(), context);
                    context.startResolvingNamespaceUsing(index);
                    List<OCSymbol> list = context.resolveToSymbols(using.getSymbolReference(), false, typesOnly);
                    if (list.isEmpty() && context.isOriginallyProcessNonImported() && !context.isProcessNonImported()) {
                        context.setProcessNonImported(true);
                        list = context.resolveToSymbols(using.getSymbolReference(), false, typesOnly);
                        context.setProcessNonImported(false);
                    }
                    boolean wasVisibleFromUsing = false;
                    OCSymbolWithQualifiedName lastParent = null;
                    for (OCSymbol symbol : list) {
                        ProgressManager.checkCanceled();
                        PsiElement contextElement = context.getElement();
                        if (!(contextElement instanceof OCFile) && !OCResolveUtil.isEarlierInCode(symbol, contextElement)) continue;
                        if (symbol instanceof OCSymbolWithQualifiedName) {
                            OCSymbolWithQualifiedName parent = ((OCSymbolWithQualifiedName)symbol).getParent();
                            if (wasVisibleFromUsing && !OCSymbolWithQualifiedName.isSameSymbol(parent, lastParent, context)) break;
                            lastParent = parent;
                            if (OCResolveUtil.isEarlierInCode(symbol, using)) {
                                wasVisibleFromUsing = true;
                            }
                        }
                        if (resolver.process(symbol)) continue;
                        context.stopResolvingNamespaceUsing();
                        return false;
                    }
                    context.stopResolvingNamespaceUsing();
                }
            }
        }
        if (namespace instanceof OCStructSymbol) {
            OCStructSymbol struct = (OCStructSymbol)namespace;
            if (!typesOnly && struct.getKind() == OCSymbolKind.STRUCT) {
                OCStructType ownType;
                OCCppReferenceType constRefToOwnType;
                OCFile file3 = struct.getContainingOCFile();
                if ("operator=".equals(memberName) && struct.processMembers(memberName, (Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(constRefToOwnType = OCCppReferenceType.to((ownType = new OCStructType(struct)).cloneWithConstModifier(struct.getProject())), file3){
                    final /* synthetic */ OCCppReferenceType val$constRefToOwnType;
                    final /* synthetic */ OCFile val$file;
                    {
                        this.val$constRefToOwnType = oCCppReferenceType;
                        this.val$file = oCFile;
                    }

                    protected boolean accept(OCSymbol symbol) {
                        if (!(symbol instanceof OCFunctionSymbol)) {
                            return false;
                        }
                        List<OCType> args = ((OCFunctionSymbol)symbol).getType().getParameterTypes();
                        return args.size() == 1 && args.get(0).equalsAfterResolving((OCType)this.val$constRefToOwnType, this.val$file);
                    }
                }) && struct.processMembers("operator=", (Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor())) {
                    OCFunctionType functionType = new OCFunctionType(OCCppReferenceType.to(ownType), ContainerUtil.list((Object[])new OCType[]{constRefToOwnType}));
                    int attributes = OCSymbolAttribute.EXPLICIT.getMask();
                    OCDeclaratorSymbol paramSymbol = new OCDeclaratorSymbol(null, null, -1, null, "<unnamed>", Collections.emptyList(), (OCType)constRefToOwnType, OCSymbolKind.PARAMETER);
                    processor2.process((Object)new OCFunctionSymbol(struct.getProject(), struct.getContainingFile(), struct.getComplexOffset(), struct, OCQualifiedName.with(memberName), Collections.emptyList(), Collections.emptyList(), 0, attributes, Collections.emptyList(), functionType, Collections.singletonList(paramSymbol), OCSymbolKind.FUNCTION_DECLARATION, OCVisibility.PUBLIC));
                }
            }
            if (!detector.mySomethingProcessed || memberName == null) {
                OCStructType.processMembersInBaseTypes(struct, memberName, typesOnly, true, (Condition<OCSymbol>)Conditions.alwaysTrue(), processor2, context);
            }
        }
        return true;
    }

    public boolean processMembers(@Nullable String memberName, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        for (OCStructSymbol struct : this.myStructs) {
            if (OCStructType.processMembersOfNamespace(struct, memberName, true, false, processor2, context)) continue;
            return false;
        }
        return true;
    }

    public boolean processMembers(@Nullable String memberName, boolean lookInsideUsings, boolean onlyTypes, Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        for (OCStructSymbol struct : this.myStructs) {
            if (OCStructType.processMembersOfNamespace(struct, memberName, lookInsideUsings, onlyTypes, processor2, context)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubstructOf(OCStructSymbol struct, OCStructSymbol substruct, @NotNull OCResolveContext context) {
        return Comparing.equal((Object)struct, (Object)substruct) || !substruct.processAllBaseClasses(context, (symbol, visibility) -> !symbol.equals(struct), true);
    }

    @Override
    public boolean isMagicInside(@NotNull OCResolveContext context) {
        return this.isMagicInside(context, true);
    }

    @Override
    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        return this.isMagicInside(context, false);
    }

    public boolean isMagicInside(@NotNull OCResolveContext context, boolean checkTemplateArgs) {
        for (OCStructSymbol struct : this.myStructs) {
            if (checkTemplateArgs && OCResolveUtil.hasNonResolvedTemplateParameters(struct, context)) {
                return true;
            }
            if (struct.getBaseCppClasses(context).isEmpty() && this.myStructs.size() <= 1) {
                return false;
            }
            OCSymbolWithQualifiedName current = struct;
            boolean hasTemplateInParent = false;
            while (current instanceof OCStructSymbol) {
                OCStructSymbol currentStruct = current;
                if (!currentStruct.getTemplateParameters().isEmpty()) {
                    hasTemplateInParent = true;
                    break;
                }
                current = currentStruct.getResolvedOwner();
            }
            if (!hasTemplateInParent && this.myStructs.size() <= 1) {
                return false;
            }
            if (struct.processAllBaseClasses(context, (symbol, visibility) -> !(symbol instanceof OCTypeParameterSymbol), true)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeveralSpecializations() {
        int nonPredefsCnt = 0;
        for (OCStructSymbol struct : this.myStructs) {
            if (struct.isPredefinition()) continue;
            ++nonPredefsCnt;
        }
        return nonPredefsCnt > 1;
    }

    @Override
    public boolean isScalar() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isCppStructType() {
        return this.getKind() == OCSymbolKind.STRUCT && this.getSymbol().getContainingOCFile().isCpp();
    }

    @Override
    public boolean isNumberCompatible(PsiElement context) {
        return super.isNumberCompatible(context) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    public boolean isIntegerCompatible(PsiElement context, boolean checkCppConvertible) {
        return super.isIntegerCompatible(context, checkCppConvertible) || this.getKind() == OCSymbolKind.ENUM && !this.isEnumClass();
    }

    @Override
    @NotNull
    public String getDefaultValue(PsiElement context) {
        if (this.getKind() == OCSymbolKind.ENUM) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            this.myStructs.get(0).processFields((Processor<OCDeclaratorSymbol>)finder);
            if (finder.isFound()) {
                return ((OCDeclaratorSymbol)finder.getFoundValue()).getName();
            }
        } else if (this.getKind() == OCSymbolKind.STRUCT) {
            OCStructSymbol symbol = this.getSymbol();
            if (this.isCppStructType()) {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(finder, (Condition<T>[])new Condition[]{symbol12 -> symbol12.canBeCalledWithoutArguments() && symbol12.getVisibility() == OCVisibility.PUBLIC, symbol1 -> symbol1.getVisibility() == OCVisibility.PUBLIC, Conditions.alwaysTrue()});
                symbol.processConstructors(orderedProcessor);
                orderedProcessor.finish();
                OCStructType nakedType = (OCStructType)this.cloneWithoutCVQualifiers(symbol.getProject());
                String typedefed = nakedType.getTypedefName();
                String aliased = nakedType.getAliasName();
                String hint = typedefed != null ? typedefed : (aliased != null ? aliased : null);
                String bestName = nakedType.getBestNameInContext(context, hint);
                StringBuilder builder = new StringBuilder(bestName);
                builder.append("(");
                if (finder.isFound()) {
                    boolean isFirst = true;
                    for (OCDeclaratorSymbol parameter : ((OCFunctionSymbol)finder.getFoundValue()).getParameterSymbols()) {
                        OCType type2;
                        if (parameter.hasInitializer()) break;
                        if (!isFirst) {
                            builder.append(",");
                        }
                        if ((type2 = parameter.getResolvedType()).isCppStructType()) {
                            String name;
                            if (type2 instanceof OCCppReferenceType) {
                                type2 = ((OCCppReferenceType)type2).getRefType();
                            }
                            if (type2 instanceof OCStructType) {
                                OCQualifiedName qualifiedName = ((OCStructType)type2).getSymbol().getResolvedQualifiedName();
                                qualifiedName = qualifiedName != null ? qualifiedName : symbol.getQualifiedName();
                                name = qualifiedName.getNameWithParent();
                            } else {
                                name = type2.getName();
                            }
                            builder.append(name).append("()");
                        } else {
                            builder.append(type2.getDefaultValue(context));
                        }
                        isFirst = false;
                    }
                }
                builder.append(")");
                return builder.toString();
            }
        }
        return "result";
    }

    @Override
    @Nullable
    public String getFormatString() {
        return this.getKind() == OCSymbolKind.ENUM ? "%d" : super.getFormatString();
    }

    @Override
    public int getSizeInBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
        Ref size = new Ref((Object)0);
        this.getSymbol().processFields((Processor<OCDeclaratorSymbol>)((Processor)symbol -> {
            if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD && !symbol.isFriendOrStatic()) {
                size.set((Object)((Integer)size.get() + symbol.getType().resolve(file2).getSizeInBytes(file2, context)));
            }
            return true;
        }));
        return (Integer)size.get();
    }

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type2, PsiElement context) {
        if (type2 == null) {
            return OCUnknownType.INSTANCE;
        }
        if (this.equals((Object)type2, context)) {
            return this;
        }
        if (type2 instanceof OCMagicType) {
            return this;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type2.isPointerCompatible(context)) {
            return OCIntType.INT;
        }
        if (this.getKind() == OCSymbolKind.ENUM && type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.ENUM) {
            return OCIntType.INT;
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context) {
        for (OCTypeArgument argument : this.getSymbol().getTemplateArguments(context)) {
            if (!(argument instanceof OCType) || !((OCType)argument).isUnresolved(context)) continue;
            return true;
        }
        return false;
    }

    private static class InnerProcessor
    implements Processor<OCSymbol> {
        private String myMemberName;
        private final boolean myTypesOnly;
        private final boolean myGoTransitive;
        private final Set<String> myAlreadyProcessed;
        private final OCTypeSubstitution mySubstitution;
        private Set<OCNamespaceLikeSymbol> myProcessed;
        private Stack<Pair<OCNamespaceLikeSymbol, Set<String>>> myWorkset;
        private Processor<OCSymbol> myProcessor;
        private Processor<OCSymbol> myFilteringProcessor;
        private final Condition<OCSymbol> myCondition;
        @NotNull
        private final OCResolveContext myContext;

        public InnerProcessor(String memberName, boolean typesOnly, boolean goTransitive, Set<String> alreadyProcessed, OCTypeSubstitution substitution, Set<OCNamespaceLikeSymbol> processed2, Stack<Pair<OCNamespaceLikeSymbol, Set<String>>> workset, Processor<OCSymbol> processor2, Condition<OCSymbol> condition2, @NotNull OCResolveContext context) {
            this.myMemberName = memberName;
            this.myTypesOnly = typesOnly;
            this.myGoTransitive = goTransitive;
            this.myAlreadyProcessed = alreadyProcessed;
            this.mySubstitution = substitution;
            this.myProcessed = processed2;
            this.myWorkset = workset;
            this.myProcessor = processor2;
            this.myFilteringProcessor = new FilteringProcessor(condition2, processor2);
            this.myCondition = condition2;
            this.myContext = context;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean process(OCSymbol symbol) {
            if (symbol instanceof OCNamespaceSymbol && !this.myProcessed.contains(symbol)) {
                Ref processed2;
                FilteringProcessor filter;
                OCNamespaceSymbol struct;
                this.myProcessed.add((OCNamespaceLikeSymbol)((Object)symbol));
                if (symbol instanceof OCStructSymbol && this.mySubstitution != OCTypeSubstitution.ID) {
                    symbol = new OCStructSymbol((OCStructSymbol)symbol, this.mySubstitution, false, this.myContext);
                }
                if (!(struct = (OCNamespaceSymbol)symbol).processMembers(this.myMemberName, (Processor<OCSymbol>)(filter = new FilteringProcessor(OCSymbolWithQualifiedName.WITHOUT_QUALIFIER, arg_0 -> this.lambda$process$0(processed2 = new Ref((Object)false), arg_0))))) {
                    return false;
                }
                if (((Boolean)processed2.get()).booleanValue() && !this.myGoTransitive) return true;
                this.myWorkset.push((Pair<OCNamespaceLikeSymbol, Set<String>>)new Pair((Object)struct, this.myAlreadyProcessed));
                return true;
            }
            if (symbol instanceof OCDeclaratorSymbol && symbol.getKind().isTypedefOrAlias()) {
                OCType type2 = symbol.getType();
                if (type2 instanceof OCMagicType) {
                    if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, null, 0L, this.myMemberName, null, Collections.emptyList(), null, false))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbol(null, null, 0, null, this.myMemberName, Collections.emptyList(), (OCType)new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                    return false;
                }
                if (type2 instanceof OCStructType) {
                    if (this.mySubstitution == OCTypeSubstitution.ID) {
                        return ContainerUtil.process(((OCStructType)type2).getStructs(), (Processor)this);
                    }
                    for (OCStructSymbol struct : ((OCStructType)type2).getStructs()) {
                        if (this.process(new OCStructSymbol(struct, this.mySubstitution, false, this.myContext))) continue;
                        return false;
                    }
                    return true;
                } else {
                    if (!(type2 instanceof OCReferenceType)) return true;
                    return ContainerUtil.process(this.myContext.substitute(((OCReferenceType)type2).getSubstitution()).resolveToSymbols(((OCReferenceType)type2).getReference(this.myContext), true, true), (Processor)this);
                }
            }
            if (symbol instanceof OCTypeParameterSymbol) {
                OCTypeParameterTypeSymbol qualifierTypeParameter;
                OCTypeParameterTypeSymbol oCTypeParameterTypeSymbol = qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                if (this.myFilteringProcessor.process((Object)new OCTypeParameterTypeSymbol(null, null, 0L, this.myMemberName, qualifierTypeParameter, null, Collections.emptyList(), null, false))) return this.myFilteringProcessor.process((Object)new OCDeclaratorSymbol(null, null, 0, null, this.myMemberName, Collections.emptyList(), (OCType)new OCMagicType(this.myMemberName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
                return false;
            }
            if (symbol instanceof OCUsingSymbol) {
                return ContainerUtil.process(this.myContext.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference(), true, this.myTypesOnly), (Processor)this);
            }
            if (!(symbol instanceof OCNamespaceAliasSymbol)) return true;
            return ContainerUtil.process(this.myContext.resolveToSymbols(((OCNamespaceAliasSymbol)symbol).getNamespaceReference(), true, this.myTypesOnly), (Processor)this);
        }

        private /* synthetic */ boolean lambda$process$0(Ref processed2, OCSymbol symbol1) {
            String signature;
            String string = signature = symbol1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol1).getSignatureWithoutParamNames() : symbol1.getName();
            if (this.myAlreadyProcessed != null && this.myAlreadyProcessed.contains(signature)) {
                return true;
            }
            if (this.myCondition.value((Object)symbol1)) {
                processed2.set((Object)true);
                if (this.myAlreadyProcessed != null) {
                    this.myAlreadyProcessed.add(signature);
                }
                if (!this.myProcessor.process((Object)symbol1)) {
                    return false;
                }
            }
            return true;
        }
    }
}

