/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeGuesser {
    private static Set<String> KNOWN_MUTABLE_PREFIXES = ContainerUtil.set((Object[])new String[]{"NS", "CN", "UI"});

    @Nullable
    public static OCType getMethodGuessedReturnType(@NotNull OCMethodSymbol method2, @NotNull OCObjectTypeContext receiverContext, @Nullable OCSendMessageExpression sendMessageExpr, @NotNull PsiElement context) {
        String typeName;
        String selector2 = method2.getName();
        OCType originalType = receiverContext.getOriginalType();
        OCType result2 = originalType.isClassType() || originalType instanceof OCBlockPointerType ? originalType : OCPointerType.to(receiverContext.getType());
        boolean isId = "id".equals(method2.getReturnType().getName());
        if (result2.isPointerToObject() && OCElementUtil.startsWithWord(selector2, "mutableCopy") && (typeName = receiverContext.getType().getSimpleName(context)).length() > 2) {
            OCProtocolSymbol protocol = (OCProtocolSymbol)OCSymbolImpl.findSymbolDefinition("NSMutableCopying", OCSymbolKind.PROTOCOL, method2.getProject(), method2.getContainingFile());
            String typeNamePrefix = typeName.substring(0, 2);
            if (protocol != null && ((OCObjectType)result2.getTerminalType()).implementsProtocol(protocol) && KNOWN_MUTABLE_PREFIXES.contains(typeNamePrefix)) {
                OCType type2 = OCReferenceType.resolvedFromText(typeNamePrefix + "Mutable" + typeName.substring(2), context.getContainingFile());
                return type2 instanceof OCObjectType ? OCPointerType.to(type2) : null;
            }
        }
        if (isId) {
            if (result2.isPointerToObject() && (method2.isConstructorMethod() || method2.isClassConstructorMethod() || method2.isFactoryMethod())) {
                return result2;
            }
            if (OCElementUtil.startsWithWord(selector2, "copy") || selector2.endsWith("Copy")) {
                return result2;
            }
            if (OCTypeGuesser.isOfficialNamingConvention(selector2) || "sharedInstance".equals(selector2) || "instance".equals(selector2)) {
                return originalType.isClassType() ? null : result2;
            }
            if (OCSelectorAdHocResolver.isPerformSelectorMethod(method2.getName()) && sendMessageExpr != null) {
                List methods;
                OCExpression selectorExpr;
                List<OCExpression> argumentExprs = sendMessageExpr.getArgumentExpressions();
                OCExpression oCExpression = selectorExpr = argumentExprs.isEmpty() ? null : argumentExprs.get(0);
                if (selectorExpr instanceof OCSelectorExpression && (methods = ((OCPolyVariantReference)selectorExpr.getReference()).resolveToSymbols()).size() == 1) {
                    return ((OCMethodSymbol)methods.get(0)).getReturnType().resolve(context.getContainingFile());
                }
            }
        }
        return null;
    }

    public static boolean isNewInstanceCreation(OCExpression expression2) {
        if (expression2 instanceof OCSendMessageExpression) {
            String selector2 = ((OCSendMessageExpression)expression2).getMessageSelector();
            if (OCTypeGuesser.isNewInstanceSelector(selector2)) {
                return true;
            }
            if (OCTypeGuesser.isOfficialNamingConvention(selector2)) {
                return OCTypeGuesser.isNewInstanceCreation(((OCSendMessageExpression)expression2).getReceiverExpression());
            }
        }
        return false;
    }

    public static boolean isInitializerName(String name) {
        return OCElementUtil.startsWithWord(name, "init");
    }

    private static boolean isNewInstanceSelector(String selector2) {
        return OCElementUtil.startsWithWord(selector2, "alloc") || OCElementUtil.startsWithWord(selector2, "new");
    }

    public static boolean isOfficialNamingConvention(String selector2) {
        return OCTypeGuesser.isNewInstanceSelector(selector2) || OCElementUtil.startsWithWord(selector2, "init") || OCElementUtil.startsWithWord(selector2, "autorelease") || OCElementUtil.startsWithWord(selector2, "retain") || OCElementUtil.startsWithWord(selector2, "self");
    }

    @Nullable
    private static List<OCSymbol> findImmediateEnumSymbolBefore(final OCSymbol target, OCFile file2) {
        if (file2 == null) {
            return null;
        }
        FileSymbolTablesCache cache2 = FileSymbolTablesCache.getInstance(file2.getProject());
        List<FileSymbolTable> tables = cache2.allTablesForFile(file2);
        final ArrayList<OCSymbol> enumConsts = new ArrayList<OCSymbol>();
        for (FileSymbolTable table : tables) {
            final boolean[] metSymbol = new boolean[]{false};
            table.processFile(new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol == target) {
                        metSymbol[0] = true;
                        return false;
                    }
                    if (symbol.getKind() == OCSymbolKind.ENUM_CONST) {
                        enumConsts.add(symbol);
                    } else {
                        enumConsts.clear();
                    }
                    if (symbol.getKind() == OCSymbolKind.NAMESPACE) {
                        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)collector);
                        List results = (List)collector.getResults();
                        Collections.sort(results, (o1, o2) -> OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset()));
                        if (!ContainerUtil.process((List)results, (Processor)this)) {
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (!metSymbol[0] || enumConsts.isEmpty()) continue;
            return enumConsts;
        }
        return null;
    }

    public static void processGuessedEnumConsts(OCIntType type2, Processor<OCSymbol> processor2, PsiElement context) {
        String typedefName = type2.getAliasName();
        if (typedefName != null) {
            CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
            OCSymbolReference.getLocalReference(OCQualifiedName.parse(typedefName), context).processPossibleSymbols((Processor<OCSymbol>)collector, context.getContainingFile());
            OCSymbol typedefSymbol = (OCSymbol)collector.getFoundValue();
            if (typedefSymbol instanceof OCDeclaratorSymbol && typedefSymbol.getKind() == OCSymbolKind.TYPEDEF) {
                OCFile file2 = typedefSymbol.getContainingOCFile();
                List<OCSymbol> consts = OCTypeGuesser.findImmediateEnumSymbolBefore(typedefSymbol, file2);
                if (consts != null) {
                    for (OCSymbol symbol : consts) {
                        processor2.process((Object)symbol);
                    }
                    return;
                }
                String singular = StringUtil.unpluralize((String)typedefName);
                String[] typeWords = NameUtil.nameToWords((String)(singular != null ? singular : typedefName));
                OCResolveUtil.processGlobalSymbols(null, context, (Processor<OCSymbol>)((Processor)ocSymbol -> {
                    String constName;
                    return !(ocSymbol instanceof OCDeclaratorSymbol) || ocSymbol.getKind() != OCSymbolKind.ENUM_CONST || !OCTypeGuesser.matchesTypeName(constName = ocSymbol.getName(), typeWords) || !Comparing.equal((Object)ocSymbol.getContainingFile(), (Object)typedefSymbol.getContainingFile()) || processor2.process(ocSymbol);
                }));
            }
        }
    }

    private static boolean matchesTypeName(String constName, String[] typeWords) {
        String[] constWords = NameUtil.nameToWords((String)constName);
        int curConst = 0;
        boolean strictPrefix = "k".equals(constWords[0]);
        if (strictPrefix) {
            curConst = 1;
            for (String typeWord : typeWords) {
                if (curConst >= constWords.length) {
                    return false;
                }
                if (!"ID".equals(typeWord) && !constWords[curConst].equals(typeWord)) {
                    return false;
                }
                ++curConst;
            }
            return true;
        }
        for (String typeWord : typeWords) {
            while (curConst < constWords.length && !constWords[curConst].equals(typeWord) && !"ID".equals(typeWord)) {
                ++curConst;
            }
            ++curConst;
        }
        return curConst <= constWords.length;
    }
}

