/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerProperty;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import org.jetbrains.annotations.Nullable;

public class OCTypeMapper {
    public static final short BIT_8 = 1;
    public static final short BIT_16 = 2;
    public static final short BIT_32 = 4;
    public static final short BIT_64 = 8;
    public static final short BIT_128 = 16;

    public static enum CTypeId {
        BOOL(null, 1),
        SIGNED_CHAR(null, 1),
        CHAR(null, 1),
        CHAR16_T(null, 2),
        CHAR32_T(null, 4),
        WCHAR_T(OCCompilerProperty.PropertyKey.__SIZEOF_WCHAR_T__, 4),
        SHORT(OCCompilerProperty.PropertyKey.__SIZEOF_SHORT__, 2),
        INT(OCCompilerProperty.PropertyKey.__SIZEOF_INT__, 4),
        LONG(OCCompilerProperty.PropertyKey.__SIZEOF_LONG__, 4),
        SIZE_T(OCCompilerProperty.PropertyKey.__SIZEOF_SIZE_T__, 4),
        PTRDIFF_T(OCCompilerProperty.PropertyKey.__SIZEOF_PTRDIFF_T__, 4),
        POINTER(OCCompilerProperty.PropertyKey.__SIZEOF_POINTER__, 4),
        LONG_LONG(OCCompilerProperty.PropertyKey.__SIZEOF_LONG_LONG__, 8),
        INT128_T(null, 16),
        FLOAT(OCCompilerProperty.PropertyKey.__SIZEOF_FLOAT__, 4),
        DOUBLE(OCCompilerProperty.PropertyKey.__SIZEOF_DOUBLE__, 8),
        LONG_DOUBLE(OCCompilerProperty.PropertyKey.__SIZEOF_LONG_DOUBLE__, 8);

        @Nullable
        private final OCCompilerProperty.PropertyKey myKey;
        private final short myDefByteCount;

        private CTypeId(OCCompilerProperty.PropertyKey keyName, short defByteCount) {
            this.myKey = keyName;
            this.myDefByteCount = defByteCount;
        }

        public int getBytes(@Nullable PsiFile file2, @Nullable OCInclusionContext context) {
            Short sizeInBits;
            Short s = sizeInBits = this.myKey == null ? null : (Short)OCCompilerHelper.getPropertyForFile(file2, context, this.myKey);
            if (sizeInBits == null) {
                return this.myDefByteCount;
            }
            return sizeInBits.shortValue();
        }
    }
}

