/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeUtils {
    public static <T extends OCTypeArgument> Set<T> newTypeSet() {
        return new THashSet(new TObjectHashingStrategy<T>(){

            public int computeHashCode(T object) {
                return object.hashCode();
            }

            public boolean equals(T o1, T o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    public static Set<OCNamespaceLikeSymbol> newSymbolWithSubstitutionSet() {
        return new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCNamespaceLikeSymbol>(){

            public int computeHashCode(OCNamespaceLikeSymbol symbol) {
                return symbol.hashCode() * 31 + (symbol instanceof OCSymbolWithSubstitution ? ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution().hashCode() : 0);
            }

            public boolean equals(OCNamespaceLikeSymbol o1, OCNamespaceLikeSymbol o2) {
                if (!o1.equals(o2)) {
                    return false;
                }
                return !(o1 instanceof OCSymbolWithSubstitution) || !(o2 instanceof OCSymbolWithSubstitution) || DeepEqual.equalObjects(((OCSymbolWithSubstitution)((Object)o1)).getSubstitution(), ((OCSymbolWithSubstitution)((Object)o2)).getSubstitution());
            }
        });
    }

    public static Set<Pair<OCSymbolReference, OCTypeSubstitution>> newReferenceWithSubstitutionSet() {
        return new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<OCSymbolReference, OCTypeSubstitution>>(){

            public int computeHashCode(Pair<OCSymbolReference, OCTypeSubstitution> object) {
                return object.hashCode();
            }

            public boolean equals(Pair<OCSymbolReference, OCTypeSubstitution> o1, Pair<OCSymbolReference, OCTypeSubstitution> o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    public static Map<OCTypeParameterSymbol, OCTypeArgument> newTypeParameterMap() {
        return new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OCTypeParameterSymbol>(){

            public int computeHashCode(OCTypeParameterSymbol object) {
                return object.hashCode();
            }

            public boolean equals(OCTypeParameterSymbol o1, OCTypeParameterSymbol o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    public static Map<OCType, OCType> newTypesMap() {
        return new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OCType>(){

            public int computeHashCode(OCType object) {
                return object.hashCode();
            }

            public boolean equals(OCType o1, OCType o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    @NotNull
    public static <TKey, TValue> Map<TKey, TValue> newDeepEqualityMap() {
        TObjectHashingStrategy hashingStrategy = new TObjectHashingStrategy<TKey>(){

            public int computeHashCode(TKey object) {
                return object.hashCode();
            }

            public boolean equals(TKey left, TKey right) {
                return DeepEqual.equalObjects(left, right);
            }
        };
        return ContainerUtil.newConcurrentMap((TObjectHashingStrategy)hashingStrategy);
    }

    public static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, false);
    }

    public static boolean isSignaturesConformsTo(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, true);
    }

    private static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes, boolean conformsTo) {
        List templateParams2;
        if ((s1 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s1)).isTemplateSymbol()) != (s2 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s2)).isTemplateSymbol())) {
            return false;
        }
        OCQualifiedName fqn1 = s1.getResolvedQualifiedName(context, false);
        OCQualifiedName fqn2 = s2.getResolvedQualifiedName(context, false);
        if (fqn1 == null || fqn2 == null || !fqn1.equals(fqn2)) {
            return false;
        }
        List parentTemplateParams1 = s1.getParent() == s2.getParent() && s1.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1.getParent())).getTemplateParameters() : Collections.emptyList();
        List parentTemplateParams2 = s1.getParent() == s2.getParent() && s2.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2.getParent())).getTemplateParameters() : Collections.emptyList();
        List templateParams1 = s1 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1)).getTemplateParameters() : Collections.emptyList();
        List<Object> list = templateParams2 = s2 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2)).getTemplateParameters() : Collections.emptyList();
        if (templateParams1.size() != templateParams2.size()) {
            return false;
        }
        Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
        OCType t1 = (s1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s1).getTypeWithoutSubstitution() : s1.getType()).resolve(context);
        OCType t2 = (s2 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s2).getTypeWithoutSubstitution() : s2.getType()).resolve(context);
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t2, null, map2, null, context).unify(t1, t2).isUnified()) {
            return false;
        }
        if (conformsTo) {
            return true;
        }
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t1, null, new HashMap<OCTypeParameterSymbol, OCTypeArgument>(), null, context).unify(t2, t1).isUnified()) {
            return false;
        }
        block0: for (Map.Entry<OCTypeParameterSymbol, OCTypeArgument> each : map2.entrySet()) {
            if (!(each.getValue() instanceof OCTypeParameterType)) {
                return false;
            }
            OCTypeParameterSymbol key2 = each.getKey();
            OCTypeParameterSymbol value2 = ((OCTypeParameterType)each.getValue()).getSymbol();
            if (!(s1.getParent() != s2.getParent() || Objects.equals(key2.getName(), value2.getName()) || templateParams1.contains(key2) || templateParams2.contains(value2))) {
                return false;
            }
            while (key2 != null && value2 != null) {
                if (templateParams1.indexOf(key2) != templateParams2.indexOf(value2)) {
                    return false;
                }
                if (parentTemplateParams1.indexOf(key2) != parentTemplateParams2.indexOf(value2)) {
                    return false;
                }
                if (!(key2 instanceof OCTypeParameterTypeSymbol) || !(value2 instanceof OCTypeParameterTypeSymbol)) continue block0;
                key2 = ((OCTypeParameterTypeSymbol)key2).getQualifierTypeParameter();
                value2 = ((OCTypeParameterTypeSymbol)value2).getQualifierTypeParameter();
            }
        }
        for (int i2 = 0; i2 < templateParams1.size(); ++i2) {
            OCType pt1 = ((OCSymbol)templateParams1.get(i2)).getType().resolve(context);
            OCType pt2 = ((OCSymbol)templateParams2.get(i2)).getType().resolve(context);
            if (pt1 instanceof OCTypeParameterType && pt2 instanceof OCTypeParameterType || pt1.equals(pt2, true, context)) continue;
            return false;
        }
        return true;
    }

    public static OCType getExtractExpressionType(OCType type2, @NotNull PsiElement context, boolean disallowConst) {
        return OCTypeUtils.getExtractExpressionType(type2, context, disallowConst, false);
    }

    public static OCType getExtractExpressionType(OCType type2, @NotNull PsiElement context, boolean disallowConst, boolean forceReferenceMode) {
        if ((type2 = type2.resolve(context.getContainingFile())) instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type2;
            type2 = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, false);
        }
        if (OCTypeUtils.isPassableByReference(type2, forceReferenceMode, context)) {
            return OCCppReferenceType.to(disallowConst ? type2 : type2.cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type2 instanceof OCCppReferenceType) {
            return OCCppReferenceType.to(((OCCppReferenceType)type2).getRefType().cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type2 instanceof OCPointerType && !(type2 instanceof OCBlockPointerType) && !type2.isPointerToObject()) {
            return OCPointerType.to(((OCPointerType)type2).getRefType().cloneWithConstModifier(context.getProject()));
        }
        return type2;
    }

    public static boolean isPassableByReference(OCType type2, boolean forceReferenceMode, PsiElement context) {
        return (forceReferenceMode || type2 instanceof OCStructType && ((OCStructType)type2).getKind() != OCSymbolKind.ENUM || type2 instanceof OCReferenceType) && !OCCodeInsightUtil.isInPlainOldC(context);
    }

    @Nullable
    public static OCType getCollectionItemType(@NotNull OCType collectionType, final @Nullable PsiElement context) {
        OCProtocolSymbol protocol;
        OCObjectType objectType;
        OCClassSymbol symbol;
        if (collectionType instanceof OCObjectType && (symbol = (objectType = (OCObjectType)collectionType).getClassSymbol()) != null && (protocol = (OCProtocolSymbol)OCSymbolImpl.findSymbolDefinition("NSFastEnumeration", OCSymbolKind.PROTOCOL, symbol.getProject(), symbol.getContainingFile())) != null && objectType.implementsProtocol(protocol)) {
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol o) {
                    OCType returnType = o.getReturnType().resolve(new OCResolveContext(context));
                    if (returnType instanceof OCPointerType) {
                        returnType = ((OCPointerType)returnType).getRefType();
                    }
                    if (!(returnType instanceof OCObjectType)) {
                        return false;
                    }
                    return "NSEnumerator".equals(((OCObjectType)returnType).getClassName());
                }
            };
            Iterator methodNamesIterator = ContainerUtil.newArrayList((Object[])new String[]{"keyEnumerator", "objectEnumerator", null}).iterator();
            while (!processor2.isFound() && methodNamesIterator.hasNext()) {
                objectType.processMembers((String)methodNamesIterator.next(), OCMethodSymbol.class, processor2, true, false);
            }
            if (processor2.isFound()) {
                OCTypeArgument argument;
                List<OCGenericParameterSymbol> parameters2;
                OCInterfaceSymbol interfaceSymbol;
                OCMethodSymbol value2 = (OCMethodSymbol)processor2.getFoundValue();
                assert (value2 != null);
                OCType returnType = value2.getReturnType().resolve(new OCResolveContext(context));
                if (returnType instanceof OCPointerType) {
                    returnType = ((OCPointerType)returnType).getRefType();
                }
                if ((interfaceSymbol = ((OCObjectType)returnType).getInterface()) != null && !(parameters2 = interfaceSymbol.getGenericParameters()).isEmpty() && (argument = interfaceSymbol.getSubstitution().getSubstitutionFor(parameters2.get(0))) instanceof OCType) {
                    return (OCType)argument;
                }
            }
        }
        return null;
    }

    public static OCType decayType(@NotNull OCType type2, @NotNull Project project2) {
        if (type2 instanceof OCArrayType) {
            type2 = OCArrayToPointerChanger.INSTANCE.visitArrayType((OCArrayType)type2);
        }
        if (type2 instanceof OCCppReferenceType) {
            type2 = ((OCCppReferenceType)type2).getRefType();
        }
        if (type2 instanceof OCFunctionType) {
            type2 = OCPointerType.to(type2);
        }
        return type2.cloneWithoutCVQualifiers(project2);
    }

    public static boolean isInstanceOfType(@Nullable OCExpression expression2, @NotNull OCResolveContext resolveContext, Class<? extends OCType> ... typeClasses) {
        return OCTypeUtils.isInstanceOfType(OCTypeUtils.getResolvedCppReferencedType(expression2, resolveContext), typeClasses);
    }

    @Nullable
    public static OCType getResolvedCppReferencedType(@Nullable OCExpression expression2, @NotNull OCResolveContext resolveContext) {
        return expression2 != null ? OCTypeUtils.getResolvedCppReferencedType(expression2.getType(), resolveContext) : null;
    }

    @NotNull
    public static OCType getResolvedCppReferencedType(@NotNull OCType type2, @NotNull OCResolveContext resolveContext) {
        OCType resolvedType = type2.resolve(resolveContext);
        return OCTypeUtils.getCppReferencedType(resolvedType);
    }

    @NotNull
    public static OCType getCppReferencedType(@NotNull OCType type2) {
        if (type2 instanceof OCCppReferenceType) {
            return ((OCCppReferenceType)type2).getRefType();
        }
        return type2;
    }

    public static boolean isInstanceOfType(@Nullable OCType type2, Class<? extends OCType> ... typeClasses) {
        if (type2 == null) {
            return false;
        }
        for (Class<? extends OCType> typeClass : typeClasses) {
            if (!typeClass.isInstance(type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAutoInside(@NotNull OCType type2) {
        return type2.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitAutoType(OCAutoType type2) {
                return type2.getExpressionSymbol() == null && type2.getExpressionElement() == null;
            }
        });
    }

    @NotNull
    public static OCType replaceAutoTypesWithTypeParameters(@NotNull OCType type2, final @NotNull Map<OCType, OCType> map2) {
        return type2.accept(new OCNonPrimitiveTypeCloneVisitor(){

            @Override
            public OCType visitAutoType(OCAutoType type2) {
                OCTypeParameterTypeSymbol autoSymbol = new OCTypeParameterTypeSymbol(null, null, map2.size(), "auto", null, Collections.emptyList(), null, false);
                OCTypeParameterType newType = new OCTypeParameterType(autoSymbol, type2.isConst(), type2.isVolatile());
                map2.put(type2, newType);
                return newType;
            }
        });
    }

    public static boolean isUnresolvedLambdaAutoType(@Nullable OCType type2) {
        return type2 instanceof OCAutoType && ((OCAutoType)type2).needsAutoParamsResolving();
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType type2, @NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> argumentsList, boolean failIfNotUnified) {
        OCExpressionSymbol symbol = ((OCAutoType)type2).getExpressionSymbol();
        if (symbol instanceof OCLambdaExpressionSymbol) {
            return ((OCLambdaExpressionSymbol)symbol).getResolvedType(context, argumentsList, failIfNotUnified);
        }
        return type2;
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType lType, @NotNull OCType rType, @NotNull OCResolveContext context) {
        if (lType.getTerminalType() instanceof OCFunctionType) {
            OCArgumentsList arguments = new OCArgumentsList(((OCFunctionType)lType.getTerminalType()).getParameterTypes(), null);
            OCType resolvedType = OCTypeUtils.resolveLambdaAutoType(rType, context, arguments, false);
            if (resolvedType != null && resolvedType.getTerminalType() instanceof OCFunctionType) {
                return resolvedType;
            }
            ((OCAutoType)rType).setNeedsAutoParamsResolving(false);
            return rType.resolve(context);
        }
        OCExpressionSymbol expressionSymbol = ((OCAutoType)rType).getExpressionSymbol();
        if (expressionSymbol != null) {
            return expressionSymbol.getResolvedType(context);
        }
        return rType;
    }
}

