/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OCArgumentDepLookupAccumulator
implements OCTypeVisitor<Void> {
    private HashSet<OCSymbolWithQualifiedName> mySymbols = new HashSet();

    public HashSet<OCSymbolWithQualifiedName> getAccumulatedSymbols() {
        return this.mySymbols;
    }

    public void visitTypes(Collection<OCType> arguments) {
        for (OCType argument : arguments) {
            argument.accept(this);
        }
    }

    @Override
    @Nullable
    public Void visitEllipsisReferenceType(OCEllipsisType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitFunctionType(OCFunctionType type2) {
        type2.getReturnType().accept(this);
        for (OCType arg : type2.getParameterTypes()) {
            arg.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitMagicType(OCMagicType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitObjectType(OCObjectType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitArrayType(OCArrayType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitPointerType(OCPointerType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitBlockPointerType(OCBlockPointerType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    @Nullable
    public Void visitCppReferenceType(OCCppReferenceType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    public Void visitVariadicType(OCVariadicType type2) {
        return type2.getUnderlyingType().accept(this);
    }

    @Override
    public Void visitExpansionPackType(OCExpansionPackType type2) {
        for (OCTypeArgument argument : type2.getExpansions()) {
            if (!(argument instanceof OCType)) continue;
            ((OCType)argument).accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitIdType(OCIdType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitIntType(OCIntType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitRealType(OCRealType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitReferenceType(OCReferenceType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitStructType(OCStructType type2) {
        for (OCStructSymbol struct : type2.getStructs()) {
            this.mySymbols.add(struct.getParent());
            OCFile file2 = struct.getContainingOCFile();
            if (file2 != null) {
                struct.processBaseClasses(new OCResolveContext(file2), (symbol, visibility) -> {
                    if (symbol instanceof OCStructSymbol) {
                        this.mySymbols.add(((OCStructSymbol)symbol).getParent());
                    }
                    return true;
                });
            }
            for (OCTypeParameterSymbol param : struct.getTemplateParameters()) {
                OCTypeArgument subst = struct.getSubstitution().getSubstitutionFor(param);
                if (!(subst instanceof OCType)) continue;
                ((OCType)subst).accept(this);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitUnknownType(OCUnknownType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitVoidType(OCVoidType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitTypeParameterType(OCTypeParameterType type2) {
        return null;
    }

    @Override
    @Nullable
    public Void visitAutoType(OCAutoType type2) {
        return null;
    }

    public static Collection<OCSymbol> doArgDepLookup(Collection<OCSymbol> symbols, List<OCType> types, List<? extends OCExpression> args, OCQualifiedName name, OCResolveContext context) {
        if (!symbols.stream().allMatch(s -> s instanceof OCFunctionSymbol || s instanceof OCStructSymbol)) {
            return symbols;
        }
        if (symbols.stream().anyMatch(s -> s instanceof OCLocalFunctionSymbol)) {
            return symbols.stream().filter(s -> s instanceof OCLocalFunctionSymbol).collect(Collectors.toList());
        }
        OCArgumentDepLookupAccumulator acc = new OCArgumentDepLookupAccumulator();
        acc.visitTypes(types);
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(new LinkedHashSet());
        ContainerUtil.process(symbols, (Processor)collector);
        for (OCExpression oCExpression : args) {
            OCReferenceElement ref = null;
            OCExpression oCExpression2 = OCParenthesesUtils.diveIntoParentheses(oCExpression);
            if (oCExpression2 instanceof OCUnaryExpression) {
                OCUnaryExpression unary = (OCUnaryExpression)oCExpression2;
                if (unary.isGetAddress() && unary.getOperand() instanceof OCReferenceExpression) {
                    OCReferenceExpression operand2 = (OCReferenceExpression)unary.getOperand();
                    ref = operand2.getReferenceElement();
                }
            } else if (oCExpression2 instanceof OCReferenceExpression) {
                ref = ((OCReferenceExpression)oCExpression2).getReferenceElement();
            } else if (oCExpression2 instanceof OCReferenceElement) {
                ref = (OCReferenceElement)((Object)oCExpression2);
            }
            if (ref == null) continue;
            for (OCSymbol overload : ref.resolveToOverloadsSymbols()) {
                if (!(overload instanceof OCFunctionSymbol)) continue;
                overload.getResolvedType().accept(acc);
            }
        }
        HashSet processed2 = new HashSet();
        for (OCSymbolWithQualifiedName parentSymbol : acc.getAccumulatedSymbols()) {
            if (parentSymbol == null) {
                OCStructType.processMembersOfNamespace(((OCFile)context.getFile()).getMembersContainer(false), name.getName(), false, false, (Processor<OCSymbol>)collector, context);
                continue;
            }
            if (!(parentSymbol instanceof OCNamespaceLikeSymbol) || name.getQualifier() != null) continue;
            parentSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (processed2.add(symbol) && symbol instanceof OCNamespaceLikeSymbol) {
                    OCStructType.processMembersOfNamespace((OCNamespaceLikeSymbol)((Object)symbol), name.getName(), false, false, (Processor<OCSymbol>)collector, context);
                }
                return true;
            }), context.getFile());
        }
        return collector.getResults();
    }
}

