/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;

public class OCBooleanTypeVisitor
implements OCTypeVisitor<Boolean> {
    @Override
    public Boolean visitFunctionType(OCFunctionType type2) {
        if (type2.getReturnType().accept(this).booleanValue()) {
            return true;
        }
        for (OCType arg : type2.getParameterTypes()) {
            if (!arg.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visitArrayType(OCArrayType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    public Boolean visitPointerType(OCPointerType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    public Boolean visitBlockPointerType(OCBlockPointerType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    public Boolean visitCppReferenceType(OCCppReferenceType type2) {
        return type2.getRefType().accept(this);
    }

    @Override
    public Boolean visitEllipsisReferenceType(OCEllipsisType type2) {
        return false;
    }

    @Override
    public Boolean visitMagicType(OCMagicType type2) {
        return false;
    }

    @Override
    public Boolean visitObjectType(OCObjectType type2) {
        return false;
    }

    @Override
    public Boolean visitIdType(OCIdType type2) {
        return false;
    }

    @Override
    public Boolean visitIntType(OCIntType type2) {
        return false;
    }

    @Override
    public Boolean visitRealType(OCRealType type2) {
        return false;
    }

    @Override
    public Boolean visitReferenceType(OCReferenceType type2) {
        return false;
    }

    @Override
    public Boolean visitStructType(OCStructType type2) {
        return false;
    }

    @Override
    public Boolean visitUnknownType(OCUnknownType type2) {
        return false;
    }

    @Override
    public Boolean visitVoidType(OCVoidType type2) {
        return false;
    }

    @Override
    public Boolean visitTypeParameterType(OCTypeParameterType type2) {
        return false;
    }

    @Override
    public Boolean visitAutoType(OCAutoType type2) {
        return false;
    }

    @Override
    public Boolean visitVariadicType(OCVariadicType type2) {
        return type2.getUnderlyingType().accept(this);
    }

    @Override
    public Boolean visitExpansionPackType(OCExpansionPackType type2) {
        for (OCTypeArgument argument : type2.getExpansions()) {
            if (!(argument instanceof OCType) || !((OCType)argument).accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

