/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;

public abstract class OCIntTypeVisitor
implements OCTypeVisitor<Integer> {
    private OCResolveContext myContext;

    public OCIntTypeVisitor(OCResolveContext context) {
        this.myContext = context;
    }

    protected abstract int visitType(OCType var1);

    protected abstract int visitNonTypeArgument(OCTypeArgument var1);

    protected int visitTypeArgument(OCTypeArgument typeArgument) {
        return typeArgument instanceof OCType ? ((OCType)typeArgument).accept(this).intValue() : this.visitNonTypeArgument(typeArgument);
    }

    @Override
    public Integer visitFunctionType(OCFunctionType type2) {
        return this.visitType(type2) + type2.getReturnType().accept(this) + type2.getParameterTypes().stream().mapToInt(t -> t.accept(this)).sum();
    }

    @Override
    public Integer visitArrayType(OCArrayType type2) {
        return this.visitType(type2) + type2.getRefType().accept(this);
    }

    @Override
    public Integer visitPointerType(OCPointerType type2) {
        return this.visitType(type2) + type2.getRefType().accept(this);
    }

    @Override
    public Integer visitBlockPointerType(OCBlockPointerType type2) {
        return this.visitType(type2) + type2.getRefType().accept(this);
    }

    @Override
    public Integer visitCppReferenceType(OCCppReferenceType type2) {
        return this.visitType(type2) + type2.getRefType().accept(this);
    }

    @Override
    public Integer visitExpansionPackType(OCExpansionPackType type2) {
        return this.visitType(type2) + type2.getExpansions().stream().mapToInt(this::visitTypeArgument).sum();
    }

    @Override
    public Integer visitStructType(OCStructType type2) {
        return this.visitType(type2) + type2.getSymbol().getTemplateArguments(this.myContext).stream().mapToInt(this::visitTypeArgument).sum();
    }

    @Override
    public Integer visitObjectType(OCObjectType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitIdType(OCIdType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitIntType(OCIntType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitRealType(OCRealType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitReferenceType(OCReferenceType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitEllipsisReferenceType(OCEllipsisType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitMagicType(OCMagicType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitUnknownType(OCUnknownType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitVoidType(OCVoidType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitTypeParameterType(OCTypeParameterType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitAutoType(OCAutoType type2) {
        return this.visitType(type2);
    }

    @Override
    public Integer visitVariadicType(OCVariadicType type2) {
        return this.visitType(type2);
    }
}

