/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMultiTypeSubstitution
extends OCTypeSubstitution {
    private List<OCSimpleTypeSubstitution> mySubstitutions;

    public OCMultiTypeSubstitution(List<OCSimpleTypeSubstitution> substitutions) {
        this.mySubstitutions = substitutions;
    }

    @Override
    public OCType substitute(@NotNull OCType type2, final @NotNull OCResolveContext context) {
        return type2.accept(new OCTypeSubstitution.TypeSubstituteVisitor(this, context){

            @Override
            public OCType visitTypeParameterType(OCTypeParameterType type2) {
                OCType partiallySubstitutedType = null;
                for (OCSimpleTypeSubstitution substitution : OCMultiTypeSubstitution.this.mySubstitutions) {
                    if (partiallySubstitutedType != null) {
                        partiallySubstitutedType = substitution.substitute(partiallySubstitutedType, context);
                        continue;
                    }
                    OCTypeArgument arg = substitution.getSubstitutionFor(type2.getSymbol());
                    if (arg == null) continue;
                    if (arg instanceof OCType) {
                        if (arg instanceof OCReferenceType) {
                            OCReferenceType result2 = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCMultiTypeSubstitution.this, context);
                            return result2.cloneWithAddedCVQualifiers(type2.getCVQualifiers(), context.getProject());
                        }
                        partiallySubstitutedType = (OCType)arg;
                        continue;
                    }
                    return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, context, true, 0));
                }
                return partiallySubstitutedType != null ? partiallySubstitutedType.cloneWithAddedCVQualifiers(type2.getCVQualifiers(), context.getProject()) : type2;
            }
        });
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        Set<OCTypeArgument> arguments = OCTypeUtils.newTypeSet();
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            arguments.addAll(substitution.getSubstitutedTypes());
        }
        return arguments;
    }

    @Override
    public boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> processor2) {
        for (OCSimpleTypeSubstitution substitution : this.mySubstitutions) {
            if (substitution.processSubstitutions(processor2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol argument) {
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            OCTypeArgument result2 = oCTypeSubstitution.getSubstitutionFor(argument);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        for (OCTypeSubstitution oCTypeSubstitution : this.mySubstitutions) {
            if (!oCTypeSubstitution.hasSubstitutionForName(name)) continue;
            return true;
        }
        return false;
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCMultiTypeSubstitution f = (OCMultiTypeSubstitution)first;
        OCMultiTypeSubstitution s = (OCMultiTypeSubstitution)second;
        return c.equalIterable(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public OCTypeSubstitution getMinimalDependentSubstitution(Object reference, @NotNull OCResolveContext context) {
        ArrayList<OCSimpleTypeSubstitution> list = new ArrayList<OCSimpleTypeSubstitution>();
        THashSet unusedSubstitutions = new THashSet(this.mySubstitutions);
        THashSet workset = new THashSet();
        workset.add(reference);
        while (!workset.isEmpty()) {
            THashSet newWorkset = new THashSet();
            for (Object substitution : unusedSubstitutions) {
                if (!((OCSimpleTypeSubstitution)substitution).dependsOn((Collection<Object>)workset, context)) continue;
                list.add((OCSimpleTypeSubstitution)substitution);
                newWorkset.add(substitution);
            }
            unusedSubstitutions.removeAll((Collection<?>)newWorkset);
            workset = newWorkset;
        }
        return list.isEmpty() ? ID : new OCMultiTypeSubstitution(list);
    }

    public String toString() {
        Function converter = substitution -> substitution.substList();
        return "{" + StringUtil.join((Collection)ContainerUtil.map(this.mySubstitutions, (Function)converter), (String)" // ") + "}";
    }

    public int hashCode() {
        return this.mySubstitutions != null ? this.mySubstitutions.hashCode() : 0;
    }

    public List<OCSimpleTypeSubstitution> getSubstitutions() {
        return this.mySubstitutions;
    }
}

