/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleTypeSubstitution
extends OCTypeSubstitution {
    @NotNull
    private Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutions;

    public OCSimpleTypeSubstitution() {
    }

    OCSimpleTypeSubstitution(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        this.mySubstitutions = substitutions;
    }

    @NotNull
    public Map<OCTypeParameterSymbol, OCTypeArgument> getSubstitutions() {
        return this.mySubstitutions;
    }

    public static OCSimpleTypeSubstitution create(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        return substitutions.isEmpty() ? ID : new OCSimpleTypeSubstitution((Map<OCTypeParameterSymbol, OCTypeArgument>)new HashMap(substitutions));
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        for (OCTypeParameterSymbol symbol : this.getTypeParameters()) {
            if (!name.equals(symbol.getName())) continue;
            return true;
        }
        return false;
    }

    public Set<OCTypeParameterSymbol> getTypeParameters() {
        return this.mySubstitutions.keySet();
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        return this.mySubstitutions.values();
    }

    @Override
    public boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> processor2) {
        return ContainerUtil.process(this.mySubstitutions.entrySet(), processor2);
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCSimpleTypeSubstitution f = (OCSimpleTypeSubstitution)first;
        OCSimpleTypeSubstitution s = (OCSimpleTypeSubstitution)second;
        return c.equalMaps(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public OCType substitute(@NotNull OCType type2, final @NotNull OCResolveContext context) {
        if (this != ID) {
            return type2.transformType(new OCTypeSubstitution.TypeSubstituteVisitor(this, context){

                @Override
                public OCType visitTypeParameterType(OCTypeParameterType type2) {
                    OCTypeArgument arg = (OCTypeArgument)OCSimpleTypeSubstitution.this.mySubstitutions.get(type2.getSymbol());
                    if (arg != null) {
                        if (arg instanceof OCType) {
                            OCType result2 = (OCType)arg;
                            if (arg instanceof OCReferenceType) {
                                result2 = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCSimpleTypeSubstitution.this, context);
                            }
                            return result2.cloneWithAddedCVQualifiers(type2.getCVQualifiers(), context.getProject());
                        }
                        return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, context, true, 0));
                    }
                    return type2;
                }
            });
        }
        return type2;
    }

    public static List<OCTemplateSymbol> resolveTemplateSpecialization(@NotNull List<OCTemplateSymbol> symbols, List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        OCTemplateSymbol substituted;
        Ref count;
        if (symbols.isEmpty()) {
            return symbols;
        }
        ArrayList<OCTemplateSymbol> predefinitions = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> nonSpecialized = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> specialized = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> result2 = new ArrayList<OCTemplateSymbol>();
        OCSimpleTypeSubstitution.divideSymbols(symbols, predefinitions, nonSpecialized, specialized);
        arguments = OCArgumentsList.expandVariadicTypes(arguments, resolver);
        List resolvedArguments = ContainerUtil.map(arguments, argument -> OCSimpleTypeSubstitution.resolveTypeArgument(resolver, Collections.emptyMap(), argument));
        boolean dependentType = OCSimpleTypeSubstitution.isDependentType(resolvedArguments, resolver);
        if (symbols.size() == 1) {
            OCTemplateSymbol symbol = symbols.get(0);
            Ref count2 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
            OCTemplateSymbol substituted2 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, specialized.isEmpty() ? symbol : null, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count2);
            if (specialized.isEmpty() || count2.get() != OCTypeUnificationVisitor.NOT_UNIFIED) {
                result2.add(substituted2);
            }
            return result2;
        }
        if (!specialized.isEmpty()) {
            OCTemplateSymbol bestSpecialization = null;
            OCTypeUnificationVisitor.UnificationResult bestSpecializationCount = OCTypeUnificationVisitor.NOT_UNIFIED;
            for (OCTemplateSymbol symbol : specialized) {
                Ref count3 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                OCTemplateSymbol baseSymbol = null;
                if (nonSpecialized.size() == 1) {
                    baseSymbol = nonSpecialized.get(0);
                } else if (predefinitions.size() == 1) {
                    baseSymbol = predefinitions.get(0);
                }
                if (symbol instanceof OCFunctionSymbol && !(baseSymbol instanceof OCFunctionSymbol)) {
                    baseSymbol = null;
                }
                OCTemplateSymbol substituted3 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, baseSymbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count3);
                if (!dependentType) {
                    if (symbol instanceof OCFunctionSymbol) {
                        if (((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter(bestSpecializationCount)) {
                            result2.clear();
                            result2.add(symbol);
                        } else if (!bestSpecializationCount.isBetter((OCTypeUnificationVisitor.UnificationResult)count3.get()) && count3.get() != OCTypeUnificationVisitor.NOT_UNIFIED) {
                            result2.add(symbol);
                        }
                    }
                    if (!((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter(bestSpecializationCount)) continue;
                    bestSpecialization = substituted3;
                    bestSpecializationCount = (OCTypeUnificationVisitor.UnificationResult)count3.get();
                    continue;
                }
                if (count3.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                result2.add(substituted3);
            }
            if (!dependentType && bestSpecialization != null && !(bestSpecialization instanceof OCFunctionSymbol)) {
                result2.add(bestSpecialization);
            }
        }
        if (result2.isEmpty() || dependentType || resolver.isIncompleteMode() && arguments.isEmpty()) {
            for (OCTemplateSymbol symbol : nonSpecialized) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, symbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (dependentType) {
                    result2.add(0, substituted);
                    continue;
                }
                result2.add(substituted);
            }
        }
        if (result2.isEmpty()) {
            for (OCTemplateSymbol symbol : predefinitions) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, symbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (nonSpecialized.size() == 1) {
                    count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                    substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(nonSpecialized.get(0), nonSpecialized.get(0), substituted, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                    if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                    result2.add(substituted);
                    continue;
                }
                result2.add(substituted);
            }
        }
        return result2;
    }

    protected static void divideSymbols(@NotNull List<OCTemplateSymbol> symbols, @NotNull List<OCTemplateSymbol> predefinitions, @NotNull List<OCTemplateSymbol> nonSpecialized, @NotNull List<OCTemplateSymbol> specialized) {
        for (OCTemplateSymbol symbol : symbols) {
            if (symbol instanceof OCStructSymbol && symbol.isPredeclaration()) {
                predefinitions.add(symbol);
                continue;
            }
            if (symbol.getTemplateSpecialization() != null) {
                specialized.add(symbol);
                continue;
            }
            nonSpecialized.add(symbol);
        }
    }

    private static boolean isDependentType(@NotNull List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        boolean dependentType = false;
        for (OCTypeArgument argument : arguments) {
            if (argument instanceof OCStructType) {
                if (((OCStructType)argument).getStructs().size() <= 1) continue;
                dependentType = true;
                continue;
            }
            if (!(argument instanceof OCMagicType) && (!(argument instanceof OCVariadicType) || !(((OCVariadicType)argument).getUnderlyingType() instanceof OCTypeParameterType)) && (!(argument instanceof OCExpressionTypeArgument) || OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), resolver) != null)) continue;
            dependentType = true;
            if (!(argument instanceof OCTypeParameterType)) continue;
            resolver.addTypeDependency(((OCTypeParameterType)argument).getSymbol());
        }
        return dependentType;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol param) {
        return this.mySubstitutions.get(param);
    }

    private static OCTemplateSymbol applyArgumentsToTemplateSymbol(@NotNull OCTemplateSymbol<?> symbol, @Nullable OCTemplateSymbol<?> baseSymbol, @Nullable OCTemplateSymbol<?> predefinition, @NotNull List<OCTypeArgument> resolvedArguments, @NotNull OCResolveContext resolver, @NotNull Ref<OCTypeUnificationVisitor.UnificationResult> specializationCount) {
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        int resolvedArgumentsCnt = resolvedArguments.size();
        boolean isNonExpandedVariadic = false;
        if (resolvedArgumentsCnt > 0 && ContainerUtil.getLastItem(resolvedArguments) instanceof OCVariadicType) {
            --resolvedArgumentsCnt;
            isNonExpandedVariadic = true;
        }
        if (!(specialization != null && specialization.size() >= resolvedArgumentsCnt || symbol.isVariadicTemplate() || baseSymbol != null && baseSymbol.getTemplateParameters().size() >= resolvedArgumentsCnt && !baseSymbol.isVariadicTemplate())) {
            specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
            return symbol;
        }
        if (specialization != null) {
            OCResolveContext paramResolveContext = resolver.clearSubstitution();
            paramResolveContext.setDontExpandVariadics(true);
            if (!OCArgumentsChecker.processArguments(specialization, resolvedArguments, (Function<OCTypeArgument, OCTypeArgument>)((Function)typeArgument -> OCSimpleTypeSubstitution.resolveTypeArgument(paramResolveContext, substitutionMap, typeArgument)), false, (parameter, argument) -> {
                if (OCSimpleTypeSubstitution.incompatibleArgument(parameter, argument, substitutionMap, resolver)) {
                    specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                    return false;
                }
                OCTypeUnificationVisitor.UnificationResult result2 = OCSimpleTypeSubstitution.unify(parameter, argument, substitutionMap, resolver);
                specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result2));
                if (parameter instanceof OCMagicType) {
                    ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                }
                return specializationCount.get() != OCTypeUnificationVisitor.NOT_UNIFIED;
            })) {
                return symbol;
            }
        }
        if (baseSymbol != null) {
            List<OCTypeParameterSymbol> parameters2 = baseSymbol.getTemplateParameters();
            for (int i2 = 0; i2 < parameters2.size(); ++i2) {
                OCTypeArgument argument2;
                OCTypeParameterSymbol parameterSymbol = parameters2.get(i2);
                Object defaultValue = parameterSymbol.getDefaultValue();
                OCTypeArgument parameter2 = new OCTypeParameterType(parameterSymbol);
                if (specialization != null && i2 >= specialization.size() && !(ContainerUtil.getLastItem(specialization) instanceof OCVariadicType) && defaultValue != null) {
                    parameter2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, defaultValue);
                }
                if (parameterSymbol.isVariadic()) break;
                if (i2 < resolvedArgumentsCnt) {
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, resolvedArguments.get(i2));
                } else if (predefinition != null) {
                    List<OCTypeParameterSymbol> predefParameters = predefinition.getTemplateParameters();
                    OCTypeArgument oCTypeArgument = argument2 = predefParameters.size() > i2 ? predefinition.getSubstitution().getSubstitutionFor(predefParameters.get(i2)) : null;
                    if (argument2 == null) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                } else {
                    if (defaultValue == null) {
                        if (!(baseSymbol instanceof OCStructSymbol) || isNonExpandedVariadic) break;
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, defaultValue);
                    if (specialization != null && i2 < specialization.size()) {
                        OCTypeArgument specializationParameter = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, specialization.get(i2));
                        OCTypeUnificationVisitor.UnificationResult result2 = OCSimpleTypeSubstitution.unify(specializationParameter, argument2, substitutionMap, resolver);
                        specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result2));
                        if (specializationParameter instanceof OCMagicType) {
                            ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                        }
                    }
                }
                OCTypeUnificationVisitor.UnificationResult result3 = OCSimpleTypeSubstitution.unify(parameter2, argument2, substitutionMap, resolver);
                specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result3));
            }
            if (baseSymbol.isVariadicTemplate()) {
                OCTypeParameterSymbol parameterSymbol = parameters2.get(parameters2.size() - 1);
                if (!(symbol instanceof OCFunctionSymbol)) {
                    substitutionMap.put(parameterSymbol, new OCExpansionPackType());
                }
                OCTypeParameterType parameter3 = new OCTypeParameterType(parameterSymbol);
                for (int i3 = parameters2.size() - 1; i3 < resolvedArguments.size(); ++i3) {
                    OCTypeArgument argument3 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, resolvedArguments.get(i3));
                    OCTypeUnificationVisitor.UnificationResult result4 = OCSimpleTypeSubstitution.unify(parameter3, argument3, substitutionMap, resolver);
                    specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result4));
                }
                if (specialization != null) {
                    int specializationsRequiredCnt = specialization.size();
                    OCTypeArgument lastArgument = (OCTypeArgument)ContainerUtil.getLastItem(specialization);
                    if (lastArgument != null && lastArgument.isVariadic()) {
                        --specializationsRequiredCnt;
                    }
                    if (resolvedArgumentsCnt < specializationsRequiredCnt && !isNonExpandedVariadic) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                }
            }
        }
        OCTypeSubstitution minimalSubstitution = resolver.getSubstitution().getMinimalDependentSubstitution(resolvedArguments, resolver);
        return OCSimpleTypeSubstitution.compose(OCSimpleTypeSubstitution.create(substitutionMap), minimalSubstitution, false, resolver).substitute(symbol, null, true, resolver);
    }

    private static boolean incompatibleArgument(@NotNull OCTypeArgument specializationParam, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext resolver) {
        resolver = resolver.substitute(OCSimpleTypeSubstitution.create(substitutionMap));
        if (specializationParam instanceof OCReferenceType && argument instanceof OCStructType) {
            boolean isStruct;
            OCReferenceType specializationType = (OCReferenceType)specializationParam;
            OCStructType argumentType = (OCStructType)argument;
            List<OCSymbol> specializationSymbols = specializationType.getReference(resolver).resolveToSymbols(true, true, false, resolver);
            boolean bl = isStruct = ContainerUtil.findInstance(specializationSymbols, OCStructSymbol.class) != null;
            if (isStruct && !specializationSymbols.contains(argumentType.getSymbol())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected static OCTypeArgument resolveTypeArgument(@NotNull OCResolveContext resolver, Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCTypeArgument argument) {
        return OCSimpleTypeSubstitution.resolveTypeArgument(argument, resolver.useFor(argument, OCSimpleTypeSubstitution.create(substitutionMap)));
    }

    @NotNull
    public static OCTypeArgument resolveTypeArgument(@NotNull OCTypeArgument argument, @NotNull OCResolveContext context) {
        OCExpressionSymbol expressionSymbol;
        OCSymbol symbol;
        Object value2;
        if (argument instanceof OCReferenceType && (value2 = OCExpressionEvaluator.evaluate(symbol = (OCSymbol)ContainerUtil.getFirstItem(context.resolveToSymbols(((OCReferenceType)argument).getReference(context))), context)) != null) {
            return new OCExpressionTypeArgument(new OCLiteralExpressionSymbol(value2.toString(), value2, null, null));
        }
        if (argument instanceof OCType) {
            argument = ((OCType)argument).transformType(new OCTypeResolveVisitor(context));
        } else if (argument instanceof OCExpressionTypeArgument && (value2 = (expressionSymbol = ((OCExpressionTypeArgument)argument).getSymbol()).evaluateToTypeArgument(context)) != null) {
            return value2;
        }
        return argument;
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext context) {
        return OCSimpleTypeSubstitution.unify(parameter, argument, null, substitutionMap, null, false, false, context);
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression2, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, boolean functionParametersMode, boolean isVariadicMode, @NotNull OCResolveContext context) {
        return new OCTypeUnificationVisitor(functionParametersMode, true, isVariadicMode, true, false, argument, expression2, substitutionMap, dependentTypes, context).unify(parameter, argument);
    }

    @NotNull
    String substList() {
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutions = this.mySubstitutions;
        Function converter = entry -> {
            String valueString;
            String keyString = ((OCTypeParameterSymbol)entry.getKey()).toString();
            keyString = keyString.substring(keyString.indexOf(91));
            OCTypeArgument value2 = (OCTypeArgument)entry.getValue();
            if (value2 instanceof OCTypeParameterType) {
                valueString = ((OCTypeParameterType)value2).getSymbol().toString();
                valueString = "<param>" + valueString.substring(valueString.indexOf(91));
            } else if (value2 instanceof OCExpressionTypeArgument) {
                valueString = ((OCExpressionTypeArgument)value2).getSymbol().toString();
                valueString = "<value>" + valueString.substring(valueString.indexOf(91));
            } else {
                valueString = value2.toString();
            }
            return keyString + " -> " + valueString;
        };
        return StringUtil.join((Collection)ContainerUtil.map(substitutions.entrySet(), (Function)converter), (String)", ");
    }

    public String toString() {
        return "{" + this.substList() + "}";
    }

    public int hashCode() {
        return this.mySubstitutions.hashCode();
    }
}

