/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeCloneVisitor
implements OCTypeVisitor<OCType> {
    private final boolean isShallow;
    @Nullable
    private final OCType myRootType;
    private final Boolean myForcedConst;
    private final Boolean myForcedVolatile;
    private int myDepth;

    public OCTypeCloneVisitor(boolean shallow) {
        this(shallow, null, null, null);
    }

    public OCTypeCloneVisitor(boolean shallow, @Nullable OCType rootType, @Nullable Boolean forcedConstValue, @Nullable Boolean forcedVolatileValue) {
        this.isShallow = shallow;
        this.myRootType = rootType;
        this.myForcedConst = forcedConstValue;
        this.myForcedVolatile = forcedVolatileValue;
    }

    private OCType cloneKid(OCType kid) {
        if (this.isShallow || this.myDepth >= 256) {
            return kid;
        }
        ++this.myDepth;
        OCType result2 = kid.transformType(this);
        --this.myDepth;
        return result2;
    }

    private boolean isConstCopy(@NotNull OCType original) {
        boolean allowedToForceConst;
        boolean bl = allowedToForceConst = this.myRootType != null && this.myRootType.getArrayElementType() == original.getArrayElementType();
        if (allowedToForceConst && this.myForcedConst != null) {
            return this.myForcedConst;
        }
        return original.isConst();
    }

    private boolean isVolatileCopy(@NotNull OCType original) {
        return this.myForcedVolatile != null ? this.myForcedVolatile.booleanValue() : original.isVolatile();
    }

    @Override
    public OCType visitEllipsisReferenceType(OCEllipsisType type2) {
        return OCEllipsisType.instance();
    }

    @Override
    public OCType visitFunctionType(OCFunctionType type2) {
        List<OCType> oldParamTypes = type2.getParameterTypes(true);
        List<String> oldParamNames = type2.getParameterNames(true);
        ArrayList<OCType> clonedArgs = new ArrayList<OCType>(oldParamTypes.size());
        for (OCType argumentType : oldParamTypes) {
            clonedArgs.add(this.cloneKid(argumentType));
        }
        ArrayList<String> clonedNames = oldParamNames != null ? new ArrayList<String>(oldParamNames) : null;
        return new OCFunctionType(this.cloneKid(type2.getReturnType()), clonedArgs, clonedNames, this.isConstCopy(type2), this.isVolatileCopy(type2), type2.isLValueRef(), type2.isRValueRef());
    }

    @Override
    public OCType visitMagicType(OCMagicType type2) {
        return new OCMagicType(type2.getName(), type2.getGuessedType(), false, false);
    }

    @Override
    public OCType visitObjectType(OCObjectType type2) {
        OCObjectType result2 = new OCObjectType(type2.getInterface(), type2.getImplementation(), type2.getAllProtocols(), type2.getAugmentedProtocols(), type2.getCategoryInterfaces(), type2.getCategoryImplementations(), type2.getSuperType(), this.isConstCopy(type2), this.isVolatileCopy(type2), type2.isKindof());
        result2.attachNullability(type2.getNullability());
        return result2;
    }

    @Override
    public OCType visitArrayType(OCArrayType type2) {
        OCType forcedClone = type2.getRefType().transformType(this);
        return OCArrayType.to(forcedClone, type2.getLength(), type2.getARCAttribute());
    }

    @Override
    public OCType visitPointerType(OCPointerType type2) {
        OCType qualifier = type2.getClassQualifier() != null ? this.cloneKid(type2.getClassQualifier()) : null;
        OCPointerType clone = OCPointerType.to(this.cloneKid(type2.getRefType()), type2.getARCAttribute(), qualifier, type2.getNullability(), this.isConstCopy(type2), this.isVolatileCopy(type2));
        clone.setLengthInBrackets(type2.getLengthInBrackets());
        return clone;
    }

    @Override
    public OCType visitBlockPointerType(OCBlockPointerType type2) {
        return OCBlockPointerType.blockPtr(this.cloneKid(type2.getRefType()), type2.getARCAttribute(), type2.getNullability(), this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitCppReferenceType(OCCppReferenceType type2) {
        OCType inner = this.cloneKid(type2.getRefType());
        boolean isConst = this.isConstCopy(type2);
        boolean isVolatile = this.isVolatileCopy(type2);
        return type2.isRvalueRef() ? OCCppReferenceType.to(inner, true, isConst, isVolatile) : OCCppReferenceType.to(inner, false, isConst, isVolatile);
    }

    @Override
    public OCType visitIdType(OCIdType type2) {
        OCIdType result2 = new OCIdType(type2.getAllProtocols(), type2.getAugmentedProtocols(), type2.getProject(), this.isConstCopy(type2), this.isVolatileCopy(type2));
        result2.attachNullability(type2.getNullability());
        return result2;
    }

    @Override
    public OCType visitIntType(OCIntType type2) {
        return type2.cloneType(this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitRealType(OCRealType type2) {
        return type2.cloneType(this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitReferenceType(OCReferenceType type2) {
        OCReferenceTypeBuilder resultBuilder = new OCReferenceTypeBuilder(type2.getReference());
        resultBuilder.setProtocolSubstitutionARCFromType(type2);
        resultBuilder.setConstVolatile(this.isConstCopy(type2), this.isVolatileCopy(type2));
        resultBuilder.setFunctionParameterType(type2.isFunctionParameterType());
        resultBuilder.setIsKindof(type2.isKindof());
        resultBuilder.setNullability(type2.getNullability());
        return resultBuilder.build();
    }

    @Override
    public OCType visitStructType(OCStructType type2) {
        return new OCStructType(type2.getStructs(), type2.getTypedefName(), this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitUnknownType(OCUnknownType type2) {
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCType visitVoidType(OCVoidType type2) {
        return OCVoidType.instance(this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitTypeParameterType(OCTypeParameterType type2) {
        return new OCTypeParameterType(type2.getSymbol(), this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitAutoType(OCAutoType type2) {
        return new OCAutoType(type2.getExpressionSymbol(), type2.getExpressionElement(), type2.getIncompleteType(), type2.getLambdaExpression(), type2.getParameterIndex(), type2.needsAutoParamsResolving(), this.isConstCopy(type2), this.isVolatileCopy(type2));
    }

    @Override
    public OCType visitVariadicType(OCVariadicType type2) {
        return new OCVariadicType(this.cloneKid(type2.getUnderlyingType()));
    }

    @Override
    public OCType visitExpansionPackType(OCExpansionPackType type2) {
        return new OCExpansionPackType(ContainerUtil.map(type2.getExpansions(), typeArgument -> typeArgument instanceof OCType ? ((OCType)typeArgument).transformType(new OCTypeCloneVisitor(this.isShallow, (OCType)typeArgument, this.myForcedConst, this.myForcedVolatile)) : typeArgument));
    }
}

