/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddSuperProtocolIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeMapper;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_AlwaysOk;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCArrayType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCAutoType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCBlockPointerType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCEllipsisType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCFunctionType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCIdType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCIntType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCObjectType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCPointerType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCRealType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCReferenceType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCStructType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeCompatibilityVisitor<T extends OCType>
implements OCTypeVisitor<OCType.TypeCheckResult> {
    public static final OCType.TypeCheckResult OK_RESULT = new OCType.TypeCheckResult(OCType.TypeCheckState.OK);
    @NotNull
    protected final T mySourceType;
    @Nullable
    protected final OCTypeOwner mySource;
    @Nullable
    protected final PsiElement myContext;
    protected final boolean myAllowImplicitConversions;
    protected final boolean myAssumeNullSubstitutionsEquals;
    @NotNull
    protected final OCResolveContext myResolveContext;

    public static OCType.TypeCheckResult checkConvertible(OCType destType, OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean allowImplicitConstructors, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        OCType.TypeCheckResult result2;
        boolean usingZeroAsNil = false;
        if (sourceType instanceof OCIntType) {
            if (source instanceof OCLiteralExpression || source instanceof OCLiteralExpressionSymbol) {
                sourceType = source.getResolvedType(resolveContext);
            }
            OCPointerType destTypePtr = null;
            if (destType instanceof OCPointerType) {
                destTypePtr = (OCPointerType)destType;
            } else if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType() instanceof OCPointerType) {
                destTypePtr = (OCPointerType)((OCCppReferenceType)destType).getRefType();
            }
            if (destTypePtr != null) {
                OCType pointerType = OCExpressionEvaluator.getPointerType(source, resolveContext);
                if (pointerType instanceof OCUnknownType) {
                    if (destTypePtr.isPointerToPointerToObjectCompatible()) {
                        usingZeroAsNil = true;
                    } else if (!(destTypePtr instanceof OCArrayType) || !((OCArrayType)destTypePtr).hasLength()) {
                        return OK_RESULT;
                    }
                } else if (pointerType != null) {
                    sourceType = pointerType;
                }
            }
        } else if (sourceType.isPointerToVoid() && OCExpressionEvaluator.isLikeNil(source, resolveContext)) {
            sourceType = destType;
        }
        if (source instanceof OCCompoundInitializer) {
            return OCTypeCompatibilityVisitor.checkCompoundInitializer((OCCompoundInitializer)source, destType, allowImplicitConversions && allowImplicitConstructors, resolveContext);
        }
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context, allowImplicitConversions && allowImplicitConstructors, assumeNullSubstitutionsEquals, resolveContext);
        OCType.TypeCheckResult check = destType.accept(visitor);
        if (check.getState() == OCType.TypeCheckState.OK) {
            return check;
        }
        if (usingZeroAsNil && source instanceof OCExpression) {
            if (OCCodeInsightUtil.isLikeNull(((OCExpression)source).getTextWithMacros())) {
                return OK_RESULT;
            }
            OCType.TypeCheckResult result3 = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, "Using zero as nil", OCInspections.UsingZeroAsNil.class, "CIDR", new IntentionAction[0]);
            TextRange range = OCElementUtil.getRangeWithMacros((PsiElement)source);
            OCChangeTextIntentionAction fix = new OCChangeTextIntentionAction(((PsiElement)source).getContainingFile(), range.getStartOffset(), range.getLength(), "nil", "Change to 'nil'");
            result3.setQuickFixes(new IntentionAction[]{fix});
            return result3;
        }
        if (allowImplicitConversions && visitor.mySourceType instanceof OCStructType && (result2 = OCTypeCompatibilityVisitor.checkConversionOperators(destType, (OCStructType)visitor.mySourceType, visitor.mySource, visitor.myContext, check, context instanceof OCCastExpression, resolveContext)) != null) {
            return result2;
        }
        return check;
    }

    public static OCType.TypeCheckResult checkConversionOperators(OCType destType, OCStructType sourceType, @Nullable OCTypeOwner source, PsiElement context, @Nullable OCType.TypeCheckResult bestResult, boolean isExplicitCast, @NotNull OCResolveContext resolveContext) {
        Ref result2 = Ref.create((Object)bestResult);
        if (sourceType.isSubclassOfMagic(resolveContext)) {
            return OK_RESULT;
        }
        sourceType.processMembers(null, (Processor<OCSymbol>)((Processor)symbol -> {
            if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isCppConversionOperator() || !isExplicitCast && ((OCFunctionSymbol)symbol).isExplicit()) {
                return true;
            }
            OCType returnType = symbol.getEffectiveResolvedType();
            if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType().isScalar() && !(returnType instanceof OCCppReferenceType)) {
                return true;
            }
            OCTypeCompatibilityVisitor<OCType> visitor1 = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(returnType, source, context, false, true, resolveContext);
            final OCType.TypeCheckResult curResult = destType.accept(visitor1);
            if (result2.isNull() || curResult.getState().compareTo(((OCType.TypeCheckResult)result2.get()).getState()) < 0 || curResult.getState() == ((OCType.TypeCheckResult)result2.get()).getState() && OCTypeCompatibilityVisitor.getTypesDifference(returnType, destType, resolveContext) < OCTypeCompatibilityVisitor.getTypesDifference(((OCType.TypeCheckResult)result2.get()).getTypeAfterConversion(), destType, resolveContext)) {
                if (curResult.getState() == OCType.TypeCheckState.OK) {
                    OCType.TypeCheckResult newResult = new OCType.TypeCheckResult(OCType.TypeCheckState.OK, curResult.getInspectionClass(), curResult.getClangID(), null, returnType, new IntentionAction[0]){

                        @Override
                        public String getMessage() {
                            return curResult.getMessage();
                        }
                    };
                    newResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                    result2.set((Object)newResult);
                } else {
                    curResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                    curResult.setConversion(null, returnType);
                    result2.set((Object)curResult);
                }
            }
            return true;
        }), resolveContext);
        return (OCType.TypeCheckResult)result2.get();
    }

    public static OCType.TypeCheckResult checkConstructors(OCStructType destType, OCType sourceType, OCTypeOwner source, @NotNull OCResolveContext context) {
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context.getElement(), false, true, context);
        for (OCStructSymbol struct : destType.getStructs()) {
            OCType.TypeCheckResult result2 = visitor.processConstructors(struct);
            if (result2 == null) continue;
            return result2;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR);
    }

    protected OCTypeCompatibilityVisitor(@NotNull T sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        this.mySourceType = sourceType;
        this.myResolveContext = resolveContext;
        this.mySource = source;
        this.myContext = context;
        this.myAllowImplicitConversions = allowImplicitConversions;
        this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
    }

    public static OCTypeCompatibilityVisitor<? extends OCType> createOCTypeCompatibilityVisitor(@Nullable OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            sourceType = OCUnknownType.INSTANCE;
        }
        return sourceType.accept(new OCTypeCompatibilityVisitorCreator(source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext));
    }

    @Override
    public OCType.TypeCheckResult visitCppReferenceType(final OCCppReferenceType type2) {
        if (this.mySource != null) {
            OCTypeOwner inner;
            if (!(type2.isReferenceToConst() || type2.isRvalueRef() || type2.isUnknown() || OCExprValueCategory.classify(this.mySource, this.myResolveContext).isLValue())) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "Expression must be lvalue", OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", new IntentionAction[0]);
            }
            if (!(!type2.isRvalueRef() || type2.getTerminalType() instanceof OCMagicType || type2.getTerminalType() instanceof OCAutoType || !OCExprValueCategory.classify(this.mySource, this.myResolveContext).isLValue() || (inner = OCParenthesesUtils.diveIntoParentheses(this.mySource)) instanceof OCLiteralExpression && ((OCLiteralExpression)inner).isStringLiteral())) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "Expression must be rvalue", OCInspections.NotAssignable.class, "err_typecheck_convert_incompatible", new IntentionAction[0]);
            }
        }
        OCType refType = type2.getRefType();
        if (((OCType)this.mySourceType).isConst() && !refType.isConst() && !refType.isUnknown()) {
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Binding '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' to non-const reference";
                }
            };
        }
        if (!(!refType.isScalar() && !((OCType)this.mySourceType).isScalar() || refType.isConst() || type2.isRvalueRef() || refType instanceof OCEllipsisType || this.myContext instanceof OCCastExpression)) {
            if (new OCTypeEqualityVisitor((OCType)this.mySourceType, true, false, false, false, false, true, true, this.myResolveContext).equal(refType)) {
                return OK_RESULT;
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible types '" + type2.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.checkRefType(type2);
    }

    protected OCType.TypeCheckResult checkRefType(OCCppReferenceType type2) {
        return type2.getRefType().accept(this);
    }

    public static int getTypesDifference(@Nullable OCType type1, @Nullable OCType type2, @NotNull OCResolveContext context) {
        if (type1 == null || type2 == null) {
            return -1;
        }
        if (type1 instanceof OCArrayType && type2 instanceof OCPointerType || type2 instanceof OCArrayType && type1 instanceof OCPointerType) {
            return 100 + OCTypeCompatibilityVisitor.getTypesDifference(((OCPointerType)type1).getRefType(), ((OCPointerType)type2).getRefType(), context);
        }
        if (!(type2.getClass().equals(type1.getClass()) || type1.equals((Object)OCIntType.INT, context) && type2 instanceof OCStructType && ((OCStructType)type2).isEnum() || type2.equals((Object)OCIntType.INT, context) && type1 instanceof OCStructType && ((OCStructType)type1).isEnum())) {
            return 1000;
        }
        if (type1 instanceof OCIntType && type2 instanceof OCIntType) {
            OCIntType intType1 = (OCIntType)type1;
            OCIntType intType2 = (OCIntType)type2;
            int rank1 = intType1.getCTypeId().ordinal() * 2 + (intType1.isSigned() ? 0 : 1);
            int rank2 = intType2.getCTypeId().ordinal() * 2 + (intType2.isSigned() ? 0 : 1);
            return Math.abs(rank1 - rank2);
        }
        if (!type2.equals((Object)type1, context)) {
            if (type1 instanceof OCCppReferenceType) {
                type1 = ((OCCppReferenceType)type1).getRefType();
            }
            if (type2 instanceof OCCppReferenceType) {
                type2 = ((OCCppReferenceType)type2).getRefType();
            }
            if (type2.equals(type1, false, context)) {
                return 50;
            }
            return type1.isUnknown() || type1.isMagicInside(context) ? 100 : 200;
        }
        return 0;
    }

    protected boolean bothTypesEquals(OCType type2, OCType firstType, OCType secondType) {
        return type2.equals(firstType, false, this.myResolveContext) && type2.equals(secondType, false, this.myResolveContext);
    }

    protected OCType.TypeCheckResult visitType(final OCType type2) {
        boolean unknown;
        if (this.mySourceType instanceof OCMagicType || type2 instanceof OCAutoType || this.mySourceType instanceof OCAutoType) {
            return OK_RESULT;
        }
        boolean bl = unknown = type2.isUnknown() || ((OCType)this.mySourceType).isUnknown();
        if (unknown && type2.getCanonicalName(this.myContext).equals(((OCType)this.mySourceType).getCanonicalName(this.myContext))) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "CIDR", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Types '" + type2.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' are not compatible";
            }
        };
    }

    protected String getSourceTypeName() {
        return this.mySource instanceof OCExpression ? ((OCExpression)this.mySource).findBestTypeName((OCType)this.mySourceType) : ((OCType)this.mySourceType).getName(this.myResolveContext);
    }

    @NotNull
    protected OCType.TypeCheckResult visitNumericType(final OCNumericType type2) {
        if (this.mySourceType instanceof OCMagicType) {
            return OK_RESULT;
        }
        if (this.mySourceType instanceof OCNumericType) {
            OCNumericType numericType = (OCNumericType)this.mySourceType;
            if (OCIntType.isBool(type2, this.myContext) && OCIntType.isBool(this.mySourceType, this.myContext)) {
                return OK_RESULT;
            }
            if (type2.getRank(this.myContext) < numericType.getRank(this.myContext)) {
                OCTypeOwner source;
                if (this.mySource != null && this.mySourceType instanceof OCIntType && type2 instanceof OCIntType) {
                    Number value2 = OCExpressionEvaluator.evaluate(this.mySource, this.myResolveContext);
                    if (value2 != null && ((OCIntType)type2).canRepresent(OCNumber.valueOf(value2), this.myContext)) {
                        return OK_RESULT;
                    }
                    if (value2 == null && type2.getCTypeId().equals((Object)((OCIntType)this.mySourceType).getCTypeId())) {
                        return OK_RESULT;
                    }
                    if (((OCIntType)this.mySourceType).getCTypeId() == OCTypeMapper.CTypeId.SIZE_T) {
                        return OK_RESULT;
                    }
                }
                if (this.mySource != null && this.mySourceType instanceof OCRealType && type2 instanceof OCRealType && (source = OCParenthesesUtils.diveIntoParentheses(this.mySource)) instanceof OCLiteralExpression && OCRealType.narrowestLiteralType(((OCLiteralExpression)source).getUnescapedLiteralText()).getRank(this.myContext) == type2.getRank(this.myContext)) {
                    return OK_RESULT;
                }
                return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ValueMayNotFitIntoReceiver.class, "warn_impcast_integer_precision", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' may not fit into the receiver type '" + type2.getName(OCTypeCompatibilityVisitor.this.myContext) + "'";
                    }
                };
            }
            if (!type2.isComplex() && numericType.isComplex()) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ValueMayNotFitIntoReceiver.class, "warn_impcast_complex_scalar", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Using '" + type2.getName(OCTypeCompatibilityVisitor.this.myContext) + "' for complex values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                    }
                };
            }
            if (!(type2.isSigned() || !numericType.isSigned() || this.mySource != null && this.mySourceType instanceof OCIntType && OCExpressionEvaluator.isPositive(this.mySource, this.myResolveContext))) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.SignednessMismatch.class, "warn_impcast_integer_sign", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Using '" + type2.getName(OCTypeCompatibilityVisitor.this.myContext) + "' for signed values of type '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
                    }
                };
            }
            return OK_RESULT;
        }
        if (this.mySourceType instanceof OCStructType && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).isEnumClass()) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking integer from enum class '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
            }
            return OK_RESULT;
        }
        if (((OCType)this.mySourceType).isPointerCompatible(this.myContext, false)) {
            if (OCIntType.isBool(type2, this.myContext)) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_pointer_int", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking boolean from pointer '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
            }
            if (type2 instanceof OCIntType) {
                return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR_IF_CPP, OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_pointer_int", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Taking integer from pointer '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' without a cast";
                    }
                };
            }
            return this.visitType(type2);
        }
        return this.visitType(type2);
    }

    @NotNull
    protected OCType.TypeCheckResult checkStructCompatibleCtor(OCStructType type2) {
        for (OCStructSymbol struct : type2.getStructs()) {
            OCType.TypeCheckResult result2 = this.processTransparentUnion(struct, type2);
            if (result2 != null) {
                return result2;
            }
            if (this.myAllowImplicitConversions) {
                result2 = this.processConstructors(struct);
            }
            if (result2 == null) continue;
            return result2;
        }
        OCType.TypeCheckResult result3 = this.visitType(type2);
        if (result3 != OK_RESULT && this.isCppClassType(type2)) {
            result3.setQuickFixes(new IntentionAction[]{this.getNewConstructorFix(type2.getSymbol())});
        }
        return result3;
    }

    @NotNull
    protected OCType.TypeCheckResult checkAssignToEnum(OCStructType type2, Computable<String> message2) {
        OCType.TypeCheckState state = OCType.TypeCheckState.ERROR_IF_CPP;
        Number value2 = OCExpressionEvaluator.evaluate(this.mySource, this.myResolveContext);
        if (value2 != null && this.mySource instanceof OCExpression) {
            OCSymbol enumConst = OCExpressionEvaluator.findMatchingEnumConst(type2, value2.intValue(), this.myResolveContext);
            if (enumConst != null) {
                OCExpression element = OCElementFactory.expressionFromText(enumConst.getName(), (PsiElement)this.mySource, false);
                if (element != null) {
                    OCChangeElementIntentionAction quickFix = new OCChangeElementIntentionAction((PsiElement)this.mySource, (PsiElement)element, "Use constant '" + enumConst.getName() + "'", "Use enum constant");
                    final Computable finalMessage = message2;
                    return new OCType.TypeCheckResult(state, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[]{quickFix}){

                        @Override
                        public String getMessage() {
                            return (String)finalMessage.compute();
                        }
                    };
                }
            } else {
                String typeName = type2.getBestNameInContext(this.myContext);
                if (value2.intValue() == 0 && typeName.endsWith("Options")) {
                    return OK_RESULT;
                }
                message2 = () -> "Enum '" + typeName + "' has no constant to represent the integer value '" + value2 + "'";
            }
        }
        final Computable finalMessage = message2;
        return new OCType.TypeCheckResult(state, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return (String)finalMessage.compute();
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitEllipsisReferenceType(OCEllipsisType type2) {
        return OK_RESULT;
    }

    protected boolean isSuperTypeForFunctionChecks(OCType left, OCType right) {
        if (left.isPointerToObject() && right.isPointerToObject()) {
            return left.isCompatible(right, this.myContext);
        }
        if (left instanceof OCIntType && right instanceof OCStructType && ((OCStructType)right).getKind() == OCSymbolKind.ENUM && !((OCStructType)right).isEnumClass()) {
            return true;
        }
        if (right instanceof OCIntType && left instanceof OCStructType && ((OCStructType)left).getKind() == OCSymbolKind.ENUM && !((OCStructType)left).isEnumClass()) {
            return true;
        }
        PsiFile file2 = this.myContext != null ? this.myContext.getContainingFile() : null;
        return new OCTypeEqualityAfterResolvingVisitor(right, false, true, false, false, true, new OCResolveContext((PsiElement)file2)).equal(left);
    }

    @Override
    public OCType.TypeCheckResult visitArrayType(OCArrayType type2) {
        boolean allowArraysAssignment;
        boolean bl = allowArraysAssignment = !this.myAssumeNullSubstitutionsEquals;
        if (allowArraysAssignment && this.mySourceType instanceof OCArrayType && ((OCArrayType)this.mySourceType).getLength() == type2.getLength()) {
            return OK_RESULT;
        }
        if (!type2.hasLength()) {
            return (OCType.TypeCheckResult)this.visitPointerType(type2);
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.NotAssignable.class, "err_typecheck_array_not_modifiable_lvalue", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Array is not assignable";
            }
        };
    }

    protected boolean isCppClassType(OCType type2) {
        return ((OCFile)this.myContext.getContainingFile()).isCpp() && type2 instanceof OCStructType && ((OCStructType)type2).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    protected OCType.TypeCheckResult checkArcBridgeCast(final OCPointerType type2, boolean tollFreeBridge) {
        boolean isCast;
        boolean bl = isCast = this.mySource instanceof OCExpression && ((OCExpression)this.mySource).getParent() instanceof OCCastExpression;
        if (this.mySource instanceof OCLiteralExpression && ((OCType)this.mySourceType).isPointerToString()) {
            return null;
        }
        if (this.mySource instanceof OCSendMessageExpression && ((OCType)this.mySourceType).isPointerToVoid()) {
            return null;
        }
        if (type2.getRefType().isVoid() && !((OCType)this.mySourceType).isPointerToObjectCompatible() && ((OCType)this.mySourceType).isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && ((OCType)this.mySourceType).isPointerToVoid() && !type2.isPointerToObjectCompatible() && type2.isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && (type2.isPointerToObjectCompatible() || ((OCType)this.mySourceType).isPointerToObjectCompatible())) {
            if (type2.isPointerToObject()) {
                OCSymbol symbol;
                if (this.mySource instanceof OCCallExpression) {
                    symbol = OCGetSymbolVisitor.getSymbol(((OCCallExpression)this.mySource).getFunctionReferenceExpression());
                } else if (this.mySource instanceof OCSendMessageExpression) {
                    symbol = ((OCSendMessageExpression)this.mySource).getProbableResponders().getKnownResponder();
                    if (symbol != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                } else {
                    symbol = OCGetSymbolVisitor.getSymbol((OCExpression)this.mySource);
                }
                if (symbol instanceof OCFunctionSymbol && symbol.hasAttribute("ImplicitBridging")) {
                    return null;
                }
                if (symbol instanceof OCPropertySymbol) {
                    return null;
                }
                if (symbol instanceof OCDeclaratorSymbol && !OCSearchScope.isInProjectSources(symbol) && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION) {
                    return null;
                }
            }
            OCTypeElement parent = ((OCCastExpression)((OCExpression)this.mySource).getParent()).getTypeElement();
            IElementType[] types = OCTokenTypes.BRIDGE_CAST_KEYWORDS.getTypes();
            IntentionAction[] quickFixes = new IntentionAction[types.length];
            for (int i2 = 0; i2 < quickFixes.length; ++i2) {
                String tokenName = ((OCElementType)types[i2]).getName();
                quickFixes[i2] = new OCChangeTextIntentionAction(((OCExpression)this.mySource).getContainingFile(), parent.getTextOffset(), 0, tokenName + " ", "Add \"" + tokenName + "\"", "Add the bridge cast");
            }
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, "ARC bridge cast is required", OCInspections.BridgeCastIssues.class, "CIDR", quickFixes);
        }
        if (tollFreeBridge) {
            String message2 = "ARC bridge cast is required for toll free bridge";
            return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, message2, OCInspections.BridgeCastIssues.class, "CIDR", new IntentionAction[0]);
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Incompatible types '" + type2.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "'";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitBlockPointerType(OCBlockPointerType type2) {
        return (OCType.TypeCheckResult)this.visitPointerType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitIdType(OCIdType type2) {
        return (OCType.TypeCheckResult)this.visitObjectType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitIntType(OCIntType type2) {
        return this.visitNumericType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitRealType(OCRealType type2) {
        return this.visitNumericType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitReferenceType(OCReferenceType type2) {
        return this.visitType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitAutoType(OCAutoType type2) {
        return OK_RESULT;
    }

    protected OCCreateNewDefinitionIntentionAction getNewConstructorFix(OCStructSymbol struct) {
        OCExpression psiSourceExpr = this.mySource instanceof OCExpression ? (OCExpression)this.mySource : null;
        return new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, this.myContext, struct, struct.getName(), new OCFunctionType(OCVoidType.instance(), Collections.singletonList(OCExpectedTypeUtil.getExpressionType(psiSourceExpr, this.mySourceType, true))));
    }

    @Nullable
    protected OCType.TypeCheckResult processConstructors(OCStructSymbol struct) {
        OCArgumentsList arguments = new OCArgumentsList(Collections.singletonList(this.mySourceType), this.mySource != null ? Collections.singletonList(this.mySource) : null);
        OCSymbol constructor = struct.getType().findConstructor(arguments, this.myResolveContext, false, true, (Producer<Boolean>)((Producer)() -> {
            if (this.myContext instanceof OCCallExpression) {
                OCSymbol symbol = OCGetSymbolVisitor.getSymbol(((OCCallExpression)this.myContext).getFunctionReferenceExpression());
                return symbol instanceof OCStructSymbol || symbol != null && symbol.getKind() == OCSymbolKind.TYPEDEF;
            }
            return false;
        }));
        if (constructor instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol && ((OCResolveOverloadsUtil.OCFunctionGroupSymbol)constructor).getCause() != OCResolveOverloadsUtil.OCFunctionGroupSymbol.Cause.Magic) {
            return null;
        }
        if (constructor instanceof OCFunctionSymbol) {
            List<OCType> types = ((OCFunctionSymbol)constructor).getType().getParameterTypes();
            OCType argumentType = types.get(0).resolve(this.myResolveContext);
            OCType.TypeCheckResult result2 = OCTypeCompatibilityVisitor.checkConvertible(argumentType, this.mySourceType, this.mySource, this.myContext, false, false, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
            if (result2 == OK_RESULT) {
                result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.OK, null, null, argumentType, struct.getType(), new IntentionAction[0]);
            } else {
                result2.setConversion(argumentType, struct.getType());
            }
            result2.setImplicitConstructor((OCFunctionSymbol)constructor);
            return result2;
        }
        return null;
    }

    @Nullable
    protected OCType.TypeCheckResult processTransparentUnion(final OCStructSymbol struct, OCStructType type2) {
        if (type2.getKind() != OCSymbolKind.UNION || !struct.isTransparentUnion()) {
            return null;
        }
        final Ref result2 = Ref.create(null);
        CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol> finder = new CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol>(){

            protected boolean accept(OCDeclaratorSymbol field) {
                OCType.TypeCheckResult curResult = field.getType().resolve(struct.getContainingOCFile()).checkCompatible((OCType)OCTypeCompatibilityVisitor.this.mySourceType, OCTypeCompatibilityVisitor.this.mySource, OCTypeCompatibilityVisitor.this.myContext);
                if (curResult.getState() == OCType.TypeCheckState.OK) {
                    result2.set((Object)curResult);
                    return true;
                }
                if (!curResult.getState().isError(OCTypeCompatibilityVisitor.this.myContext) && result2.isNull()) {
                    result2.set((Object)curResult);
                }
                return false;
            }
        };
        struct.processFields((Processor<OCDeclaratorSymbol>)finder);
        return (OCType.TypeCheckResult)result2.get();
    }

    @Override
    public OCType.TypeCheckResult visitVariadicType(OCVariadicType type2) {
        return OK_RESULT;
    }

    @Override
    public OCType.TypeCheckResult visitExpansionPackType(OCExpansionPackType type2) {
        return OK_RESULT;
    }

    @Override
    public OCType.TypeCheckResult visitUnknownType(OCUnknownType type2) {
        return this.visitMagicType(type2);
    }

    @Override
    public OCType.TypeCheckResult visitMagicType(OCMagicType type2) {
        return OK_RESULT;
    }

    @Override
    public OCType.TypeCheckResult visitVoidType(final OCVoidType type2) {
        if (((OCType)this.mySourceType).isVoid() || this.mySourceType instanceof OCMagicType || this.myContext instanceof OCCastExpression) {
            return OK_RESULT;
        }
        return new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, OCInspections.IncompatibleTypes.class, "err_typecheck_convert_incompatible", new IntentionAction[0]){

            @Override
            public String getMessage() {
                return "Types '" + type2.getName(OCTypeCompatibilityVisitor.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' are not compatible";
            }
        };
    }

    @Override
    public OCType.TypeCheckResult visitTypeParameterType(OCTypeParameterType type2) {
        return this.visitMagicType(type2);
    }

    public static OCType.TypeCheckResult checkCompoundInitializer(OCCompoundInitializer compInitializer, OCType type2, boolean allowImplicitConversions, final @NotNull OCResolveContext context) {
        final ArrayList results = new ArrayList();
        OCArgumentsChecker checker = new OCArgumentsChecker(){

            @Override
            protected void checkAssignment(OCExpression rOperand, PsiElement element, OCType lType, OCType rType, OCSymbol lSymbol, OCType symbolRequiredType, boolean allowImplicitConversions, boolean onlyWarnings, String messagePrefix) {
                OCType.TypeCheckResult result2 = lType.checkCompatible(rType, rOperand, rOperand, allowImplicitConversions, true, context);
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(rOperand);
                }
                results.add(result2);
            }

            @Override
            protected void checkAssignment(OCExpression rOperand, PsiElement element, OCType lType, OCType rType, String messagePrefix) {
                OCType.TypeCheckResult result2 = lType.checkCompatible(rType, rOperand, rOperand);
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(rOperand);
                }
                results.add(result2);
            }

            @Override
            @Nullable
            protected Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, final @NotNull String message2, @Nullable ProblemHighlightType highlightType, IntentionAction ... fixes) {
                if (highlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
                    return null;
                }
                OCType.TypeCheckResult result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, aClass, inspectionID, element, new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return message2;
                    }
                };
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(element);
                }
                results.add(result2);
                return null;
            }

            @Override
            @Nullable
            protected Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, final @NotNull String message2, IntentionAction ... fixes) {
                OCType.TypeCheckResult result2 = new OCType.TypeCheckResult(OCType.TypeCheckState.ERROR, inspectionClass, clangID, element, new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return message2;
                    }
                };
                if (!result2.getState().isOK() && result2.getAnnotationElement() == null) {
                    result2.setAnnotationElement(element);
                }
                results.add(result2);
                return null;
            }

            @Override
            protected void checkConstructor(OCCompoundInitializer compInitializer, OCSymbol symbol) {
                if (symbol instanceof OCFunctionSymbol) {
                    if (symbol instanceof OCResolveOverloadsUtil.OCFunctionGroupSymbol) {
                        symbol = ((OCResolveOverloadsUtil.OCFunctionGroupSymbol)symbol).getOverloads().get(0);
                    }
                    OCFunctionType functionType = (OCFunctionType)symbol.getType().resolve(compInitializer.getContainingFile());
                    this.checkFunctionArguments(compInitializer, functionType, Collections.singletonList(compInitializer), symbol);
                } else if (symbol instanceof OCStructSymbol) {
                    List<OCExpression> expressions2 = compInitializer.getInitializerExpressions();
                    if (expressions2.size() == 1) {
                        this.checkAssignment(expressions2.get(0), compInitializer, symbol.getType(), expressions2.get(0).getResolvedType(), "Parameter type mismatch: ");
                    } else if (expressions2.size() > 0 || !((OCStructSymbol)symbol).hasDefaultConstructor()) {
                        List argumentTypes = ContainerUtil.map(expressions2, expression2 -> OCExpectedTypeUtil.getExpressionType(expression2, true));
                        String message2 = OCCppChecker.getCantResolveCtorMessage(symbol, new OCFunctionType(OCVoidType.instance(), argumentTypes), compInitializer);
                        this.addErrorAnnotation(compInitializer, OCInspections.CannotResolve.class, "CIDR", message2, new IntentionAction[0]);
                    }
                }
            }
        };
        RecursionManager.doPreventingRecursion((Object)new Pair((Object)compInitializer, (Object)allowImplicitConversions), (boolean)false, () -> {
            checker.checkCompoundInitializer(compInitializer, type2, false, allowImplicitConversions);
            return null;
        });
        OCType.TypeCheckResult worst = OK_RESULT;
        for (OCType.TypeCheckResult state : results) {
            if (state.getState().ordinal() <= worst.getState().ordinal()) continue;
            worst = state;
        }
        return worst;
    }

    @Nullable
    protected OCType.TypeCheckResult checkAssignPointerToArray(OCArrayType type2) {
        if (type2.getRefType() instanceof OCIntType) {
            OCIntType dstRefType = (OCIntType)type2.getRefType();
            OCType refType = ((OCPointerType)this.mySourceType).getRefType();
            if ((OCIntType.CHAR.equals(dstRefType, false, this.myResolveContext) || OCIntType.UCHAR.equals(dstRefType, false, this.myResolveContext) || OCIntType.SCHAR.equals(dstRefType, false, this.myResolveContext)) && OCIntType.CHAR.equals(refType, false, this.myResolveContext)) {
                return OK_RESULT;
            }
            if (this.bothTypesEquals(OCIntType.WCHAR, dstRefType, refType)) {
                return OK_RESULT;
            }
            if (this.bothTypesEquals(OCIntType.CHAR16, dstRefType, refType)) {
                return OK_RESULT;
            }
            if (this.bothTypesEquals(OCIntType.CHAR32, dstRefType, refType)) {
                return OK_RESULT;
            }
        }
        return null;
    }

    @NotNull
    protected OCType.TypeCheckResult getProtocolCompatibilityCheckResult(@NotNull OCObjectType sourceType, @NotNull OCObjectType type2) {
        for (final OCProtocolSymbol protocol : type2.getAllProtocols()) {
            if (sourceType.implementsProtocol(protocol)) continue;
            final OCImplementation implementation = (OCImplementation)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCImplementation.class);
            final OCClassSymbol classSymbol = sourceType.getClassSymbol();
            return new OCType.TypeCheckResult(OCType.TypeCheckState.WARNING, OCInspections.NotImplementsProtocol.class, "CIDR", new IntentionAction[]{new OCAddSuperProtocolIntentionAction(sourceType.getInterface(), protocol.getName(), false), new OCAddSuperProtocolIntentionAction(sourceType.getImplementation(), protocol.getName(), true){

                @Override
                protected boolean isAvailable(OCClassSymbol myInterface) {
                    return implementation != null && classSymbol != null && classSymbol.getName().equals(implementation.getName()) && super.isAvailable(myInterface);
                }
            }}){

                @Override
                public String getMessage() {
                    return "Interface '" + OCTypeCompatibilityVisitor.this.getSourceTypeName() + "' doesn't implement " + protocol.getNameWithKindLowercase();
                }
            };
        }
        return OK_RESULT;
    }

    private static class OCTypeCompatibilityVisitorCreator
    implements OCTypeVisitor<OCTypeCompatibilityVisitor<? extends OCType>> {
        private final OCTypeOwner mySource;
        @Nullable
        private final PsiElement myContext;
        private final boolean myAllowImplicitConversions;
        private final boolean myAssumeNullSubstitutionsEquals;
        @NotNull
        private final OCResolveContext myResolveContext;

        public OCTypeCompatibilityVisitorCreator(@Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
            this.mySource = source;
            this.myContext = context;
            this.myAllowImplicitConversions = allowImplicitConversions;
            this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
            this.myResolveContext = resolveContext;
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitEllipsisReferenceType(OCEllipsisType sourceType) {
            return new OCTypeCompatibilityVisitor_OCEllipsisType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitFunctionType(OCFunctionType sourceType) {
            return new OCTypeCompatibilityVisitor_OCFunctionType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitMagicType(OCMagicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCMagicType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitObjectType(OCObjectType sourceType) {
            return new OCTypeCompatibilityVisitor_OCObjectType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitArrayType(OCArrayType sourceType) {
            return new OCTypeCompatibilityVisitor_OCArrayType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitPointerType(OCPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCPointerType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitBlockPointerType(OCBlockPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCBlockPointerType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitCppReferenceType(OCCppReferenceType sourceType) {
            OCTypeCompatibilityVisitor<? extends OCType> visitor = sourceType.getRefType(this.myContext).accept(this);
            return visitor;
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIdType(OCIdType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIdType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIntType(OCIntType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIntType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitRealType(OCRealType sourceType) {
            return new OCTypeCompatibilityVisitor_OCRealType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitReferenceType(OCReferenceType sourceType) {
            return new OCTypeCompatibilityVisitor_OCReferenceType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitStructType(OCStructType sourceType) {
            return new OCTypeCompatibilityVisitor_OCStructType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitUnknownType(OCUnknownType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCUnknownType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVoidType(OCVoidType sourceType) {
            return new OCTypeCompatibilityVisitor_OCVoidType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitTypeParameterType(OCTypeParameterType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCTypeParameterType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitAutoType(OCAutoType sourceType) {
            return new OCTypeCompatibilityVisitor_OCAutoType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVariadicType(OCVariadicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCVariadicType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitExpansionPackType(OCExpansionPackType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCExpansionPackType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }
    }
}

